/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelEnumeration;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelType;
import org.nuiton.eugene.models.object.xml.ObjectModelAttributeImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelEnumerationImpl;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.generator.TopiaGeneratorUtil;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.util.EntityOperator;
import org.nuiton.topia.persistence.util.EntityOperatorStore;

public class DAOHelperTransformer
extends ObjectModelTransformerToJava {
    private static final Log log = LogFactory.getLog(DAOHelperTransformer.class);

    public void transformFromModel(ObjectModel model) {
        String packageName = this.getOutputProperties().getProperty("defaultPackage");
        String modelName = model.getName();
        String daoHelperClazzName = modelName + "DAOHelper";
        String modelVersion = model.getVersion();
        ObjectModelClass resultClass = this.createClass(daoHelperClazzName, packageName);
        List<ObjectModelClass> classes = TopiaGeneratorUtil.getEntityClasses(model, true);
        boolean generateOperator = TopiaGeneratorUtil.shouldgenerateOperatorForDAOHelper(null, model);
        this.addImport((ObjectModelClassifier)resultClass, TopiaContextImplementor.class);
        this.addImport((ObjectModelClassifier)resultClass, TopiaDAO.class);
        this.addImport((ObjectModelClassifier)resultClass, TopiaEntity.class);
        this.addImport((ObjectModelClassifier)resultClass, TopiaContext.class);
        this.addImport((ObjectModelClassifier)resultClass, Array.class);
        this.addImport((ObjectModelClassifier)resultClass, Arrays.class);
        if (generateOperator) {
            this.addImport((ObjectModelClassifier)resultClass, EntityOperator.class);
            this.addImport((ObjectModelClassifier)resultClass, EntityOperatorStore.class);
        }
        String entityEnumName = modelName + "EntityEnum";
        ObjectModelOperation constructor = this.addConstructor(resultClass, ObjectModelModifier.PROTECTED);
        this.setOperationBody(constructor, " ");
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)resultClass, "getModelVersion", "String", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.setOperationBody(op, "\n        return \"" + modelVersion + "\";\n" + "    ");
        for (ObjectModelClass clazz : classes) {
            String clazzName = clazz.getName();
            String daoClazzName = clazzName + "DAO";
            op = this.addOperation((ObjectModelClassifier)resultClass, "get" + daoClazzName, clazz.getPackageName() + "." + daoClazzName, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
            this.addParameter(op, TopiaContext.class, "context");
            this.addImport((ObjectModelClassifier)resultClass, clazz);
            this.addException(op, TopiaException.class);
            this.setOperationBody(op, "\n        TopiaContextImplementor ci = (TopiaContextImplementor) context;\n        " + daoClazzName + " result = (" + daoClazzName + ") ci.getDAO(" + clazzName + ".class);\n" + "        return result;\n" + "    ");
        }
        op = this.addOperation((ObjectModelClassifier)resultClass, "getDAO", "<T extends TopiaEntity, D extends TopiaDAO<? super T>> D", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.addParameter(op, TopiaContext.class, "context");
        this.addParameter(op, "Class<T>", "klass");
        this.addException(op, TopiaException.class);
        this.setOperationBody(op, "\n        TopiaContextImplementor ci = (TopiaContextImplementor) context;\n        " + entityEnumName + " constant = " + entityEnumName + ".valueOf(klass);\n" + "        D dao = (D) ci.getDAO(constant.getContract());\n" + "        return dao;\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)resultClass, "getDAO", "<T extends TopiaEntity, D extends TopiaDAO<? super T>> D", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.addParameter(op, TopiaContext.class, "context");
        this.addParameter(op, "T", "entity");
        this.addException(op, TopiaException.class);
        this.setOperationBody(op, "\n        TopiaContextImplementor ci = (TopiaContextImplementor) context;\n        " + entityEnumName + " constant = " + entityEnumName + ".valueOf(entity);\n" + "        D dao = (D) ci.getDAO(constant.getContract());\n" + "        return dao;\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)resultClass, "getContractClass", "<T extends TopiaEntity> Class<T>", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.addParameter(op, "Class<T>", "klass");
        this.setOperationBody(op, "\n        " + entityEnumName + " constant = " + entityEnumName + ".valueOf(klass);\n" + "        return (Class<T>) constant.getContract();\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)resultClass, "getImplementationClass", "<T extends TopiaEntity> Class<T>", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.addParameter(op, "Class<T>", "klass");
        this.setOperationBody(op, "\n        " + entityEnumName + " constant = " + entityEnumName + ".valueOf(klass);\n" + "        return (Class<T>) constant.getImplementation();\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)resultClass, "getContractClasses", "Class<? extends TopiaEntity>[]", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.setOperationBody(op, "\n        " + entityEnumName + "[] values = " + entityEnumName + ".values();\n" + "        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);\n" + "        for (int i = 0; i < values.length; i++) {\n" + "            result[i] = values[i].getContract();\n" + "        }\n" + "        return result;\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)resultClass, "getImplementationClasses", "Class<? extends TopiaEntity>[]", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.setOperationBody(op, "\n        " + entityEnumName + "[] values = " + entityEnumName + ".values();\n" + "        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);\n" + "        for (int i = 0; i < values.length; i++) {\n" + "            result[i] = values[i].getImplementation();\n" + "        }\n" + "        return result;\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)resultClass, "getImplementationClassesAsString", "String", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.setOperationBody(op, "\n        StringBuilder buffer = new StringBuilder();\n        for (Class<? extends TopiaEntity> aClass : getImplementationClasses()) {\n            buffer.append(',').append(aClass.getName());\n        }\n        return buffer.substring(1);\n    ");
        op = this.addOperation((ObjectModelClassifier)resultClass, "getContracts", entityEnumName + "[]", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.setOperationBody(op, "\n        return " + entityEnumName + ".values();\n" + "    ");
        if (generateOperator) {
            op = this.addOperation((ObjectModelClassifier)resultClass, "getOperator", "<T extends TopiaEntity> EntityOperator<T>", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
            this.addParameter(op, "Class<T>", "klass");
            this.setOperationBody(op, "\n        " + entityEnumName + " constant = " + entityEnumName + ".valueOf(klass);\n" + "        return (EntityOperator<T>) EntityOperatorStore.getOperator(constant);\n" + "    ");
        }
        ObjectModelEnumerationImpl entityEnum = (ObjectModelEnumerationImpl)this.addInnerClassifier(resultClass, ObjectModelType.OBJECT_MODEL_ENUMERATION, entityEnumName);
        this.addImport((ObjectModelClassifier)resultClass, TopiaEntityEnum.class);
        this.addInterface((ObjectModelClassifier)entityEnum, TopiaEntityEnum.class);
        for (ObjectModelClass clazz : classes) {
            String clazzName = clazz.getName();
            this.addLiteral((ObjectModelEnumeration)entityEnum, clazzName + "(" + clazzName + ".class)");
        }
        ObjectModelAttributeImpl attr = (ObjectModelAttributeImpl)this.addAttribute((ObjectModelClassifier)entityEnum, "contract", "Class<? extends TopiaEntity>");
        attr.setDocumentation("the contract of the entity");
        attr = (ObjectModelAttributeImpl)this.addAttribute((ObjectModelClassifier)entityEnum, "implementationFQN", "String");
        attr.setDocumentation("the fully qualified name of the implementation of the entity");
        attr = (ObjectModelAttributeImpl)this.addAttribute((ObjectModelClassifier)entityEnum, "implementation", "Class<? extends TopiaEntity>");
        attr.setDocumentation("the implementation class of the entity (will be lazy computed at runtime)");
        op = this.addConstructor((ObjectModelEnumeration)entityEnum, ObjectModelModifier.PACKAGE);
        this.addParameter(op, "Class<? extends TopiaEntity >", "contract");
        this.setOperationBody(op, "\n        this.contract = contract;\n        this.implementationFQN = contract.getName()+\"Impl\";\n    ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "getContract", "Class<? extends TopiaEntity>", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.setOperationBody(op, "\n        return contract;\n    ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "getImplementationFQN", "String", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.setOperationBody(op, "\n        return implementationFQN;\n    ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "setImplementationFQN", "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addParameter(op, "String", "implementationFQN");
        if (generateOperator) {
            this.setOperationBody(op, "\n        this.implementationFQN = implementationFQN;\n        this.implementation = null;\n        // on reinitialise le magasin d'operators\n       EntityOperatorStore.clear();\n    ");
        } else {
            this.setOperationBody(op, "\n        this.implementationFQN = implementationFQN;\n        this.implementation = null;\n    ");
        }
        op = this.addOperation((ObjectModelClassifier)entityEnum, "accept", "boolean", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addParameter(op, "Class<? extends TopiaEntity>", "klass");
        this.setOperationBody(op, "\n         return " + daoHelperClazzName + ".getContractClass(klass) == contract;\n" + "     ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "getImplementation", "Class<? extends TopiaEntity>", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.setOperationBody(op, "\n         if (implementation == null) {\n            try {\n                    implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);\n                } catch (ClassNotFoundException e) {\n                    throw new RuntimeException(\"could not find class \" + implementationFQN);\n                }\n         }\n         return implementation;\n     ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "valueOf", entityEnumName, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.addParameter(op, "TopiaEntity", "entity");
        this.setOperationBody(op, "\n         return valueOf(entity.getClass());\n     ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "valueOf", entityEnumName, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        this.addParameter(op, "Class<?>", "klass");
        this.setOperationBody(op, "\n         if (klass.isInterface()) {\n            return " + entityEnumName + ".valueOf(klass.getSimpleName());\n" + "         }\n" + "         for (" + entityEnumName + " entityEnum : " + entityEnumName + ".values()) {\n" + "             if (entityEnum.getContract().isAssignableFrom(klass)) {\n" + "                 //todo check it works for inheritance\n" + "                 return entityEnum;\n" + "             }\n" + "         }\n" + "         throw new IllegalArgumentException(\"no entity defined for the class \" + klass + \" in : \" + Arrays.toString(" + entityEnumName + ".values()));\n" + "     ");
    }
}

