/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelGenerator;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.topia.generator.TopiaGeneratorUtil;

@Deprecated
public class InterfaceGenerator
extends ObjectModelGenerator {
    private static final Log log = LogFactory.getLog(InterfaceGenerator.class);

    public String getFilenameForClass(ObjectModelClass clazz) {
        return clazz.getQualifiedName().replace('.', File.separatorChar) + ".java";
    }

    public String getFilenameForInterface(ObjectModelInterface interfacez) {
        return interfacez.getQualifiedName().replace('.', File.separatorChar) + ".java";
    }

    public void generateFromInterface(Writer output, ObjectModelInterface interfacez) throws IOException {
        if (!interfacez.getStereotypes().isEmpty()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating interface for : " + interfacez.getName()));
        }
        String interfacezName = interfacez.getName();
        this.generateInterfaceHeader(output, interfacez);
        this.generateInterfaceOperations(output, (ObjectModelClassifier)interfacez);
        output.write("} //" + interfacezName + "\n");
        output.write("");
    }

    private void generateInterfaceHeader(Writer output, ObjectModelInterface interfacez) throws IOException {
        String copyright = TopiaGeneratorUtil.getCopyright(this.model);
        if (TopiaGeneratorUtil.notEmpty((String)copyright)) {
            output.write("" + copyright + "\n");
            output.write("");
        }
        output.write("package " + interfacez.getPackageName() + ";\n");
        output.write("\n");
        output.write("");
        if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)interfacez)) {
            String documentation = interfacez.getDocumentation();
            output.write("\n");
            output.write("/**\n");
            output.write(" * " + documentation + "\n");
            output.write(" */\n");
            output.write("");
        }
        String interfacezName = interfacez.getName();
        output.write("public interface " + interfacezName + " ");
        String extendClass = "";
        if (!interfacez.getInterfaces().isEmpty()) {
            for (ObjectModelInterface parent : interfacez.getInterfaces()) {
                extendClass = extendClass + parent.getQualifiedName();
                extendClass = extendClass + ", ";
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Interface : " + extendClass));
            }
            output.write(" extends " + extendClass + " {\n");
            output.write("\n");
            output.write("");
        }
        output.write(" {\n");
        output.write("");
    }

    private void generateInterfaceOperations(Writer output, ObjectModelClassifier classifier) throws IOException {
        for (ObjectModelOperation op : classifier.getOperations()) {
            output.write("    /**\n");
            output.write("");
            if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)op)) {
                String documentation = op.getDocumentation();
                output.write("     * " + documentation + "\n");
                output.write("");
            }
            Collection params = op.getParameters();
            for (ObjectModelParameter param : params) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Param" + param));
                }
                String paramName = param.getName();
                String paramDocumentation = param.getDocumentation();
                output.write("     * @param " + paramName + " " + paramDocumentation + "\n");
                output.write(" ");
            }
            String opVisibility = op.getVisibility();
            String opType = op.getReturnType();
            String opName = op.getName();
            output.write("     */\n");
            output.write("    " + opVisibility + " " + opType + " " + opName + "(");
            String comma = "";
            for (ObjectModelParameter param : params) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Param" + param + " comma" + comma));
                }
                String paramName = param.getName();
                String paramType = param.getType();
                output.write("" + comma + "" + paramType + " " + paramName + "");
                comma = ", ";
            }
            output.write(")");
            Set exceptions = op.getExceptions();
            comma = " throws ";
            for (String exception : exceptions) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("exception" + exception + " vir" + comma));
                }
                output.write("" + comma + "" + exception + "");
                comma = ", ";
            }
            output.write(";\n");
            output.write("\n");
            output.write("");
        }
    }
}

