package org.nuiton.topia.it.mapping.test14;

/*
 * #%L
 * ToPIA :: IT
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2004 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.it.mapping.AbstractTopiaItMappingTopiaDao;
import org.nuiton.topia.it.mapping.TopiaItMappingEntityEnum;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Mon Jul 21 16:58:26 CEST 2014")
public abstract class GeneratedA14ATopiaDao<E extends A14A> extends AbstractTopiaItMappingTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) A14A.class;
    }

    @Override
    public TopiaItMappingEntityEnum getTopiaEntityEnum() {
        return TopiaItMappingEntityEnum.A14A;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        super.delete(entity);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRoleBIn(Collection<B14A> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(A14A.PROPERTY_ROLE_B + '.' + Assoc14A.PROPERTY_ROLE_B, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRoleBEquals(B14A v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(A14A.PROPERTY_ROLE_B + '.' + Assoc14A.PROPERTY_ROLE_B, v);
        return result;
    }

    @Deprecated
    public E findByRoleB(B14A v) {
        return forRoleBEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByRoleB(B14A v) {
        return forRoleBEquals(v).findAll();
    }

    public E findByAssoc14A(Assoc14A value) {
        E result = forProperties(A14A.PROPERTY_ROLE_B, value).findAnyOrNull();
        return result;
    }

    public List<E> findAllByAssoc14A(Assoc14A value) {
        List<E> result = forProperties(A14A.PROPERTY_ROLE_B, value).findAll();
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        return new LinkedList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        A14AAbstract entityAbstract = (A14AAbstract)entity;
        if (entityAbstract.roleB != null) {
            tmp.add(entityAbstract.roleB);
        }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedA14ATopiaDao<E extends A14A>
