package org.nuiton.topia.it.legacy.topiatest.deletetest;

/*
 * #%L
 * ToPIA :: IT
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2004 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.hibernate.Session;
import org.nuiton.topia.it.legacy.AbstractTopiaItLegacyDao;
import org.nuiton.topia.it.legacy.TopiaItLegacyEntityEnum;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.internal.support.HibernateTopiaJpaSupport;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Wed May 21 16:38:14 CEST 2014")
public abstract class GeneratedParty2TopiaDao<E extends Party2> extends AbstractTopiaItLegacyDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) Party2.class;
    }

    @Override
    public TopiaItLegacyEntityEnum getTopiaEntityEnum() {
        return TopiaItLegacyEntityEnum.Party2;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        TopiaHibernateSupport hibernateSupport = ((HibernateTopiaJpaSupport) topiaJpaSupport).getHibernateSupport();
        Session hibernateSession = hibernateSupport.getHibernateSession();

        {
            String sql = "SELECT main.topiaid " +
                    " FROM contact2 main, contacts_party2 secondary " +
                    " WHERE main.topiaid=secondary.contacts " +
                    " AND secondary.party2='" + entity.getTopiaId() + "'";
            List<Contact2> list = hibernateSession
                    .createSQLQuery(sql)
                    .addEntity("main", TopiaItLegacyEntityEnum.Contact2.getImplementation())
                    .list();

            for (Contact2 item : list) {
                item.removeParty2(entity);
            }
        }

        super.delete(entity);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forContactsContains(Contact2 v) {
        return forContains(Party2.PROPERTY_CONTACTS, v);
    }

    @Deprecated
    public E findContainsContacts(Contact2 v) {
        return forContactsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsContacts(Contact2 v) {
        return forContactsContains(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == Contact2.class) {
            Contact2TopiaDao dao =
                topiaDaoSupplier.getDao(Contact2.class, Contact2TopiaDao.class);
            tmp = dao.forParty2Contains(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Contact2.class, entity);
        if (!list.isEmpty()) {
            result.put(Contact2.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedParty2TopiaDao<E extends Party2>
