/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.fife.ui.rsyntaxtextarea.RSTAView;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenOrientedView;

public class SyntaxView
extends View
implements TabExpander,
TokenOrientedView,
RSTAView {
    Font font;
    protected FontMetrics metrics;
    Element longLine;
    float longLineWidth;
    private int tabSize;
    protected int tabBase;
    private RSyntaxTextArea host;
    private int lineHeight = 0;
    private int ascent;
    private int clipStart;
    private int clipEnd;

    public SyntaxView(Element element) {
        super(element);
    }

    void calculateLongestLine() {
        Container container = this.getContainer();
        this.font = container.getFont();
        this.metrics = container.getFontMetrics(this.font);
        this.tabSize = this.getTabSize() * this.metrics.charWidth(' ');
        Element element = this.getElement();
        int n = element.getElementCount();
        for (int i = 0; i < n; ++i) {
            Element element2 = element.getElement(i);
            float f = this.getLineWidth(i);
            if (!(f > this.longLineWidth)) continue;
            this.longLineWidth = f;
            this.longLine = element2;
        }
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    protected void damageLineRange(int n, int n2, Shape shape, Component component) {
        if (shape != null) {
            Rectangle rectangle = this.lineToRect(shape, n);
            Rectangle rectangle2 = this.lineToRect(shape, n2);
            if (rectangle != null && rectangle2 != null) {
                Rectangle rectangle3 = rectangle.union(rectangle2);
                component.repaint(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            } else {
                component.repaint();
            }
        }
    }

    public float drawLine(Token token, Graphics2D graphics2D, float f, float f2) {
        float f3 = f;
        while (token != null && token.isPaintable() && f3 < (float)this.clipEnd) {
            f3 = token.paint(graphics2D, f3, f2, this.host, this, this.clipStart);
            token = token.getNextToken();
        }
        return f3;
    }

    private float getLineWidth(int n) {
        Token token = ((RSyntaxDocument)this.getDocument()).getTokenListForLine(n);
        return RSyntaxUtilities.getTokenListWidth(token, (RSyntaxTextArea)this.getContainer(), this);
    }

    public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        return RSyntaxUtilities.getNextVisualPositionFrom(n, bias, shape, n2, biasArray, this);
    }

    public float getPreferredSpan(int n) {
        this.updateMetrics();
        switch (n) {
            case 0: {
                return this.longLineWidth + 10.0f;
            }
            case 1: {
                this.lineHeight = this.host != null ? this.host.getLineHeight() : this.lineHeight;
                return this.getElement().getElementCount() * this.lineHeight;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    protected int getTabSize() {
        Integer n = (Integer)this.getDocument().getProperty("tabSize");
        int n2 = n != null ? n : 5;
        return n2;
    }

    public Token getTokenListForPhysicalLineAbove(int n) {
        RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)this.getDocument();
        Element element = rSyntaxDocument.getDefaultRootElement();
        int n2 = element.getElementIndex(n) - 1;
        if (n2 >= 0) {
            return rSyntaxDocument.getTokenListForLine(n2);
        }
        return null;
    }

    public Token getTokenListForPhysicalLineBelow(int n) {
        int n2;
        RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)this.getDocument();
        Element element = rSyntaxDocument.getDefaultRootElement();
        int n3 = element.getElementIndex(n);
        if (n3 < (n2 = element.getElementCount()) - 1) {
            return rSyntaxDocument.getTokenListForLine(n3 + 1);
        }
        return null;
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    protected Rectangle lineToRect(Shape shape, int n) {
        Rectangle rectangle = null;
        this.updateMetrics();
        if (this.metrics != null) {
            Rectangle rectangle2 = shape.getBounds();
            this.lineHeight = this.host != null ? this.host.getLineHeight() : this.lineHeight;
            rectangle = new Rectangle(rectangle2.x, rectangle2.y + n * this.lineHeight, rectangle2.width, this.lineHeight);
        }
        return rectangle;
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        Element element = this.getElement();
        RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)this.getDocument();
        int n2 = element.getElementIndex(n);
        Rectangle rectangle = this.lineToRect(shape, n2);
        this.tabBase = rectangle.x;
        Token token = rSyntaxDocument.getTokenListForLine(n2);
        rectangle = token.listOffsetToView((RSyntaxTextArea)this.getContainer(), this, n, this.tabBase, rectangle);
        return rectangle;
    }

    public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
        Rectangle rectangle;
        Rectangle rectangle2;
        Shape shape2;
        Shape shape3 = this.modelToView(n, shape, bias);
        if (n2 == this.getEndOffset()) {
            try {
                shape2 = this.modelToView(n2, shape, bias2);
            }
            catch (BadLocationException badLocationException) {
                shape2 = null;
            }
            if (shape2 == null) {
                rectangle2 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                shape2 = new Rectangle(rectangle2.x + rectangle2.width - 1, rectangle2.y, 1, rectangle2.height);
            }
        } else {
            shape2 = this.modelToView(n2, shape, bias2);
        }
        rectangle2 = shape3.getBounds();
        Rectangle rectangle3 = rectangle = shape2 instanceof Rectangle ? (Rectangle)shape2 : shape2.getBounds();
        if (rectangle2.y != rectangle.y) {
            Rectangle rectangle4 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            rectangle2.x = rectangle4.x;
            rectangle2.width = rectangle4.width;
        }
        rectangle2.add(rectangle);
        if (n2 > n) {
            rectangle2.width -= rectangle.width;
        }
        return rectangle2;
    }

    public float nextTabStop(float f, int n) {
        if (this.tabSize == 0) {
            return f;
        }
        int n2 = ((int)f - this.tabBase) / this.tabSize;
        return this.tabBase + (n2 + 1) * this.tabSize;
    }

    public void paint(Graphics graphics, Shape shape) {
        RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)this.getDocument();
        Rectangle rectangle = shape.getBounds();
        this.tabBase = rectangle.x;
        this.host = (RSyntaxTextArea)this.getContainer();
        Rectangle rectangle2 = graphics.getClipBounds();
        this.clipStart = rectangle2.x;
        this.clipEnd = this.clipStart + rectangle2.width;
        this.lineHeight = this.host.getLineHeight();
        this.ascent = this.host.getMaxAscent();
        int n = rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height);
        int n2 = Math.max(0, n / this.lineHeight);
        int n3 = rectangle2.y - rectangle.y;
        int n4 = Math.max(0, n3 / this.lineHeight);
        int n5 = rectangle.height / this.lineHeight;
        if (rectangle.height % this.lineHeight != 0) {
            ++n5;
        }
        Rectangle rectangle3 = this.lineToRect(shape, n4);
        int n6 = rectangle3.y + this.ascent;
        int n7 = rectangle3.x;
        Element element = this.getElement();
        int n8 = element.getElementCount();
        int n9 = Math.min(n8, n5 - n2);
        RSyntaxTextAreaHighlighter rSyntaxTextAreaHighlighter = (RSyntaxTextAreaHighlighter)this.host.getHighlighter();
        Graphics2D graphics2D = (Graphics2D)graphics;
        for (int i = n4; i < n9; ++i) {
            Element element2 = element.getElement(i);
            int n10 = element2.getStartOffset();
            int n11 = element2.getEndOffset() - 1;
            rSyntaxTextAreaHighlighter.paintLayeredHighlights(graphics2D, n10, n11, shape, this.host, this);
            Token token = rSyntaxDocument.getTokenListForLine(i);
            this.drawLine(token, graphics2D, n7, n6);
            n6 += this.lineHeight;
        }
    }

    protected boolean possiblyUpdateLongLine(Element element, int n) {
        float f = this.getLineWidth(n);
        if (f > this.longLineWidth) {
            this.longLineWidth = f;
            this.longLine = element;
            return true;
        }
        return false;
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    public void setSize(float f, float f2) {
        super.setSize(f, f2);
        this.updateMetrics();
    }

    protected void updateDamage(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Element[] elementArray;
        Container container = this.getContainer();
        this.updateMetrics();
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        Element[] elementArray2 = elementChange != null ? elementChange.getChildrenAdded() : null;
        Element[] elementArray3 = elementArray = elementChange != null ? elementChange.getChildrenRemoved() : null;
        if (elementArray2 != null && elementArray2.length > 0 || elementArray != null && elementArray.length > 0) {
            int n;
            if (elementArray2 != null) {
                n = elementChange.getIndex();
                for (int i = 0; i < elementArray2.length; ++i) {
                    this.possiblyUpdateLongLine(elementArray2[i], n + i);
                }
            }
            if (elementArray != null) {
                for (n = 0; n < elementArray.length; ++n) {
                    if (elementArray[n] != this.longLine) continue;
                    this.longLineWidth = -1.0f;
                    this.calculateLongestLine();
                    break;
                }
            }
            this.preferenceChanged(null, true, true);
            container.repaint();
        } else if (documentEvent.getType() == DocumentEvent.EventType.CHANGE) {
            int n = documentEvent.getOffset();
            int n2 = documentEvent.getLength();
            this.damageLineRange(n, n2, shape, container);
        } else {
            Element element2 = this.getElement();
            int n = element2.getElementIndex(documentEvent.getOffset());
            this.damageLineRange(n, n, shape, container);
            if (documentEvent.getType() == DocumentEvent.EventType.INSERT) {
                Element element3 = element2.getElement(n);
                if (element3 == this.longLine) {
                    this.longLineWidth = this.getLineWidth(n);
                    this.preferenceChanged(null, true, false);
                } else if (this.possiblyUpdateLongLine(element3, n)) {
                    this.preferenceChanged(null, true, false);
                }
            } else if (documentEvent.getType() == DocumentEvent.EventType.REMOVE && element2.getElement(n) == this.longLine) {
                this.longLineWidth = -1.0f;
                this.calculateLongestLine();
                this.preferenceChanged(null, true, false);
            }
        }
    }

    protected void updateMetrics() {
        this.host = (RSyntaxTextArea)this.getContainer();
        Font font = this.host.getFont();
        if (this.font != font) {
            this.calculateLongestLine();
        }
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        biasArray[0] = Position.Bias.Forward;
        Rectangle rectangle = shape.getBounds();
        RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)this.getDocument();
        int n = (int)f;
        int n2 = (int)f2;
        if (n2 < rectangle.y) {
            return this.getStartOffset();
        }
        if (n2 > rectangle.y + rectangle.height) {
            return this.getEndOffset() - 1;
        }
        Element element = rSyntaxDocument.getDefaultRootElement();
        int n3 = Math.abs((n2 - rectangle.y) / this.lineHeight);
        if (n3 >= element.getElementCount()) {
            return this.getEndOffset() - 1;
        }
        Element element2 = element.getElement(n3);
        if (n < rectangle.x) {
            return element2.getStartOffset();
        }
        if (n > rectangle.x + rectangle.width) {
            return element2.getEndOffset() - 1;
        }
        int n4 = element2.getStartOffset();
        Token token = rSyntaxDocument.getTokenListForLine(n3);
        this.tabBase = rectangle.x;
        int n5 = token.getListOffset((RSyntaxTextArea)this.getContainer(), this, this.tabBase, n);
        return n5 != -1 ? n5 : n4;
    }

    public int yForLineContaining(Rectangle rectangle, int n) throws BadLocationException {
        Element element = this.getElement();
        int n2 = element.getElementIndex(n);
        this.updateMetrics();
        if (this.metrics != null) {
            this.lineHeight = this.host != null ? this.host.getLineHeight() : this.lineHeight;
            return rectangle.y + n2 * this.lineHeight;
        }
        return -1;
    }
}

