/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map;

import cern.colt.function.DoubleFunction;
import cern.colt.function.LongDoubleProcedure;
import cern.colt.function.LongProcedure;
import cern.colt.list.ByteArrayList;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.LongArrayList;
import cern.colt.map.AbstractLongDoubleMap;
import cern.colt.map.HashFunctions;
import cern.jet.math.Mult;

public class OpenLongDoubleHashMap
extends AbstractLongDoubleMap {
    private static final long serialVersionUID = -6994113634672494086L;
    protected long[] table;
    protected double[] values;
    protected byte[] state;
    protected long freeEntries;
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;

    public OpenLongDoubleHashMap() {
        this(277);
    }

    public OpenLongDoubleHashMap(int initialCapacity) {
        this(initialCapacity, 0.2, 0.5);
    }

    public OpenLongDoubleHashMap(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    @Override
    public void assign(DoubleFunction function) {
        if (function instanceof Mult) {
            double multiplicator = ((Mult)function).multiplicator;
            if (multiplicator == 1.0) {
                return;
            }
            if (multiplicator == 0.0) {
                this.clear();
                return;
            }
            int i = this.table.length;
            while (i-- > 0) {
                if (this.state[i] != 1) continue;
                int n = i;
                this.values[n] = this.values[n] * multiplicator;
            }
        } else {
            int i = this.table.length;
            while (i-- > 0) {
                if (this.state[i] != 1) continue;
                this.values[i] = function.apply(this.values[i]);
            }
        }
    }

    @Override
    public void assign(AbstractLongDoubleMap other) {
        if (!(other instanceof OpenLongDoubleHashMap)) {
            super.assign(other);
            return;
        }
        OpenLongDoubleHashMap source = (OpenLongDoubleHashMap)other;
        OpenLongDoubleHashMap copy = (OpenLongDoubleHashMap)source.copy();
        this.values = copy.values;
        this.table = copy.table;
        this.state = copy.state;
        this.freeEntries = copy.freeEntries;
        this.distinct = copy.distinct;
        this.lowWaterMark = copy.lowWaterMark;
        this.highWaterMark = copy.highWaterMark;
        this.minLoadFactor = copy.minLoadFactor;
        this.maxLoadFactor = copy.maxLoadFactor;
    }

    @Override
    public void clear() {
        new ByteArrayList(this.state).fillFromToWith(0, this.state.length - 1, (byte)0);
        this.distinct = 0;
        this.freeEntries = this.table.length;
        this.trimToSize();
    }

    @Override
    public Object clone() {
        OpenLongDoubleHashMap copy = (OpenLongDoubleHashMap)super.clone();
        copy.table = (long[])copy.table.clone();
        copy.values = (double[])copy.values.clone();
        copy.state = (byte[])copy.state.clone();
        return copy;
    }

    @Override
    public boolean containsKey(long key) {
        return this.indexOfKey(key) >= 0;
    }

    @Override
    public boolean containsValue(double value) {
        return this.indexOfValue(value) >= 0;
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        if (this.table.length < minCapacity) {
            int newCapacity = this.nextPrime(minCapacity);
            this.rehash(newCapacity);
        }
    }

    @Override
    public boolean forEachKey(LongProcedure procedure) {
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1 || procedure.apply(this.table[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachPair(LongDoubleProcedure procedure) {
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1 || procedure.apply(this.table[i], this.values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public double get(long key) {
        int i = this.indexOfKey(key);
        if (i < 0) {
            return 0.0;
        }
        return this.values[i];
    }

    protected int indexOfInsertion(long key) {
        long[] tab = this.table;
        byte[] stat = this.state;
        int length = tab.length;
        int hash = HashFunctions.hash(key) & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        while (stat[i] == 1 && tab[i] != key) {
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        if (stat[i] == 2) {
            int j = i;
            while (stat[i] != 0 && (stat[i] == 2 || tab[i] != key)) {
                if ((i -= decrement) >= 0) continue;
                i += length;
            }
            if (stat[i] == 0) {
                i = j;
            }
        }
        if (stat[i] == 1) {
            return -i - 1;
        }
        return i;
    }

    protected int indexOfKey(long key) {
        long[] tab = this.table;
        byte[] stat = this.state;
        int length = tab.length;
        int hash = HashFunctions.hash(key) & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        while (stat[i] != 0 && (stat[i] == 2 || tab[i] != key)) {
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        if (stat[i] == 0) {
            return -1;
        }
        return i;
    }

    protected int indexOfValue(double value) {
        double[] val = this.values;
        byte[] stat = this.state;
        int i = stat.length;
        while (--i >= 0) {
            if (stat[i] != 1 || val[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public long keyOf(double value) {
        int i = this.indexOfValue(value);
        if (i < 0) {
            return Long.MIN_VALUE;
        }
        return this.table[i];
    }

    @Override
    public void keys(LongArrayList list) {
        list.setSize(this.distinct);
        long[] elements = list.elements();
        long[] tab = this.table;
        byte[] stat = this.state;
        int j = 0;
        int i = tab.length;
        while (i-- > 0) {
            if (stat[i] != 1) continue;
            elements[j++] = tab[i];
        }
    }

    @Override
    public void pairsMatching(LongDoubleProcedure condition, LongArrayList keyList, DoubleArrayList valueList) {
        keyList.clear();
        valueList.clear();
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1 || !condition.apply(this.table[i], this.values[i])) continue;
            keyList.add(this.table[i]);
            valueList.add(this.values[i]);
        }
    }

    @Override
    public boolean put(long key, double value) {
        int i = this.indexOfInsertion(key);
        if (i < 0) {
            i = -i - 1;
            this.values[i] = value;
            return false;
        }
        if (this.distinct > this.highWaterMark) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
            return this.put(key, value);
        }
        this.table[i] = key;
        this.values[i] = value;
        if (this.state[i] == 0) {
            --this.freeEntries;
        }
        this.state[i] = 1;
        ++this.distinct;
        if (this.freeEntries < 1L) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return true;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.table.length;
        if (newCapacity <= this.distinct) {
            throw new InternalError();
        }
        long[] oldTable = this.table;
        double[] oldValues = this.values;
        byte[] oldState = this.state;
        long[] newTable = new long[newCapacity];
        double[] newValues = new double[newCapacity];
        byte[] newState = new byte[newCapacity];
        this.lowWaterMark = this.chooseLowWaterMark(newCapacity, this.minLoadFactor);
        this.highWaterMark = this.chooseHighWaterMark(newCapacity, this.maxLoadFactor);
        this.table = newTable;
        this.values = newValues;
        this.state = newState;
        this.freeEntries = newCapacity - this.distinct;
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldState[i] != 1) continue;
            long element = oldTable[i];
            int index = this.indexOfInsertion(element);
            newTable[index] = element;
            newValues[index] = oldValues[i];
            newState[index] = 1;
        }
    }

    @Override
    public boolean removeKey(long key) {
        int i = this.indexOfKey(key);
        if (i < 0) {
            return false;
        }
        this.state[i] = 2;
        --this.distinct;
        if (this.distinct < this.lowWaterMark) {
            int newCapacity = this.chooseShrinkCapacity(this.distinct, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return true;
    }

    @Override
    protected void setUp(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        int capacity = initialCapacity;
        super.setUp(capacity, minLoadFactor, maxLoadFactor);
        capacity = this.nextPrime(capacity);
        if (capacity == 0) {
            capacity = 1;
        }
        this.table = new long[capacity];
        this.values = new double[capacity];
        this.state = new byte[capacity];
        this.minLoadFactor = minLoadFactor;
        this.maxLoadFactor = capacity == Integer.MAX_VALUE ? 1.0 : maxLoadFactor;
        this.distinct = 0;
        this.freeEntries = capacity;
        this.lowWaterMark = 0;
        this.highWaterMark = this.chooseHighWaterMark(capacity, this.maxLoadFactor);
    }

    @Override
    public void trimToSize() {
        int newCapacity = this.nextPrime((int)(1.0 + 1.2 * (double)this.size()));
        if (this.table.length > newCapacity) {
            this.rehash(newCapacity);
        }
    }

    @Override
    public void values(DoubleArrayList list) {
        list.setSize(this.distinct);
        double[] elements = list.elements();
        double[] val = this.values;
        byte[] stat = this.state;
        int j = 0;
        int i = stat.length;
        while (i-- > 0) {
            if (stat[i] != 1) continue;
            elements[j++] = val[i];
        }
    }
}

