/*
 * #%L
 * NuitonMatrix
 * 
 * $Id: DoubleBigVector.java 489 2014-06-29 18:36:51Z bpoussin $
 * $HeadURL: https://svn.nuiton.org/nuiton-matrix/tags/nuiton-matrix-2.5/nuiton-matrix/src/main/java/org/nuiton/math/matrix/DoubleBigVector.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.math.matrix;

import java.util.Arrays;

/**
 * DoubleBigVector.
 *
 * Created: 6 octobre 2005 02:54:36 CEST
 *
 * @author Benjamin POUSSIN <poussin@codelutin.com>
 * @version $Revision: 489 $
 *
 * Last update: $Date: 2014-06-29 20:36:51 +0200 (Sun, 29 Jun 2014) $
 * by : $Author: bpoussin $
 */
public class DoubleBigVector implements Vector { // DoubleBigVector

    protected double data[] = null;

    public DoubleBigVector() {
    }

    public DoubleBigVector(int capacity) {
        init(capacity);
    }

    @Override
    public void init(int capacity) {
        if (data == null) {
            try {
                data = new double[capacity];
            } catch (OutOfMemoryError eee) {
                throw new MatrixException("Can't create vector with capacity = " + capacity, eee);
            }
        }
    }

    @Override
    public String getInfo() {
        return "Double vector dense: " + size();
    }

    @Override
    public int getNumberOfAssignedValue() {
        return size();
    }

    @Override
    public int size() {
        return data.length;
    }

    @Deprecated
    @Override
    public double getMaxOccurence() {
        return getMaxOccurrence();
    }

    @Override
    public double getMaxOccurrence() {
        return MatrixHelper.maxOccurrence(data);
    }

    @Override
    public double getValue(int pos) {
        return data[pos];
    }

    @Override
    public void setValue(int pos, double value) {
        data[pos] = value;
    }

    @Override
    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof DoubleBigVector) {
            DoubleBigVector other = (DoubleBigVector) o;
            result = Arrays.equals(this.data, other.data);
        } else if (o instanceof Vector) {
            Vector other = (Vector) o;
            result = true;
            for (int i = 0; i < size() && result; i++) {
                result = getValue(i) == other.getValue(i);
            }
        }
        return result;
    }

    /**
     * use 3 values of data and length of data to create hashcode.
     * @return
     */
    @Override
    public int hashCode() {
        int size = size();
        int first = (int)data[0];
        int middle = (int)data[size/2];
        int last = (int)data[size-1];

        return size + first + middle + last;
    }

    @Override
    public boolean isImplementedPaste(Vector v) {
        return v instanceof DoubleBigVector;
    }

    @Override
    public boolean isImplementedAdd(Vector v) {
        return v instanceof DoubleBigVector;
    }

    @Override
    public boolean isImplementedMinus(Vector v) {
        return v instanceof DoubleBigVector;
    }

    @Override
    public boolean isImplementedMap() {
        return true;
    }

    @Override
    public void paste(Vector src) {
        DoubleBigVector fbv = (DoubleBigVector) src;
        System.arraycopy(fbv.data, 0, this.data, 0, this.size());
    }

    @Override
    public void add(Vector v) {
        DoubleBigVector fbv = (DoubleBigVector) v;
        for (int i = 0; i < data.length; i++) {
            data[i] += fbv.data[i];
        }
    }

    @Override
    public void minus(Vector v) {
        DoubleBigVector fbv = (DoubleBigVector) v;
        for (int i = 0; i < data.length; i++) {
            data[i] -= fbv.data[i];
        }
    }

    @Override
    public void map(MapFunction f) {
        for (int i = 0; i < data.length; i++) {
            data[i] = f.apply(data[i]);
        }
    }

    @Override
    public VectorIterator iterator() {
        return new VectorIteratorImpl(this);
    }

    @Override
    public VectorIterator iteratorNotZero() {
            return new VectorIteratorImpl(this, 0);
    }


} // DoubleBigVector

