/*
 * #%L
 * NuitonMatrix
 * 
 * $Id: BasicMatrixIterator.java 323 2011-01-22 09:32:20Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-matrix/tags/matrix-2.2/nuiton-matrix/src/main/java/org/nuiton/math/matrix/BasicMatrixIterator.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.math.matrix;

/**
 * BasicMatrixIterator.
 *
 * Created: 28 oct. 2004
 *
 * @author Benjamin Poussin <poussin@codelutin.com>
 * @version $Revision: 323 $
 *
 * Mise a jour: $Date: 2011-01-22 10:32:20 +0100 (sam., 22 janv. 2011) $
 * par : $Author: tchemit $
 */
public interface BasicMatrixIterator { // BasicMatrixIterator

    /**
     * Retourne vrai s'il existe un suivant.
     * 
     * @return vrai s'il y a un suivant, faux sinon
     */
    public boolean hasNext();

    /**
     * Passe à l'élément suivant.
     * 
     * @return vrai s'il y a un suivant, faux sinon
     */
    public boolean next();

    /**
     * Retourne les coordonnés de l'élément.
     * 
     * @return current element coordinates
     */
    public int[] getCoordinates();

    /**
     * Retourne la valeur courant pointé par l'iterator.
     * 
     * @return current element value
     */
    public double getValue();

    /**
     * Modifie la valeur courant pointé par l'iterator.
     * 
     * @param value new value to set to current element
     */
    public void setValue(double value);

} // BasicMatrixIterator

