/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin.report;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.module.xhtml.decoration.render.RenderingContext;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.site.decoration.Body;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.Skin;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.i18n.I18N;
import org.nuiton.io.rest.RestClientConfiguration;
import org.nuiton.jredmine.plugin.AbstractRedmineMojo;
import org.nuiton.plugin.Plugin;

public abstract class AbstractRedmineReport
extends AbstractRedmineMojo
implements MavenReport,
Plugin,
RestClientConfiguration {
    protected boolean anonymous;
    protected String issueLinkTemplate;
    protected String versionLinkTemplate;
    protected ArtifactRepository localRepository;
    protected File outputDirectory;
    protected ArtifactResolver resolver;
    protected ArtifactFactory factory;
    protected I18N i18n;
    protected Renderer siteRenderer;
    private Sink sink;
    private File reportOutputDirectory;

    protected abstract void executeReport(Locale var1) throws MavenReportException;

    protected abstract boolean skipReport();

    public AbstractRedmineReport(boolean requireProject, boolean requireVersion, boolean requireUser) {
        super(requireProject, requireVersion, requireUser);
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    @Override
    protected void doAction() throws Exception {
        try {
            DecorationModel model = new DecorationModel();
            model.setBody(new Body());
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("outputEncoding", this.encoding);
            Locale currentLocale = Locale.getDefault();
            SiteRenderingContext siteContext = this.siteRenderer.createContextForSkin(this.getSkinArtifactFile(), attributes, model, this.getName(currentLocale), currentLocale);
            RenderingContext context = new RenderingContext(this.outputDirectory, this.getOutputName() + ".html");
            SiteRendererSink newSink = new SiteRendererSink(context);
            this.generate((org.codehaus.doxia.sink.Sink)newSink, currentLocale);
            this.createDirectoryIfNecessary(this.outputDirectory);
            FileWriter writer = new FileWriter(new File(this.outputDirectory, this.getOutputName() + ".html"));
            this.siteRenderer.generateDocument((Writer)writer, newSink, siteContext);
            this.siteRenderer.copyResources(siteContext, new File(this.project.getBasedir(), "src/site/resources"), this.outputDirectory);
        }
        catch (RendererException e) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)e);
        }
        catch (MavenReportException e) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)((Object)e));
        }
        finally {
            this.closeService();
        }
    }

    public boolean canGenerateReport() {
        boolean init;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"check can use report");
        }
        if (this.skipReport()) {
            this.getLog().info((CharSequence)("User ask to skip report \"" + this.getName(Locale.ENGLISH) + "\"."));
            return false;
        }
        if (this.session.getSettings().isOffline()) {
            this.getLog().info((CharSequence)("Skipped \"" + this.getName(Locale.ENGLISH) + "\" report in offline mode."));
            return false;
        }
        try {
            this.init();
            init = true;
        }
        catch (Exception ex) {
            if (this.isVerbose()) {
                this.getLog().error((CharSequence)("could not init report goal for reason " + ex.getMessage()), (Throwable)ex);
            } else {
                this.getLog().error((CharSequence)("could not init report goal for reason " + ex.getMessage()));
            }
            init = false;
        }
        if (!init) {
            this.getLog().info((CharSequence)("Skipped \"" + this.getName(Locale.ENGLISH) + "\" report, goal could be initialized."));
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("check can use report : " + init));
        }
        return init;
    }

    public void generate(org.codehaus.doxia.sink.Sink sink, Locale locale) throws MavenReportException {
        if (sink == null) {
            throw new MavenReportException("You must specify a sink.");
        }
        this.sink = sink;
        this.executeReport(locale);
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.description");
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public File getReportOutputDirectory() {
        if (this.reportOutputDirectory == null) {
            this.reportOutputDirectory = new File(this.outputDirectory.getAbsolutePath());
        }
        return this.reportOutputDirectory;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.reportOutputDirectory = reportOutputDirectory;
    }

    public boolean isExternalReport() {
        return false;
    }

    protected Sink getSink() {
        return this.sink;
    }

    protected ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("redmine-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    protected File getSkinArtifactFile() throws MojoExecutionException {
        Artifact artifact;
        Skin skin = Skin.getDefaultSkin();
        String version = skin.getVersion();
        try {
            if (version == null) {
                version = "RELEASE";
            }
            VersionRange versionSpec = VersionRange.createFromVersionSpec((String)version);
            artifact = this.factory.createDependencyArtifact(skin.getGroupId(), skin.getArtifactId(), versionSpec, "jar", null, null);
            this.resolver.resolve(artifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("The skin version '" + version + "' is not valid: " + e.getMessage());
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to find skin", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("The skin does not exist: " + e.getMessage());
        }
        return artifact.getFile();
    }
}

