/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin;

import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.nuiton.jredmine.RedmineService;
import org.nuiton.jredmine.RedmineServiceConfiguration;
import org.nuiton.plugin.AbstractPlugin;

public abstract class AbstractRedmineMojo
extends AbstractPlugin
implements RedmineServiceConfiguration {
    public static final String REDMINE_SYSTEM = "redmine";
    @Component
    protected MavenProject project;
    @Parameter(property="redmine.url")
    protected URL url;
    @Parameter(property="redmine.username")
    protected String username;
    @Parameter(property="redmine.password")
    protected String password;
    @Parameter(property="redmine.encoding", defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter(property="redmine.verbose", defaultValue="${maven.verbose}")
    protected boolean verbose;
    @Parameter(property="redmine.safe", defaultValue="true")
    protected boolean safe;
    @Component
    protected MavenSession session;
    @Component
    protected RedmineService service;
    protected DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    protected boolean runOnceDone;
    protected boolean serviceInit;
    protected boolean initOk = true;

    protected void init() throws Exception {
        IssueManagement issueManagement = this.project.getIssueManagement();
        if (issueManagement == null) {
            throw new MojoExecutionException("No Issue Management set.");
        }
        if (issueManagement.getUrl() == null || issueManagement.getUrl().trim().equals("")) {
            throw new MojoExecutionException("No URL set in Issue Management.");
        }
        if (issueManagement.getSystem() != null && !issueManagement.getSystem().equalsIgnoreCase(REDMINE_SYSTEM)) {
            throw new MojoExecutionException("Redmine's Plugin only supports 'redmine' Issue Management system.");
        }
        URL url = this.getRestUrl();
        if (url == null || url.toString().isEmpty()) {
            url = new URL(issueManagement.getUrl());
            if (this.verbose) {
                this.getLog().info((CharSequence)("use the url from issue management : " + url));
            }
        }
        this.setRestUrl(url);
        if (this.verbose) {
            if (this.isAnonymous()) {
                this.getLog().info((CharSequence)("Redmine anonymous configuration :\n>> host     : " + this.getRestUrl()));
            } else {
                this.getLog().info((CharSequence)("Redmine configuration :\n>> host     : " + this.getRestUrl() + "\n>> username : " + this.getRestUsername()));
            }
        }
        try {
            this.service.init((RedmineServiceConfiguration)this);
            this.serviceInit = true;
        }
        catch (Exception e) {
            if (this.isSafe()) {
                throw e;
            }
            this.serviceInit = false;
            this.initOk = false;
            this.getLog().error((CharSequence)("could not init Redmine service [" + this.getRestUrl() + "] with user '" + this.getRestUsername() + "'"), (Throwable)e);
        }
    }

    protected boolean checkSkip() {
        if (this.isGoalSkip()) {
            this.getLog().warn((CharSequence)"The goal is skip due to the skipGoal flag on");
            return false;
        }
        if (this.isRunOnce() && this.isRunOnceDone()) {
            this.getLog().info((CharSequence)"skip goal, runOnce flag is on, and was already executed.");
            return false;
        }
        if (!this.serviceInit) {
            this.getLog().error((CharSequence)("could not init Redmine service [" + this.getRestUrl() + "] with user '" + this.getRestUsername() + "'"));
            return false;
        }
        return true;
    }

    protected void afterExecute() {
        this.closeService();
    }

    protected abstract void doAction() throws Exception;

    protected abstract boolean isGoalSkip();

    protected abstract boolean isRunOnce();

    protected abstract boolean checkRunOnceDone();

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getRestPassword() {
        return this.password;
    }

    public URL getRestUrl() {
        return this.url;
    }

    public String getRestUsername() {
        return this.username;
    }

    public void setRestPassword(String restPassword) {
        this.password = restPassword;
    }

    public void setRestUrl(URL restUrl) {
        this.url = restUrl;
    }

    public void setRestUsername(String restUsername) {
        this.username = restUsername;
    }

    public String getApiKey() {
        return null;
    }

    public void setApiKey(String apiKey) {
    }

    protected void closeService() {
        if (this.service != null) {
            try {
                this.service.destroy();
            }
            catch (Exception ex) {
                this.getLog().error((CharSequence)("could not close redmine client for reason " + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    public boolean isRunOnceDone() {
        return this.runOnceDone;
    }

    public boolean isSafe() {
        return this.safe;
    }

    public void setSafe(boolean safe) {
        this.safe = safe;
    }
}

