/*
 * #%L
 * JAXX :: Validator
 * 
 * $Id: BeanValidatorScope.java 2144 2010-12-30 13:06:21Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.2.4/jaxx-validator/src/main/java/jaxx/runtime/validator/BeanValidatorScope.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.validator;

import static org.nuiton.i18n.I18n.n_;

/**
 * The differents levels of messages in validation process.
 * <p/>
 * The order of the enum defines the severity of validation.
 * <p/>
 * Always begin with fatal, then error, then if no error found, try warning, then info...
 *
 * @author tchemit <chemit@codelutin.com>
 * @deprecated since 2.2.4, the code is moved into the org.nuiton:nuiton-validator project, will be removed in version 2.3
 */
@Deprecated
public enum BeanValidatorScope {

    /**
     * the fatal error scope level.
     * <p/>
     * When a message of a such scope is found on a validator, then the
     * validator is invalid and modified.
     * @since 2.2.4
     */
    FATAL(n_("validator.scope.fatal.label")),
    /**
     * the error scope level.
     * <p/>
     * When a message of a such scope is found on a validator, then the
     * validator is invalid and modified.
     */
    ERROR(n_("validator.scope.error.label")),
    /**
     * the warning scope level.
     * <p/>
     * When a message of a such scope is found on a validator, then the
     * validator is still valid but modified.
     */
    WARNING(n_("validator.scope.warning.label")),
    /**
     * the information scope level.
     * <p/>
     * When a message of a sucg scope is found on a validator, then the
     * validator is still valid and not modified.
     */
    INFO(n_("validator.scope.info.label"));

    private final String label;

    BeanValidatorScope(String label) {
        this.label = label;
    }

    public String getLabel() {
        return label;
    }
}
