/*
 * #%L
 * JAXX :: Runtime
 * $Id: GenericListSelectionModel.java 2455 2012-07-30 18:47:43Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.6/jaxx-runtime/src/main/java/jaxx/runtime/swing/model/GenericListSelectionModel.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing.model;

import javax.swing.DefaultListModel;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class GenericListSelectionModel<B> extends AbstractGenericListSelectionModel<B> {

    protected DefaultListModel listModel;

    public GenericListSelectionModel(DefaultListModel listModel) {
        super();
        this.listModel = listModel;
    }

    public DefaultListModel getListModel() {
        return listModel;
    }

    @Override
    public int getSize() {
        return listModel.size();
    }

    @Override
    public B getValueAt(int i) {
        return (B)listModel.getElementAt(i);
    }
}
