/*
 * #%L
 * JAXX :: Runtime
 * 
 * $Id: NavigationOneClicSelectionHandler.java 1986 2010-06-23 08:58:14Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.1.1/jaxx-runtime/src/main/java/jaxx/runtime/swing/navigation/handler/NavigationOneClicSelectionHandler.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing.navigation.handler;

import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.navigation.NavigationNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.tree.TreePath;
import java.util.Arrays;

/**
 * The handler of a navigation tree.
 * <p/>
 * This is also the selection model to use, since we must check before moving
 * from nodes we can not just listen selection model changed, we must control
 * it.
 * <p/>
 * This one is used to enable one clic multi selection
 *
 * @author sletellier
 * @since 2.0.1
 * @deprecated since 2.1, prefer use the simplify api {@code jaxx.runtime.swing.tree}.
 */
@Deprecated
public abstract class NavigationOneClicSelectionHandler<E extends NavigationNode<E>> extends NavigationMultiTreeHandler<E> {

    /** Logger */
    static private final Log log =
            LogFactory.getLog(NavigationOneClicSelectionHandler.class);


    public NavigationOneClicSelectionHandler(String contextPrefix,
                                             JAXXObject context,
                                             Strategy strategy) {
        super(contextPrefix, context, strategy);
    }

    @Override
    public void setSelectionPath(TreePath path) {
        TreePath[] treePaths = getSelectionPaths();
        if (treePaths == null || !Arrays.asList(treePaths).contains(path)) {
            addSelectionPath(path);
        } else {
            removeSelectionPath(path);
        }
    }

}
