/*
 * #%L
 * JAXX :: Runtime
 * 
 * $Id: NavigationModel.java 1986 2010-06-23 08:58:14Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.1.1/jaxx-runtime/src/main/java/jaxx/runtime/swing/navigation/NavigationModel.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing.navigation;

import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;

import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import java.util.regex.Pattern;

/**
 * Interface to create model of the tree used for a navigation tree.
 * <p/>
 * Il est composé de {@link NavigationNode}
 *
 * @author sletellier
 * @since 2.0.0
 * @deprecated since 2.1, prefer use the simplify api {@code jaxx.runtime.swing.tree}.
 */
@Deprecated
public interface NavigationModel<E extends NavigationNode<E>> {

    E getRoot();

    void setRoot(E root);

    E[] getPathToRoot(E aNode);

    void removeNodeFromParent(E node);

    /**
     * Search from the root node a node named by his fully path (concatenation
     * of nodes {@link NavigationTreeNode#path} valued separated by dot.
     * <p/>
     * Example :
     * <p/>
     * <pre>$root.child1.leaf1</pre>
     *
     * @param path the fully path of the searched node.
     * @return the node matching the fully context from the root node, or
     *         <code>null</code> if not find.
     */
    E findNode(String path);

    /**
     * Apply first the regex pattern to obtain the searched node fi the given
     * <code>regex</code> is not null.
     * <p/>
     * Search then from the root node a node named by his fully path
     * (concatenation of nodes {@link NavigationTreeNode#path} valued separated
     * by {@link #getPathSeparator()}.
     * <p/>
     * <p/>
     * Example :
     * <p/>
     * <pre>$root.child1.leaf1</pre>
     *
     * @param path  the fully path of the searched node.
     * @param regex a optional regex to apply to path before searching
     * @return the node matching the fully context from the root node, or
     *         <code>null</code> if not found.
     */
    E findNode(String path, String regex);

    /**
     * Apply first the regex pattern to obtain the searched node.
     * <p/>
     * Search then from the root node a node named by his fully path
     * (concatenation of nodes {@link NavigationTreeNode#path} valued separated
     * by {@link #getPathSeparator()}.
     * <p/>
     * Example :
     * <p/>
     * <pre>$root.child1.leaf1</pre>
     *
     * @param path  the fully path of the searched node.
     * @param regex a optional regex to apply to path before searching
     * @return the node matching the fully context from the root node, or
     *         <code>null</code> if not found.
     */
    E findNode(String path, Pattern regex);

    /**
     * Search from a given root node a node named by his fully path
     * (concatenation of nodes {@link NavigationTreeNode#path} valued separated
     * by {@link #getPathSeparator()}.
     *
     * @param root root node to be used
     * @param path the fully path of the searched node.
     * @return the node matching the fully context from the given root node, or
     *         <code>null</code> if not found.
     */
    E findNode(E root, String path);

    /**
     * Apply first the regex pattern to obtain the searched node.
     * <p/>
     * Search then from a given root node a node named by his fully path
     * (concatenation of nodes) {@link NavigationTreeNode#path} valued separated
     * by {@link #getPathSeparator()}.
     *
     * @param root  root node to be used
     * @param path  the fully path of the searched node.
     * @param regex a previous regex to apply to path : must have a matches
     * @return the node matching the fully context from the given root node, or
     *         <code>null</code> if not found.
     */
    E findNode(E root, String path, String regex);

    /**
     * Apply first the regex pattern to obtain the searched node.
     * <p/>
     * Search then from a given root node a node named by his fully path
     * (concatenation of nodes {@link NavigationTreeNode#path} valued separated
     * by {@link #getPathSeparator()}.
     *
     * @param root  root node to be used
     * @param path  the fully path of the searched node.
     * @param regex a previous regex to apply to path : must have a matches
     * @return the node matching the fully context from the given root node, or
     *         <code>null</code> if not found.
     */
    E findNode(E root, String path, Pattern regex);

    JAXXContext getContext();

    /**
     * @return {@code true} if no event should be fired
     */
    boolean isAdjustingValue();

    /**
     * Sets the new internal state {@code adjustingValue}.
     *
     * If the value is {@code true}, no more event will be fired, otherwise
     * will not block events firing.
     *
     * @param adjustingValue the new value of {@code valueAdjusting} state
     */
    void setAdjustingValue(boolean adjustingValue);
    /**
     * Obtain the associated bean value from context corresponding to node from
     * given navigation path.
     *
     * @param navigationPath the current context path of the node
     * @return the value associated in context with the given navigation path
     */
    Object getBean(String navigationPath);

    /**
     * Obtain the associated bean value from context corresponding to node
     *
     * @param node the current node
     * @return the value associated in context with the given node.
     */
    Object getBean(E node);

    void nodeChanged(E node);

    void nodeStructureChanged(E node);

    void nodeChanged(E node, boolean deep);

    String getPathSeparator();

    /**
     * Returns the child of <code>parent</code> at index <code>index</code> in
     * the parent's child array.  <code>parent</code> must be a node previously
     * obtained from this data source. This should not return <code>null</code>
     * if <code>index</code> is a valid index for <code>parent</code> (that is
     * <code>index >= 0 && index < getChildCount(parent</code>)).
     *
     * @param parent a node in the tree, obtained from this data source
     * @param index  index of the node
     * @return the child of <code>parent</code> at index <code>index</code>
     */
    Object getChild(Object parent, int index);

    /**
     * Returns the number of children of <code>parent</code>. Returns 0 if the
     * node is a leaf or if it has no children.  <code>parent</code> must be a
     * node previously obtained from this data source.
     *
     * @param parent a node in the tree, obtained from this data source
     * @return the number of children of the node <code>parent</code>
     */
    int getChildCount(Object parent);

    /**
     * Returns <code>true</code> if <code>node</code> is a leaf. It is possible
     * for this method to return <code>false</code> even if <code>node</code>
     * has no children. A directory in a filesystem, for example, may contain no
     * files; the node representing the directory is not a leaf, but it also has
     * no children.
     *
     * @param node a node in the tree, obtained from this data source
     * @return true if <code>node</code> is a leaf
     */
    boolean isLeaf(Object node);

    /**
     * Messaged when the user has altered the value for the item identified by
     * <code>path</code> to <code>newValue</code>. If <code>newValue</code>
     * signifies a truly new value the model should post a
     * <code>treeNodesChanged</code> event.
     *
     * @param path     path to the node that the user has altered
     * @param newValue the new value from the TreeCellEditor
     */
    void valueForPathChanged(TreePath path, Object newValue);

    /**
     * Returns the index of child in parent.  If either <code>parent</code> or
     * <code>child</code> is <code>null</code>, returns -1. If either
     * <code>parent</code> or <code>child</code> don't belong to this tree
     * model, returns -1.
     *
     * @param parent a node in the tree, obtained from this data source
     * @param child  the node we are interested in
     * @return the index of the child in the parent, or -1 if either
     *         <code>child</code> or <code>parent</code> are <code>null</code>
     *         or don't belong to this tree model
     */
    int getIndexOfChild(Object parent, Object child);

//
//  Change Events
//

    /**
     * Adds a listener for the {@code TreeModelEvent} posted after the tree
     * changes.
     *
     * @param l the listener to add
     * @see #removeTreeModelListener
     */
    void addTreeModelListener(TreeModelListener l);

    /**
     * Removes a listener previously added with {@code addTreeModelListener}.
     *
     * @param l the listener to remove
     * @see #addTreeModelListener
     */
    void removeTreeModelListener(TreeModelListener l);
}
