/*
 * #%L
 * JAXX :: Runtime
 * 
 * $Id: NavigationContentUI.java 1847 2010-04-16 12:27:48Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.0.2/jaxx-runtime/src/main/java/jaxx/runtime/swing/navigation/NavigationContentUI.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing.navigation;

import jaxx.runtime.swing.navigation.handler.NavigationHandler;

import java.awt.*;

/**
 * Basic contract on a content UI.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.0.0
 */
public interface NavigationContentUI<E extends NavigationNode<E>> {

    /**
     * Init the ui just before been opened by the method {@link
     * NavigationHandler#openUI(Component, NavigationNode)}.
     *
     * @param node the selected node associated to the ui
     * @throws Exception if any pb while opening the content's ui
     * @see NavigationHandler#openUI(Component, NavigationNode)
     */
    void openUI(E node) throws Exception;

    /**
     * Clean the ui after been closed by the method {@link
     * NavigationHandler#closeUI(Component)}.
     *
     * @param node the selected node associated to the ui
     * @throws Exception if any pb when closing the content'sui
     * @see NavigationHandler#closeUI(Component)
     */
    void closeUI(E node) throws Exception;
}
