package jaxx.runtime.validator.swing.ui;

import jaxx.runtime.validator.BeanValidatorEvent;
import jaxx.runtime.validator.BeanValidatorField;
import jaxx.runtime.validator.BeanValidatorListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.plaf.AbstractLayerUI;

/**
 * Abstract renderer
 *
 * @author chemit
 */
public abstract class AbstractBeanValidatorUI extends AbstractLayerUI<javax.swing.JComponent> implements BeanValidatorListener {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    private static final Log log = LogFactory.getLog(AbstractBeanValidatorUI.class);
    /** the field to render */
    protected BeanValidatorField field;

    public AbstractBeanValidatorUI(BeanValidatorField field) {
        this.field = field;
        if (log.isDebugEnabled()) {
            log.debug("install " + this + "<field:" + field + ">");
        }
    }

    @Override
    public void onFieldChanged(BeanValidatorEvent event) {
        if (field.equals(event.getField())) {
            // ask to repaint the layer
            setDirty(true);
        }
    }

}
