package jaxx.runtime.swing.navigation;

import jaxx.runtime.Decorator;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.navigation.NavigationTreeModel.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

import java.lang.reflect.InvocationTargetException;
import java.util.regex.Pattern;

/**
 * Usefull methods on {@link NavigationTreeModel} and others.
 *
 * @author chemit
 * @see jaxx.runtime.swing.navigation.NavigationTreeModel
 * @see jaxx.runtime.swing.navigation.NavigationTreeModel.NavigationTreeNode
 */
public class NavigationUtil {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private final Log log = LogFactory.getLog(NavigationUtil.class);

    public static String getCurrentNavigationNath(JAXXContext context) {
        return NavigationTreeSelectionAdapter.NAVIGATION_SELECTED_PATH_ENTRY_DEF.getContextValue(context);
    }

    public static NavigationTreeNode getSelectedNode(JAXXContext context) {
        return NavigationTreeSelectionAdapter.NAVIGATION_SELECTED_NODE_ENTRY_DEF.getContextValue(context);
    }

    public static <O> O getSelectedBean(JAXXContext context, Class<O> clazz) {
        return context.getContextValue(clazz, NavigationTreeSelectionAdapter.NAVIGATION_SELECTED_BEAN);
    }

    public static Object getContextValue(JAXXContext context, String contextKey, String navigationPath) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {

        NavigationTreeModel navigationModel = context.getContextValue(NavigationTreeModel.class, contextKey);

        return navigationModel.getJAXXContextValue(context, navigationPath);
    }

    public static NavigationTreeNode findNode(JAXXContext context, String contextKey, String navigationPath) {

        NavigationTreeModel navigationModel = context.getContextValue(NavigationTreeModel.class, contextKey);

        return navigationModel.findNode(navigationPath);
    }

    public static NavigationTreeNode findNode(JAXXContext context, String contextKey, String navigationPath, String regex) {

        NavigationTreeModel navigationModel = context.getContextValue(NavigationTreeModel.class, contextKey);

        return navigationModel.findNode(navigationPath, regex);
    }


    public static NavigationTreeNode findNode(JAXXContext context, String contextKey, String navigationPath, Pattern regex) {

        NavigationTreeModel navigationModel = context.getContextValue(NavigationTreeModel.class, contextKey);

        return navigationModel.findNode(navigationPath, regex);
    }

    public static NavigationTreeNode findNode(JAXXContext context, String contextKey, String navigationPath, String regex, String suffix) {

        NavigationTreeModel navigationModel = context.getContextValue(NavigationTreeModel.class, contextKey);

        NavigationTreeNode navigationTreeNode = navigationModel.findNode(navigationPath, regex);
        if (navigationTreeNode != null && suffix != null) {
            navigationTreeNode = navigationModel.findNode(navigationTreeNode, suffix);
        }
        return navigationTreeNode;
    }

    public static NavigationTreeNode findNode(JAXXContext context, String contextKey, String navigationPath, Pattern regex, String suffix) {

        NavigationTreeModel navigationModel = context.getContextValue(NavigationTreeModel.class, contextKey);

        NavigationTreeNode navigationTreeNode = navigationModel.findNode(navigationPath, regex);
        if (navigationTreeNode != null && suffix != null) {
            navigationTreeNode = navigationModel.findNode(navigationTreeNode, suffix);
        }
        return navigationTreeNode;
    }

    public static class NodeRenderer implements java.io.Serializable {

        protected String libelle;

        protected Decorator<?> decorator;

        protected NavigationTreeNode node;

        protected Class<?> internalClass;

        protected String rendererCachedValue;

        private static final long serialVersionUID = -1238962588426200861L;

        public NodeRenderer(String libelle) {
            this.libelle = libelle;
            this.internalClass = String.class;
        }

        public NodeRenderer(Decorator<?> decorator) {
            this.decorator = decorator;
            this.internalClass = decorator.getInternalClass();
        }

        public String toString(JAXXContext context) {
            if (rendererCachedValue != null) {
                return rendererCachedValue;
            }

            String result;

            if (libelle != null) {
                // simple libelle renderer
                result = _(libelle);
            } else {

                // with decorator renderer

                try {
                    Object bean = node.getJAXXContextValue(context);
                    result = decorator.toString(bean);

                } catch (Exception e) {
                    result = "";
                }
            }
            setRendererCachedValue(result);
            return result;
        }

        public void setNode(NavigationTreeNode node) {
            this.node = node;
        }

        public Class<?> getInternalClass() {
            return internalClass;
        }

        public void setRendererCachedValue(String rendererCachedValue) {
            this.rendererCachedValue = rendererCachedValue;
            if (log.isDebugEnabled()) {
                log.debug(rendererCachedValue);
            }
        }

        public String getRendererCachedValue() {
            return rendererCachedValue;
        }
        
    }

}
