package jaxx.runtime.swing.navigation;

import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.navigation.NavigationTreeModel.NavigationTreeNode;
import jaxx.runtime.swing.navigation.NavigationUtil.NodeRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.StringUtil;

import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import java.awt.Component;

/**
 * A simple cell renderer which use the {@link NavigationTreeNode#renderer} to display node.
 *
 * @author chemit
 */
public class NavigationTreeCellRenderer implements TreeCellRenderer {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private final Log log = LogFactory.getLog(NavigationTreeCellRenderer.class);

    protected JAXXContext context;

    protected DefaultTreeCellRenderer delegate;

    protected static long t = 0;

    public NavigationTreeCellRenderer(JAXXContext context) {
        this.context = context;
        UIManager.put("Tree.rendererFillBackground", false);
        delegate = new DefaultTreeCellRenderer();
    }

    public NavigationTreeCellRenderer(JAXXContext context, DefaultTreeCellRenderer delegate) {
        this.context = context;
        this.delegate = delegate;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        TreePath path = tree.getPathForRow(row);
        if (path == null) {
            return delegate;
        }

        if (value != null) {
            long t0 = System.nanoTime();
            NodeRenderer renderer = getNodeRenderer(value);
            long t1 = System.nanoTime();
            if (renderer != null) {
                value = renderer.toString(context);
                long t2 = System.nanoTime();
                if (log.isDebugEnabled()) {
                    log.debug("use renderer [" + (t++) + "]<" + row + ">" + renderer.decorator + " <" + StringUtil.convertTime(t0, t1) + "/" + StringUtil.convertTime(t1, t2) + ">");
                }
            }
        }

        return delegate.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    /**
     * @param value the value which should be a node
     * @return the nodeRenderer attached to node via the {@link NavigationTreeNode#userObject},
     *         or <code>null</code> if value is null, or value is not int good type.
     */
    protected NodeRenderer getNodeRenderer(Object value) {
        NodeRenderer render = null;

        if (value != null) {
            NavigationTreeNode node = getNode(value);

            if (node != null && node.getUserObject() instanceof NodeRenderer) {
                render = (NodeRenderer) node.getUserObject();
            }
        }
        return render;
    }

    /**
     * @param value the value which should be a node
     * @return the cast {@link NavigationTreeNode}, or <code>null</code> if value is null.
     */
    protected NavigationTreeNode getNode(Object value) {
        return value instanceof NavigationTreeNode ? (NavigationTreeNode) value : null;
    }

}
