/* 
 * *##% Lutin utilities library
 * Copyright (C) 2004 - 2008 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%* */
package jaxx.runtime.swing.editor;

import javax.swing.JComboBox;
import java.util.EnumSet;
import org.nuiton.util.ReflectUtil;

/**
 * Une éditeur d'enum.
 *
 * @param <E> le type d'enumeration a editer.
 * 
 * @author chemit
 *
 * @since 1.6.0
 */
public class EnumEditor<E extends Enum<E>> extends JComboBox {

    /** serialVersionUID */
    private static final long serialVersionUID = 2693771553067104538L;
    protected Class<E> type;

    public static <E extends Enum<E>> EnumEditor<E> newEditor(Class<E> type) {
        return new EnumEditor<E>(type);
    }

    public EnumEditor(Class<E> type) {
        super(buildModel(type));
    }

    @Override
    public E getSelectedItem() {
        return (E) super.getSelectedItem();
    }

    protected static <E extends Enum<E>> Object[] buildModel(Class<E> type) {
        Class<E> enumClass = ReflectUtil.getEnumClass(type);
        EnumSet<E> result = EnumSet.allOf(enumClass);
        return result.toArray(new Object[result.size()]);
    }
}
