/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.plugin;

import com.sun.java.help.search.Indexer;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.FileUtils;
import org.nuiton.jaxx.plugin.AbstractGenerateHelpMojo;
import org.nuiton.plugin.PluginHelper;

@Mojo(name="generate-help-search", defaultPhase=LifecyclePhase.PROCESS_SOURCES, requiresProject=true, requiresDependencyResolution=ResolutionScope.COMPILE)
@Execute(goal="generate-help-files")
public class GenerateHelpSearchMojo
extends AbstractGenerateHelpMojo {
    @Parameter(property="jaxx.outputHelpSearch", defaultValue="${project.basedir}/target/generated-sources/help", required=true)
    protected File outputHelpSearch;
    @Parameter(property="jaxx.inputHelp", defaultValue="${project.basedir}/src/main/help", required=true)
    protected File inputHelp;
    protected String timestamp;

    @Override
    public void init() throws Exception {
        if (!this.generateHelp || !this.generateSearch) {
            return;
        }
        this.timestamp = "-" + System.currentTimeMillis();
        super.init();
    }

    @Override
    public File getTargetDirectory() {
        return this.outputHelpSearch;
    }

    @Override
    public void setTargetDirectory(File targetDirectory) {
        this.outputHelpSearch = targetDirectory;
    }

    @Override
    protected boolean checkSkip() {
        boolean b = super.checkSkip();
        if (b && !this.generateSearch) {
            this.getLog().info((CharSequence)"generateSearch flag is off, will skip goal.");
            return false;
        }
        return b;
    }

    @Override
    protected void doActionForLocale(Locale locale, boolean isDefaultLocale, File localizedTarget, String localePath) throws Exception {
        String language = locale.getLanguage();
        File source = new File(this.inputHelp, localePath);
        File target = new File(localizedTarget, "JavaHelpSearch");
        boolean generate = false;
        if (this.isForce()) {
            generate = true;
        } else if (!target.exists()) {
            generate = true;
        } else {
            Long sourceLast = this.getLastModified(source);
            Long targetLast = this.getLastModified(target);
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("lastModified of source : " + sourceLast));
                this.getLog().info((CharSequence)("lastModified of target : " + targetLast));
            }
            if (targetLast == null || sourceLast == null || targetLast < sourceLast) {
                generate = true;
            }
        }
        if (!generate) {
            this.getLog().info((CharSequence)("Nothing to generate for language " + language + " - all files are up to date."));
            return;
        }
        this.getLog().info((CharSequence)("Generate help search index for language " + language));
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)(" from " + source));
            this.getLog().info((CharSequence)(" to " + target));
        }
        this.createDirectoryIfNecessary(source);
        this.createDirectoryIfNecessary(target);
        this.generateSearchIndex(source, target, locale);
    }

    @Override
    protected void preDoAction() throws IOException {
    }

    @Override
    protected void postDoAction() {
        this.addResourceDir(this.getTargetDirectory(), new String[]{"**/*"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateSearchIndex(File source, File target, Locale locale) throws Exception {
        long t0 = System.nanoTime();
        Method m = Indexer.class.getDeclaredMethod("main", String[].class);
        FileUtils.deleteDirectory((File)target);
        File tmpDir = this.getFileFromBasedir(new String[]{"target", "jaxx-tmp", "indexer-" + locale + this.timestamp});
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("copy files to " + tmpDir + " for indexing them."));
        }
        FileUtils.copyDirectoryStructure((File)source, (File)tmpDir);
        ArrayList<String> params = new ArrayList<String>();
        params.add("-verbose");
        params.add("-db");
        params.add(target.getAbsolutePath());
        params.add("-logfile");
        File logFile = this.getFileFromBasedir(new String[]{"target", "generated-sources", "jaxx", "indexer-" + locale + ".log"});
        params.add(logFile.getAbsolutePath());
        params.add(tmpDir.getAbsolutePath());
        PrintStream out = System.out;
        PrintStream err = System.err;
        try {
            m.invoke(null, new Object[]{params.toArray(new String[params.size()])});
        }
        finally {
            System.setOut(out);
            System.setErr(err);
        }
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Search Index generated for " + locale + " in " + PluginHelper.convertTime((long)(System.nanoTime() - t0))));
        }
    }
}

