package org.nuiton.jaxx.demo.component.swing;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.demo.DemoHelpBroker;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.css.DataBinding;
import org.nuiton.jaxx.runtime.css.Pseudoclasses;
import org.nuiton.jaxx.runtime.swing.VBox;
import org.nuiton.jaxx.runtime.swing.help.JAXXHelpUI;
import static org.nuiton.i18n.I18n.t;

public class JButtonDemo extends DemoPanel implements JAXXHelpUI<DemoHelpBroker> {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1US09TQRSeFtpaHsojYtw1go9EuIWdCUR5hQipYiQxxG6c3jtth8ydGWfmwoUFCxfu/AMu3Lox/AfiysSNW/6DCT/BM9PbR6AtSJPe3Jz5zne+880598dflNEKzQpV83hEjeDeHo5jT0Xc0JB4Wyu7u9uVPeKbdaJ9RaURCjV+qTRKl9Fw0Iprg7xyCZiKDaaiZSomTMU1EUrBCe8gWiyhIW0OGdF1QoxBT3om+1oXd1rIxVhGKqnVVXW3Wr8/L5ylyPrXNEKxBPlZaPvpfxC0ux4soTQNDJoo7eF9XGSY10CcorwGDY3a2BrDWr/GIfmIjlGuhLISKyAzaO5G9jg6RxVLg0aMkOskFG8wJ8yg+Ys9BHDm+U06Tx+AMG9rNTKAsHlSOq6sQaN1woCqiiNmNqGhMavds/14jX7a0Kwk3KdQ7q7FxAnrZohrZNMXvAM4825VxPMGPejlbSPVomxKvpU5rGkoGQGhghs02VknUW+BEy38UBVz/9DBbeSeOzUo48JwuY96CYBh8trD1L7XVBllVARhg6Z7z7EdxbeAagzhdO8htGUc8NPJsfp+cH7WnLwciCtcldWxZDAGUglJlKFW253G2EWGsuIrLBfLKK8Jgw11G/i4v/KdBAnqQcW4u3DL5L3Eug5smdzZ6c+pD38GUHoDDTGBgw1s8Zsob+oKHBMsiOWLZSdu5OAWPMfgP2BQvgrXNqfpEViaXnhm70coUlMi4jBagxUWkSaoin14z6woilkMJj7ub2JL88n2+a9vXx6eNo1MQQsz18lsm5l5j7KUM8qJW+JkP7su7bDUJApEe/m6rSOChcwl4ylbw2cPC+45c8mq9AVnBhQJXMi6Z+lhh6jBjPpxZBlmXaP2zessBl6GItJE7MNcXKduCnaqLhQ9glzMVhit8dB9kyaWGoYUsIGlr0SGPL9UOWWfkzJZ8z4lxq0c6ncUsNDlmxMOGhL345i6Dgf1rWG3lwJscKFCeQAflR5N3r+Sz4a3+iiyDP8ARzMc+lcHAAA=";
    private static final Log log = LogFactory.getLog(JButtonDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton fancyButon;
    protected ImageIcon pencil;
    protected JButton simpleButon;
    protected JButtonDemo topDemoPanel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private VBox $VBox0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void buttonClicked(JButton button) {
        JOptionPane.showMessageDialog(this, button.getText() + " clicked!",
        "onActionPerformed",
        JOptionPane.INFORMATION_MESSAGE);
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JButtonDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JButtonDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public JButtonDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public JButtonDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JButtonDemo() {
        $initialize();
    }

    public JButtonDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public JButtonDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public JButtonDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__fancyButon(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        buttonClicked((JButton) event.getSource());
    }

    public void doActionPerformed__on__simpleButon(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        buttonClicked((JButton) event.getSource());
    }

    public void doMouseEntered__on__fancyButon(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(JButtonDemo.this, fancyButon, "foreground", new Color(255, 0, 0), Pseudoclasses.wrap(fancyButon.getForeground()), 0);
        if (!(value instanceof DataBinding)) {
            fancyButon.setForeground((Color) value);
        }
        value = Pseudoclasses.applyProperty(JButtonDemo.this, fancyButon, "font-style", "italic", Pseudoclasses.wrap((fancyButon.getFont().getStyle() & Font.ITALIC) != 0 ? "italic" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (fancyButon.getFont() != null) {
            if (((String) value).equals("italic")) {
                fancyButon.setFont(fancyButon.getFont().deriveFont(fancyButon.getFont().getStyle() | Font.ITALIC));
            } else {
                fancyButon.setFont(fancyButon.getFont().deriveFont(fancyButon.getFont().getStyle() & ~Font.ITALIC));
            }
        }
        }
    }

    public void doMouseExited__on__fancyButon(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(JButtonDemo.this, fancyButon, "foreground", new Color(255, 0, 0), Pseudoclasses.wrap(fancyButon.getForeground()), 0);
        if (!(value instanceof DataBinding)) {
            fancyButon.setForeground((Color) value);
        }
        value = Pseudoclasses.removeProperty(JButtonDemo.this, fancyButon, "font-style", "italic", Pseudoclasses.wrap((fancyButon.getFont().getStyle() & Font.ITALIC) != 0 ? "italic" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (fancyButon.getFont() != null) {
            if (((String) value).equals("italic")) {
                fancyButon.setFont(fancyButon.getFont().deriveFont(fancyButon.getFont().getStyle() | Font.ITALIC));
            } else {
                fancyButon.setFont(fancyButon.getFont().deriveFont(fancyButon.getFont().getStyle() & ~Font.ITALIC));
            }
        }
        }
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getFancyButon() {
        return fancyButon;
    }

    public ImageIcon getPencil() {
        return pencil;
    }

    public JButton getSimpleButon() {
        return simpleButon;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(DemoHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected VBox get$VBox0() {
        return $VBox0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToTopDemoPanel() {
        add($VBox0);
    }

    protected void createFancyButon() {
        $objectMap.put("fancyButon", fancyButon = new JButton());
        
        fancyButon.setName("fancyButon");
        fancyButon.setText(t("Fancy Button"));
        if (fancyButon.getFont() != null) {
            fancyButon.setFont(fancyButon.getFont().deriveFont((float) 18));
        }
        fancyButon.setForeground(new Color(0, 0, 255));
        if (fancyButon.getFont() != null) {
            fancyButon.setFont(new Font("Arial", fancyButon.getFont().getStyle(), fancyButon.getFont().getSize()));
        }
        fancyButon.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fancyButon"));
        fancyButon.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__fancyButon"));
        fancyButon.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__fancyButon"));
    }

    @Override
    protected void createHelpDefaultId() {
        $objectMap.put("helpDefaultId", helpDefaultId = "ui.component.swing.buttons.JButtonDemo");
    }

    protected void createPencil() {
        $objectMap.put("pencil", pencil = new ImageIcon(getClass().getResource("/org/nuiton/jaxx/demo/images/pencil_black.gif")));
    }

    protected void createSimpleButon() {
        $objectMap.put("simpleButon", simpleButon = new JButton());
        
        simpleButon.setName("simpleButon");
        simpleButon.setText(t("Simple Button"));
        simpleButon.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__simpleButon"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        topDemoPanel = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("topDemoPanel", topDemoPanel);
        createPencil();
        // inline creation of $VBox0
        $objectMap.put("$VBox0", $VBox0 = new VBox());
        
        $VBox0.setName("$VBox0");
        $VBox0.setHorizontalAlignment(0);
        $VBox0.setVerticalAlignment(0);
        createSimpleButon();
        createFancyButon();
        // inline creation of topDemoPanel
        setName("topDemoPanel");
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 0 data bindings
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        addChildrenToTopDemoPanel();
        // inline complete setup of $VBox0
        $VBox0.add(simpleButon);
        $VBox0.add(fancyButon);
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 1 property setters
        fancyButon.setIcon(pencil);
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}