package org.nuiton.jaxx.demo.component.jaxx.widgets.datetime;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.swing.Table;
import org.nuiton.jaxx.widgets.datetime.TimeEditor;

public class TimeEditorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1US1MTQRDuBBMgQXlUiVWeUFCsEnfxUV6wfBCkkApiKQfKXJxkx2RxsjPOzJrlwsGDN/+AB69eLP4D5ckqL175D1bxE+yZTXYJJPjcw+xuT/fXX38z3Z9/QE5JmOOy7gShr3ngbJEocmQYaL9JndUHm5vr1S1a00tU1aQvNJcQP5ksZCtQ9BK70uBUyojkxkiuQXLbSG6JNwUPaHAIaKEMBaW3GVUNSrWGK32Da0q5zxLPhUiEsp2rJ+teub69u76foUsfsgCRQPpFLPvqHwCkVZ8qQ9b3NEyUt8gb4jIS1JGc9IM6FnTa2EqMKPWYNOlr2IHBMuQFkQim4dpfyWPhLFQkNBRnlmiTPyEBZfMaSkdL8HDTqXXQYlvL9+pUK8cjmtr6NnB56GGQNFhCWPS8hlyTe5RpWPkPqGsGKoUemlntcJ4wGkWOaqFkTmw1TsOJb7HGg5d+3e5omO53SjHABqkyK/RoEj/GSJWykgUpm8+jOa3ROE+kOQ/FaJjsct+gkV72KfO6Q0ZoYHIvhhqpaTjbFVNq0NqrRR51h+Sp1Ucfv3onqNldXF5SFTJt/sa7ZRuNd0xgUuA5s1xIXAqpi7Gcb+9KuNxPZGw9J229tAsyFcjJEM14QP273jTuU/SKW3a6f8uaNNbx7e6O/NQ62O/06QCSm/pV1KGRhE0jJBdUat9wG42bNNQ+c9eIWKjAsKIM55mdV7MnM3/W9kT2yGLcIDkGyVkhqoFoucH9vS+TL74PQHYZCowTb5kY/0cwrBuodIMzLxL37ltyI60hXMcMTTxERrY53hs4cwcPnExV/cDDa3M3QpVmT1YpIbW7fvD14/tLex2lMshx5nciU7VyzyHvB8wPqJ1p7XHVc4YVhaKhx9NZ1Gs6Zcy7INpdP2fX+eP1G/MNs9yMQvO6Zdmbr9t2b+yfES4iwk8UmkcS3AYAAA==";
    private static final Log log = LogFactory.getLog(TimeEditorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table configPanel;
    protected TimeEditor editor;
    protected JCheckBox enableButton;
    protected TimeEditorDemoHandler handler;
    protected JTextField labelConfig;
    protected JLabel labelConfigLabel;
    protected TimeEditorDemoModel model;
    protected JPanel result;
    protected JTextField resultTime;
    protected JLabel resultTimeLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private TimeEditorDemo $DemoPanel0;
    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public TimeEditorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TimeEditorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public TimeEditorDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public TimeEditorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TimeEditorDemo() {
        $initialize();
    }

    public TimeEditorDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public TimeEditorDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public TimeEditorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Table getConfigPanel() {
        return configPanel;
    }

    public TimeEditor getEditor() {
        return editor;
    }

    public JCheckBox getEnableButton() {
        return enableButton;
    }

    public TimeEditorDemoHandler getHandler() {
        return handler;
    }

    public JTextField getLabelConfig() {
        return labelConfig;
    }

    public JLabel getLabelConfigLabel() {
        return labelConfigLabel;
    }

    public TimeEditorDemoModel getModel() {
        return model;
    }

    public JPanel getResult() {
        return result;
    }

    public JTextField getResultTime() {
        return resultTime;
    }

    public JLabel getResultTimeLabel() {
        return resultTimeLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigPanel() {
        configPanel.add(labelConfigLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(labelConfig, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(enableButton, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToResult() {
        result.add(resultTimeLabel);
        result.add(resultTime);
    }

    protected void createConfigPanel() {
        $objectMap.put("configPanel", configPanel = new Table());
        
        configPanel.setName("configPanel");
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new TimeEditor(this));
        
        editor.setName("editor");
    }

    protected void createEnableButton() {
        $objectMap.put("enableButton", enableButton = new JCheckBox());
        
        enableButton.setName("enableButton");
    }

    protected void createLabelConfig() {
        $objectMap.put("labelConfig", labelConfig = new JTextField());
        
        labelConfig.setName("labelConfig");
        labelConfig.setColumns(15);
    }

    protected void createLabelConfigLabel() {
        $objectMap.put("labelConfigLabel", labelConfigLabel = new JLabel());
        
        labelConfigLabel.setName("labelConfigLabel");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(TimeEditorDemoModel.class));
    }

    protected void createResult() {
        $objectMap.put("result", result = new JPanel());
        
        result.setName("result");
        result.setLayout(new GridLayout(0,2));
    }

    protected void createResultTime() {
        $objectMap.put("resultTime", resultTime = new JTextField());
        
        resultTime.setName("resultTime");
        resultTime.setColumns(15);
    }

    protected void createResultTimeLabel() {
        $objectMap.put("resultTimeLabel", resultTimeLabel = new JLabel());
        
        resultTimeLabel.setName("resultTimeLabel");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        handler = new TimeEditorDemoHandler();
        handler.beforeInit(this);
        super.$initialize();
        handler.afterInit(this);
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createModel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createConfigPanel();
        createLabelConfigLabel();
        createLabelConfig();
        createEnableButton();
        createEditor();
        createResult();
        createResultTimeLabel();
        createResultTime();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 0 data bindings
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($JPanel0, BorderLayout.NORTH);
        add(result, BorderLayout.CENTER);
        // inline complete setup of $JPanel0
        $JPanel0.add(configPanel, BorderLayout.NORTH);
        $JPanel0.add(editor, BorderLayout.CENTER);
        addChildrenToConfigPanel();
        addChildrenToResult();
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}