package org.nuiton.jaxx.demo.component.jaxx.editor;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.SwingUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.swing.Table;
import org.nuiton.jaxx.runtime.swing.editor.NumberEditor;
import static org.nuiton.i18n.I18n.t;

public class NumberEditorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_AUTO_POPUP = "editor.autoPopup";
    public static final String BINDING_EDITOR_PROPERTY = "editor.property";
    public static final String BINDING_EDITOR_SHOW_POPUP_BUTTON = "editor.showPopupButton";
    public static final String BINDING_EDITOR_SHOW_RESET = "editor.showReset";
    public static final String BINDING_EDITOR_USE_FLOAT = "editor.useFloat";
    public static final String BINDING_EDITOR_USE_SIGN = "editor.useSign";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";
    private static final String BINDING_$JLABEL1_TEXT = "$JLabel1.text";
    private static final String BINDING_$JLABEL2_TEXT = "$JLabel2.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWWz08TQRTHp5UCBREBxRhDrAFBA24FT6bIb1FJ+SEQQuzFaXdCF7c74+ysLBcOHrz5D3jw6sXwPxBPJl688j+Y8Cf4ZrbttrhdVpZDy85777Pf92be63z/g1I2RxOU72mWYwhqafvYdTXuWMKoEG1lfnd3vbhPSmKJ2CVuMEE58v4SSZQsoG69vm4LpBXyQMp6pKwkZauk7CKtMGoRqwGUy6MuWxyaxC4TIgR60DK4ZNvZrbpnzmUOr74rUHXQu359mjxNkKUvSYRcBvL7IO3x/wD4WbflUdLQBerP7+MPOGtiaw/EccPag4R65NqiiW17DVfIe3SEOvKonWEOMIEeXao8CqdQLhOoe2SJVOgGtoj5WKDc+RR0MGqlGs1bIzrYubbmVIqEP1cPksGYorYLlJZRq1QnpkBzMYgK4WM7RrZx0SQgc7hVpe0DqJum3GRQuh7bObJSy7Ff1tStunqr0qnX93VssmxSDBW+2eS7WCaldwvUlX79vixw3zL2LPl4q9nUa5fpwQZlDltwBIht5bJJbCJauqSxI6iiBBhriU3K5xvNth5LFXQDMiHcEmiwKZtt4oplg5i69M7Ug/oxY+bhWnPkQFOkr9QPa/f2UKDJ8L0J2Opz1a8mNFVPqMmWx8WAXVSr0mn8H19VmGywbarRxtFoK+kwMDR/YPi9myigFHdgGY5k61klx80meHmDZrj1oJGvUY4fj4/4t4Oz09p0GQJxmYuiGgYptDrjlBEuDKmt1xstjjDM7CpmuQJK28SEKaym7Fi48q2qJ6gHFX2SpEmS9hLbZaClOk5Pfgy+/X0FJZdRF7SNvoyl/yuUFmUOFaOm7rLZOSXu6kEnfF6XMuHImPiQwlFC16Z1LHCmaFg67OaMC1UaC69SXdTx+tnPr5/vn9QqlQCNI1Ei/Wql3qB2wzINi6hJXB2ygZO3m9nE0ak/QYNmakJ+d7Hq3HqqPp8F5l+kXCfq+M+5jvyaVxnI/xYVZeBCilyejUWAbvAOA5E/QtNeJTLQ+NwoOoLMBHMHI3DbBEwYaX19WYZc3ggh3I5E2IlNCNNwJ7aGaIQwDUOxNUQjhGm4G1tDNMKLkNN+L3a/RCPshBCGY9dhNEJvNd8JWkh5GKVJiwRbMRmd1R+bw5icoOtSDFy6frWKm1/tQhiT03hTvDTmoh6YiN0D0QhhPaDFJkzGJjwBwl+ylOnDkA4AAA==";
    private static final Log log = LogFactory.getLog(NumberEditorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton applyNumberPattern;
    protected JCheckBox autoPopup;
    protected NumberEditorDemoModel demoModel;
    protected NumberEditor editor;
    protected JTextField numberPattern;
    protected JCheckBox showPopupButton;
    protected JCheckBox showResetButton;
    protected JCheckBox useFloat;
    protected JCheckBox useSign;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private NumberEditorDemo $DemoPanel0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void changeNumberPattern() {
        editor.setNumberPattern(numberPattern.getText());
    }
    
    void $afterCompleteSetup() {
        editor.init();
        changeNumberPattern();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public NumberEditorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public NumberEditorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public NumberEditorDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public NumberEditorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public NumberEditorDemo() {
        $initialize();
    }

    public NumberEditorDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public NumberEditorDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public NumberEditorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__applyNumberPattern(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        changeNumberPattern();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getApplyNumberPattern() {
        return applyNumberPattern;
    }

    public JCheckBox getAutoPopup() {
        return autoPopup;
    }

    public NumberEditorDemoModel getDemoModel() {
        return demoModel;
    }

    public NumberEditor getEditor() {
        return editor;
    }

    public JTextField getNumberPattern() {
        return numberPattern;
    }

    public JCheckBox getShowPopupButton() {
        return showPopupButton;
    }

    public JCheckBox getShowResetButton() {
        return showResetButton;
    }

    public JCheckBox getUseFloat() {
        return useFloat;
    }

    public JCheckBox getUseSign() {
        return useSign;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createApplyNumberPattern() {
        $objectMap.put("applyNumberPattern", applyNumberPattern = new JButton());
        
        applyNumberPattern.setName("applyNumberPattern");
        applyNumberPattern.setText(t("jaxxdemo.numbereditor.applyNumberPattern"));
        applyNumberPattern.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__applyNumberPattern"));
    }

    protected void createAutoPopup() {
        $objectMap.put("autoPopup", autoPopup = new JCheckBox());
        
        autoPopup.setName("autoPopup");
        autoPopup.setSelected(false);
        autoPopup.setText(t("jaxxdemo.numbereditor.autoPopup"));
    }

    protected void createDemoModel() {
        $objectMap.put("demoModel", demoModel = new NumberEditorDemoModel());
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new NumberEditor(this));
        
        editor.setName("editor");
    }

    protected void createNumberPattern() {
        $objectMap.put("numberPattern", numberPattern = new JTextField());
        
        numberPattern.setName("numberPattern");
        numberPattern.setColumns(15);
    }

    protected void createShowPopupButton() {
        $objectMap.put("showPopupButton", showPopupButton = new JCheckBox());
        
        showPopupButton.setName("showPopupButton");
        showPopupButton.setSelected(true);
        showPopupButton.setText(t("jaxxdemo.numbereditor.showPopupButton"));
    }

    protected void createShowResetButton() {
        $objectMap.put("showResetButton", showResetButton = new JCheckBox());
        
        showResetButton.setName("showResetButton");
        showResetButton.setSelected(true);
        showResetButton.setText(t("jaxxdemo.numbereditor.showReset"));
    }

    protected void createUseFloat() {
        $objectMap.put("useFloat", useFloat = new JCheckBox());
        
        useFloat.setName("useFloat");
        useFloat.setSelected(true);
        useFloat.setText(t("jaxxdemo.numbereditor.useFloat"));
    }

    protected void createUseSign() {
        $objectMap.put("useSign", useSign = new JCheckBox());
        
        useSign.setName("useSign");
        useSign.setSelected(true);
        useSign.setText(t("jaxxdemo.numbereditor.useSign"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createDemoModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(0,1));
        createUseFloat();
        createUseSign();
        createShowPopupButton();
        createShowResetButton();
        createAutoPopup();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,0));
        createNumberPattern();
        createApplyNumberPattern();
        createEditor();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(0,1));
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 9 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_AUTO_POPUP, true) {
        
            @Override
            public void applyDataBinding() {
                if (autoPopup != null) {
                    $bindingSources.put("autoPopup.getModel()", autoPopup.getModel());
                    autoPopup.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    autoPopup.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.NumberEditorDemo.this, BINDING_EDITOR_AUTO_POPUP));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (autoPopup != null) {
                    editor.setAutoPopup(autoPopup.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (autoPopup != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("autoPopup.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    autoPopup.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.NumberEditorDemo.this, BINDING_EDITOR_AUTO_POPUP));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_PROPERTY, true) {
        
            @Override
            public void applyDataBinding() {
                if (useFloat != null) {
                    $bindingSources.put("useFloat.getModel()", useFloat.getModel());
                    useFloat.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    useFloat.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.NumberEditorDemo.this, BINDING_EDITOR_PROPERTY));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (useFloat != null) {
                    editor.setProperty(useFloat.isSelected() ? "floatProperty" : "integerProperty");
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (useFloat != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("useFloat.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    useFloat.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.NumberEditorDemo.this, BINDING_EDITOR_PROPERTY));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_SHOW_POPUP_BUTTON, true) {
        
            @Override
            public void applyDataBinding() {
                if (showPopupButton != null) {
                    $bindingSources.put("showPopupButton.getModel()", showPopupButton.getModel());
                    showPopupButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    showPopupButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.NumberEditorDemo.this, BINDING_EDITOR_SHOW_POPUP_BUTTON));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showPopupButton != null) {
                    editor.setShowPopupButton(showPopupButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showPopupButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showPopupButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    showPopupButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.NumberEditorDemo.this, BINDING_EDITOR_SHOW_POPUP_BUTTON));
                }
            }
        
            public void $pr$u2(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (showResetButton != null) {
                    $bindingSources.put("showResetButton.getModel()", showResetButton.getModel());
                    showResetButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    showResetButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.NumberEditorDemo.this, BINDING_EDITOR_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showResetButton != null) {
                    editor.setShowReset(showResetButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showResetButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showResetButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    }
                    showResetButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.NumberEditorDemo.this, BINDING_EDITOR_SHOW_RESET));
                }
            }
        
            public void $pr$u3(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_USE_FLOAT, true) {
        
            @Override
            public void applyDataBinding() {
                if (useFloat != null) {
                    $bindingSources.put("useFloat.getModel()", useFloat.getModel());
                    useFloat.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    useFloat.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.NumberEditorDemo.this, BINDING_EDITOR_USE_FLOAT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (useFloat != null) {
                    editor.setUseFloat(useFloat.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (useFloat != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("useFloat.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    }
                    useFloat.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.NumberEditorDemo.this, BINDING_EDITOR_USE_FLOAT));
                }
            }
        
            public void $pr$u4(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_USE_SIGN, true) {
        
            @Override
            public void applyDataBinding() {
                if (useSign != null) {
                    $bindingSources.put("useSign.getModel()", useSign.getModel());
                    useSign.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u5"));
                    useSign.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.NumberEditorDemo.this, BINDING_EDITOR_USE_SIGN));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (useSign != null) {
                    editor.setUseSign(useSign.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (useSign != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("useSign.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u5"));
                    }
                    useSign.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.NumberEditorDemo.this, BINDING_EDITOR_USE_SIGN));
                }
            }
        
            public void $pr$u5(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL0_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (editor != null) {
                    editor.addPropertyChangeListener("numberPattern", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editor != null) {
                    $JLabel0.setText(t(t("jaxxdemo.numbereditor.model.numberPattern", editor.getNumberPattern())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editor != null) {
                    editor.removePropertyChangeListener("numberPattern", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL1_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (demoModel != null) {
                    demoModel.addPropertyChangeListener("integerProperty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (demoModel != null) {
                    $JLabel1.setText(t(t("jaxxdemo.numbereditor.model.int", demoModel.getIntegerProperty())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (demoModel != null) {
                    demoModel.removePropertyChangeListener("integerProperty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL2_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (demoModel != null) {
                    demoModel.addPropertyChangeListener("floatProperty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (demoModel != null) {
                    $JLabel2.setText(t(t("jaxxdemo.numbereditor.model.float", demoModel.getFloatProperty())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (demoModel != null) {
                    demoModel.removePropertyChangeListener("floatProperty", this);
                }
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.NORTH);
        // inline complete setup of $Table0
        $Table0.add($JPanel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JPanel2, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(useFloat);
        $JPanel0.add(useSign);
        $JPanel0.add(showPopupButton);
        $JPanel0.add(showResetButton);
        $JPanel0.add(autoPopup);
        $JPanel0.add($JPanel1);
        // inline complete setup of $JPanel1
        $JPanel1.add(numberPattern);
        $JPanel1.add(applyNumberPattern);
        // inline complete setup of $JPanel2
        $JPanel2.add($JLabel0);
        $JPanel2.add($JLabel1);
        $JPanel2.add($JLabel2);
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
        
        // apply 9 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 9 property setters
        $JPanel0.setBorder(new TitledBorder(t("jaxxdemo.numbereditor.configuration")));
        $JPanel1.setBorder(new TitledBorder(t("jaxxdemo.numbereditor.numberPattern.configuration")));
        SwingUtil.setText(numberPattern, "\\d{0,3}");
        
        editor.setBean(demoModel);
        $JPanel2.setBorder(new TitledBorder(t("jaxxdemo.numbereditor.model")));
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}