package jaxx.demo.component.swing;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.LayoutManager;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JSplitPaneDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1TPW8TQRAdH7ETxw4hMTFGBBSCQanOUBtBUCILLPMh3ES4yfpuFW+0vlt298jRIH4CPwF6GiQ6KkRBTUGD+AsIUdAiZtf2XYwPgYs9a2bem7ezb15/g7yScPGQxLEro0CzIXXbt/b27vcPqad3qfIkEzqUMPrlHHB6UPKTuNJwqdcx8MYY3tgJhyIMaHAM3ezAotJPOVUDSrWG89MIT6lGN0k3YxHJCWsiKov15Y/vzgv/+SsHIBaoroBX2fgXKr3JXAcc5mtYxU5PSIOT4ABlSBYcoN4lE9vhRKl7ZEgfwzOY70BBEIlkGjb//8qWw+JjoaFU36XD8AEJKL+qYcuK9THiehMKVx2hArfdFZxpU2gAQliKgoZyPc0gQ9XIjGcwpriYYJYQ48mQ8zHozDQoSZnycoJaqLc7pG91rk4BbNQULWd3uGaCK9lkNnfaHGsCX+vc1GuhD9zUB+lD5XqQlxGGNdR6s9Z5iKmRaWp/mMYQ2uyvauXzu69vWxOnONh7LbP0mNHxBYUMBZWamdbLI5tEmvHGXSKaPSgqynFL7BasZwjrjtMoDvutGLhr4O5togZIkZ//8v5Ddf/TCXBasMhD4reIqb8DRT2QOIWQ+7G4uW0VlY8W8DxltGmYY14YaDh53SeabPRZ4OPL3IhxBOsZI0h09Isff1a6b7YnY8ihrLN/LU9HkX8EBRZwFlC7MuNtyFyRklA08sPU9Vl7kDPfihi7+oI9N2fvacJ1c1yOI/O5YiWbf1s2V0OG3ziCTIHCBAAA";
    private static final Log log = LogFactory.getLog(JSplitPaneDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSplitPaneDemo $DemoPanel0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private JSplitPane $JSplitPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JSplitPaneDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JSplitPaneDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public JSplitPaneDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public JSplitPaneDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JSplitPaneDemo() {
        $initialize();
    }

    public JSplitPaneDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public JSplitPaneDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public JSplitPaneDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($JSplitPane0);
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add($JScrollPane0, JSplitPane.LEFT);
        $JSplitPane0.add($JScrollPane1, JSplitPane.RIGHT);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add($JLabel0);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add($JLabel1);
        
        // apply 2 property setters
        $JLabel0.setIcon(new ImageIcon(getClass().getResource("/jaxx/demo/images/Amethyst.jpg")));
        $JLabel1.setIcon(new ImageIcon(getClass().getResource("/jaxx/demo/images/Lynx.jpg")));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new JSplitPane());
        
        $JSplitPane0.setName("$JSplitPane0");
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        
        $completeSetup();
    }

}