package jaxx.demo.component.jaxx.editor.gis;

/*
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.gis.DmdCoordinate;
import jaxx.runtime.swing.editor.gis.DmdCoordinateEditor;
import jaxx.runtime.swing.editor.gis.DmsCoordinate;
import jaxx.runtime.swing.editor.gis.DmsCoordinateEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class CoordinateDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_LATITUDE_DD = "latitudeDd";
    public static final String PROPERTY_LONGITUDE_DD = "longitudeDd";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_LATITUDE_DD_EDITOR_SHOW_RESET = "latitudeDdEditor.showReset";
    public static final String BINDING_LATITUDE_DMD_EDITOR_SHOW_RESET = "latitudeDmdEditor.showReset";
    public static final String BINDING_LATITUDE_DMS_EDITOR_SHOW_RESET = "latitudeDmsEditor.showReset";
    public static final String BINDING_LONGITUDE_DD_EDITOR_SHOW_RESET = "longitudeDdEditor.showReset";
    public static final String BINDING_LONGITUDE_DMD_EDITOR_SHOW_RESET = "longitudeDmdEditor.showReset";
    public static final String BINDING_LONGITUDE_DMS_EDITOR_SHOW_RESET = "longitudeDmsEditor.showReset";
    public static final String BINDING_RESULT_LATITUDE_TEXT = "resultLatitude.text";
    public static final String BINDING_RESULT_LONGITUDE_TEXT = "resultLongitude.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAMVYS28jRRDuOLHzcB6bLLsEEbJJNiBHK02yIEAiAUJissvKSVZxkCJy2ba7sSeMZ4aZns1E1iJ+Aj8B7lyQuHFCHDhz4IL4Cwhx4IqonkfPw217vA5iDxOru+qrr6qruqr32z9Q3rbQ6gV2XcVydKa2qPLog7Oz49oFrbMyteuWajLDQv6/kRzKnaMiEes2Q3fPK1x9M1Df3DdapqFTPaa9XUFTNrvSqN2klDH0SlKjbtubVbG97ZqOFaIKUjLUr//6M/cV+fKbHEKuCezWwJWVflqRJ2MVlFMJQwtg6Sne1LDeABqWqjeA7wxf29ewbR/hFv0cfYHGK6hgYgvAGFrL7rKH4em7JkPF9TJtGY+xTrUthl73yBJYUeohhOKtUaICiNJQbfDBsIiqY0a5qml6YAWG8i2DUI2htwcHOeSaEVJRw0xlDqHlFpznvUQE7UuIRxwJZCIwKQbJgEFkGFMCAyDm+AEo/FCUA83ALBKb1gy9EfLla/PyPcLXXohTFHve1ovR1vj6Ka5pFI5kUcLc2+OSk0KhUDf0T9UGJA+n6QaCj7yD5SLLQnLWl6wErvHVu/yzKiTmQ7erTePyhNq8Qm4lYPebtP7ZnuFyhfUIOdT72PZPbjGhdIKJauw5jBl6Lz0vFPeSEjNxCZnAXOBUGFCJVwsi2sItvlPin60ISEj5TghbXUWIRGQ2ISKTmFj3z2ZLMF2O5UzgLZcQ++90ng/w+9BLYobuD1Akvg4H25FhksyYpDfmjah8QsjXukMeOa0atWQ4MyKaXQKyEC/ACGGXfx5IpUgktZ+Umo8VZSR0kBQqWNR2NCY5u1l/J6yudD1WcM2vx+MonQKNeOpWkyKiQMIwrknCyLukX10PLMMxTUm+Rv6cwbaFXk7AQNdToq4XtaWRc5S3HFiGgj7vbJQnsOW3yMVUi+SA3u4/t2/++sPv3x+EfXEJbN+SisbaOvQr0zJMajGVm57zm6LDVG3zEJvb52jSphrMBF7PX5IQqwbbQA7szXvXN1dXHmK7CRD58d9+/On2k19GUe4ArnoDkwPM5T9Ck6wJh9I0NOKa7+96jKYvJ+B7g3OD469B2gMxtNPW6eXKqco0Sva8tRIreYfjtT/dS+kgv/0byrHgKA19bWPjmQshW5KETPCuTf78983qd7th2EbAjZe6ikehy3+CCqquqTr1BopgVpAOEEXTpg4xoplANiUg0V7CrHrifUlHbHJwsfmnQqFjjjHLofwPdfmMJcJSF7eGYodXsetwxKbnJf91gWR9qJ/9sR7278jsJwaNYi0qH0nR5Z9ijeONlg+rMrqp9teP62hWZmQQZuX+zMgwUVzuyTU71VxZyjTZ6IdJtzvyKuyZcJIRYZhYrUhjFWtV6Wilb+r+OZceV7InXT9yHUfZk5z0MNOD0rAVETXm7Ny65FlqQOvHLH7nv9n7zpeUhX/Zd5JIzHn9KPAxIOiHV1UK1zEEoWAHP8ZqFOtQPe3YffYsplCmDYv39AIJfoidQ1V3GN9pBT8m7WjoX2l33MCKaleDdC9tgIlpwUltAIMxG/70vMvFhJbBYYlb5P9zC9IsMlxXWxjeuuPE/9XHZZLN5TwAOjYNbAZ3iR+DQps1VX6mEyDgvT+FxETIKvVgHchlmQMd8/sgZfJW9jIJS7FbnSTn/+solNl2/Bq+hpRabXe2juctFclrJnutJDy7jmJ5Xs8GrRbJ6+w/L5dioqUM5rW84tNvx0Eq5o3MFeO/GLuVS/A4zWA66LZKu4l1olF41lPxcj2FrZL3P3rx1VIXm6lnb3bbWwnbYfhSxsPlbtbTT+gsUdfwlQEjBJrdIZjhlZqqQ3Ab73XAj/DvVF9EWB454p9jOcLa0AivDo1wf2iE7aER3h0a4eHQCI8B4V9n+lPRaRgAAA==";
    private static final Log log = LogFactory.getLog(CoordinateDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel config;
    protected JPanel configLatitude;
    protected JPanel configLongitude;
    protected final CoordinateDemoHandler handler = createHandler();
    protected Float latitudeDd;
    protected NumberEditor latitudeDdEditor;
    protected DmdCoordinate latitudeDmd;
    protected DmdCoordinateEditor latitudeDmdEditor;
    protected DmsCoordinate latitudeDms;
    protected DmsCoordinateEditor latitudeDmsEditor;
    protected JAXXButtonGroup latitudeEditor;
    protected JPanel latitudePane;
    protected JCheckBox latitudeShowReset;
    protected JRadioButton latitudeUseDd;
    protected JRadioButton latitudeUseDmd;
    protected JRadioButton latitudeUseDms;
    protected Float longitudeDd;
    protected NumberEditor longitudeDdEditor;
    protected DmdCoordinate longitudeDmd;
    protected DmdCoordinateEditor longitudeDmdEditor;
    protected DmsCoordinate longitudeDms;
    protected DmsCoordinateEditor longitudeDmsEditor;
    protected JAXXButtonGroup longitudeEditor;
    protected JPanel longitudePane;
    protected JCheckBox longitudeShowReset;
    protected JRadioButton longitudeUseDd;
    protected JRadioButton longitudeUseDmd;
    protected JRadioButton longitudeUseDms;
    protected CoordinateDemoModel model;
    protected JPanel result;
    protected JLabel resultLatitude;
    protected JLabel resultLongitude;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private CoordinateDemo $DemoPanel0 = this;
    private JPanel $JPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CoordinateDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CoordinateDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public CoordinateDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CoordinateDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CoordinateDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public CoordinateDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CoordinateDemo() {
        $initialize();
    }

    public CoordinateDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__latitudeUseDd(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.useLatitudeDdEditor();
    }

    public void doActionPerformed__on__latitudeUseDmd(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.useLatitudeDmdEditor();
    }

    public void doActionPerformed__on__latitudeUseDms(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.useLatitudeDmsEditor();
    }

    public void doActionPerformed__on__longitudeUseDd(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.useLongitudeDdEditor();
    }

    public void doActionPerformed__on__longitudeUseDmd(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.useLongitudeDmdEditor();
    }

    public void doActionPerformed__on__longitudeUseDms(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.useLongitudeDmsEditor();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getConfig() {
        return config;
    }

    public JPanel getConfigLatitude() {
        return configLatitude;
    }

    public JPanel getConfigLongitude() {
        return configLongitude;
    }

    public CoordinateDemoHandler getHandler() {
        return handler;
    }

    public Float getLatitudeDd() {
        return latitudeDd;
    }

    public NumberEditor getLatitudeDdEditor() {
        return latitudeDdEditor;
    }

    public DmdCoordinate getLatitudeDmd() {
        return latitudeDmd;
    }

    public DmdCoordinateEditor getLatitudeDmdEditor() {
        return latitudeDmdEditor;
    }

    public DmsCoordinate getLatitudeDms() {
        return latitudeDms;
    }

    public DmsCoordinateEditor getLatitudeDmsEditor() {
        return latitudeDmsEditor;
    }

    public JAXXButtonGroup getLatitudeEditor() {
        return latitudeEditor;
    }

    public JPanel getLatitudePane() {
        return latitudePane;
    }

    public JCheckBox getLatitudeShowReset() {
        return latitudeShowReset;
    }

    public JRadioButton getLatitudeUseDd() {
        return latitudeUseDd;
    }

    public JRadioButton getLatitudeUseDmd() {
        return latitudeUseDmd;
    }

    public JRadioButton getLatitudeUseDms() {
        return latitudeUseDms;
    }

    public Float getLongitudeDd() {
        return longitudeDd;
    }

    public NumberEditor getLongitudeDdEditor() {
        return longitudeDdEditor;
    }

    public DmdCoordinate getLongitudeDmd() {
        return longitudeDmd;
    }

    public DmdCoordinateEditor getLongitudeDmdEditor() {
        return longitudeDmdEditor;
    }

    public DmsCoordinate getLongitudeDms() {
        return longitudeDms;
    }

    public DmsCoordinateEditor getLongitudeDmsEditor() {
        return longitudeDmsEditor;
    }

    public JAXXButtonGroup getLongitudeEditor() {
        return longitudeEditor;
    }

    public JPanel getLongitudePane() {
        return longitudePane;
    }

    public JCheckBox getLongitudeShowReset() {
        return longitudeShowReset;
    }

    public JRadioButton getLongitudeUseDd() {
        return longitudeUseDd;
    }

    public JRadioButton getLongitudeUseDmd() {
        return longitudeUseDmd;
    }

    public JRadioButton getLongitudeUseDms() {
        return longitudeUseDms;
    }

    public CoordinateDemoModel getModel() {
        return model;
    }

    public JPanel getResult() {
        return result;
    }

    public JLabel getResultLatitude() {
        return resultLatitude;
    }

    public JLabel getResultLongitude() {
        return resultLongitude;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setLatitudeDd(Float latitudeDd) {
        Float oldValue = this.latitudeDd;
        this.latitudeDd = latitudeDd;
        firePropertyChange(PROPERTY_LATITUDE_DD, oldValue, latitudeDd);
    }

    public void setLongitudeDd(Float longitudeDd) {
        Float oldValue = this.longitudeDd;
        this.longitudeDd = longitudeDd;
        firePropertyChange(PROPERTY_LONGITUDE_DD, oldValue, longitudeDd);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfig() {
        if (!allComponentsCreated) {
            return;
        }
        config.add(configLatitude);
        config.add(configLongitude);
    }

    protected void addChildrenToConfigLatitude() {
        if (!allComponentsCreated) {
            return;
        }
        configLatitude.add(latitudeShowReset);
        configLatitude.add(latitudeUseDms);
        configLatitude.add(latitudeUseDmd);
        configLatitude.add(latitudeUseDd);
    }

    protected void addChildrenToConfigLongitude() {
        if (!allComponentsCreated) {
            return;
        }
        configLongitude.add(longitudeShowReset);
        configLongitude.add(longitudeUseDms);
        configLongitude.add(longitudeUseDmd);
        configLongitude.add(longitudeUseDd);
    }

    protected void addChildrenToLatitudePane() {
        if (!allComponentsCreated) {
            return;
        }
        latitudePane.add(latitudeDmsEditor);
        latitudePane.add(latitudeDmdEditor);
        latitudePane.add(latitudeDdEditor);
    }

    protected void addChildrenToLatitudeUseDd() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = latitudeEditor; latitudeUseDd.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(latitudeUseDd); }
    }

    protected void addChildrenToLatitudeUseDmd() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = latitudeEditor; latitudeUseDmd.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(latitudeUseDmd); }
    }

    protected void addChildrenToLatitudeUseDms() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = latitudeEditor; latitudeUseDms.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(latitudeUseDms); }
    }

    protected void addChildrenToLongitudePane() {
        if (!allComponentsCreated) {
            return;
        }
        longitudePane.add(longitudeDmsEditor);
        longitudePane.add(longitudeDmdEditor);
        longitudePane.add(longitudeDdEditor);
    }

    protected void addChildrenToLongitudeUseDd() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = longitudeEditor; longitudeUseDd.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(longitudeUseDd); }
    }

    protected void addChildrenToLongitudeUseDmd() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = longitudeEditor; longitudeUseDmd.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(longitudeUseDmd); }
    }

    protected void addChildrenToLongitudeUseDms() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = longitudeEditor; longitudeUseDms.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(longitudeUseDms); }
    }

    protected void addChildrenToResult() {
        if (!allComponentsCreated) {
            return;
        }
        result.add(resultLatitude);
        result.add(resultLongitude);
    }

    protected void createConfig() {
        $objectMap.put("config", config = new JPanel());
        
        config.setName("config");
        config.setLayout(new GridLayout(1,0));
    }

    protected void createConfigLatitude() {
        $objectMap.put("configLatitude", configLatitude = new JPanel());
        
        configLatitude.setName("configLatitude");
        configLatitude.setLayout(new GridLayout(0,1));
    }

    protected void createConfigLongitude() {
        $objectMap.put("configLongitude", configLongitude = new JPanel());
        
        configLongitude.setName("configLongitude");
        configLongitude.setLayout(new GridLayout(0,1));
    }

    protected CoordinateDemoHandler createHandler() {
        return new CoordinateDemoHandler();
    }

    protected void createLatitudeDd() {
        $objectMap.put("latitudeDd", latitudeDd = null);
    }

    protected void createLatitudeDdEditor() {
        $objectMap.put("latitudeDdEditor", latitudeDdEditor = new NumberEditor(this));
        
        latitudeDdEditor.setName("latitudeDdEditor");
        latitudeDdEditor.setUseSign(true);
        latitudeDdEditor.setProperty("latitudeDd");
        latitudeDdEditor.setUseFloat(true);
    }

    protected void createLatitudeDmd() {
        $objectMap.put("latitudeDmd", latitudeDmd = new DmdCoordinate());
    }

    protected void createLatitudeDmdEditor() {
        $objectMap.put("latitudeDmdEditor", latitudeDmdEditor = new DmdCoordinateEditor(this));
        
        latitudeDmdEditor.setName("latitudeDmdEditor");
        latitudeDmdEditor.setPropertyDegree("degree");
        latitudeDmdEditor.setPropertyMinute("minute");
        latitudeDmdEditor.setPropertySign("sign");
        latitudeDmdEditor.setPropertyDecimal("decimal");
    }

    protected void createLatitudeDms() {
        $objectMap.put("latitudeDms", latitudeDms = new DmsCoordinate());
    }

    protected void createLatitudeDmsEditor() {
        $objectMap.put("latitudeDmsEditor", latitudeDmsEditor = new DmsCoordinateEditor(this));
        
        latitudeDmsEditor.setName("latitudeDmsEditor");
        latitudeDmsEditor.setPropertySecond("second");
        latitudeDmsEditor.setPropertyDegree("degree");
        latitudeDmsEditor.setPropertyMinute("minute");
        latitudeDmsEditor.setPropertySign("sign");
    }

    protected void createLatitudeEditor() {
        $objectMap.put("latitudeEditor", latitudeEditor = new JAXXButtonGroup());
    }

    protected void createLatitudePane() {
        $objectMap.put("latitudePane", latitudePane = new JPanel());
        
        latitudePane.setName("latitudePane");
        latitudePane.setLayout(new GridLayout(0,1));
    }

    protected void createLatitudeShowReset() {
        $objectMap.put("latitudeShowReset", latitudeShowReset = new JCheckBox());
        
        latitudeShowReset.setName("latitudeShowReset");
        latitudeShowReset.setText(t("jaxxdemo.coordinate.showReset"));
        latitudeShowReset.setSelected(true);
    }

    protected void createLatitudeUseDd() {
        $objectMap.put("latitudeUseDd", latitudeUseDd = new JRadioButton());
        
        latitudeUseDd.setName("latitudeUseDd");
        latitudeUseDd.setText(t("jaxxdemo.coordinate.latitudeDd"));
        latitudeUseDd.setSelected(true);
        { latitudeUseDd.putClientProperty("$value", "DD");  Object $buttonGroup = latitudeUseDd.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        latitudeUseDd.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__latitudeUseDd"));
    }

    protected void createLatitudeUseDmd() {
        $objectMap.put("latitudeUseDmd", latitudeUseDmd = new JRadioButton());
        
        latitudeUseDmd.setName("latitudeUseDmd");
        latitudeUseDmd.setText(t("jaxxdemo.coordinate.latitudeDmd"));
        { latitudeUseDmd.putClientProperty("$value", "DMD");  Object $buttonGroup = latitudeUseDmd.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        latitudeUseDmd.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__latitudeUseDmd"));
    }

    protected void createLatitudeUseDms() {
        $objectMap.put("latitudeUseDms", latitudeUseDms = new JRadioButton());
        
        latitudeUseDms.setName("latitudeUseDms");
        latitudeUseDms.setText(t("jaxxdemo.coordinate.latitudeDms"));
        latitudeUseDms.setSelected(true);
        { latitudeUseDms.putClientProperty("$value", "DMS");  Object $buttonGroup = latitudeUseDms.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        latitudeUseDms.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__latitudeUseDms"));
    }

    protected void createLongitudeDd() {
        $objectMap.put("longitudeDd", longitudeDd = null);
    }

    protected void createLongitudeDdEditor() {
        $objectMap.put("longitudeDdEditor", longitudeDdEditor = new NumberEditor(this));
        
        longitudeDdEditor.setName("longitudeDdEditor");
        longitudeDdEditor.setUseSign(true);
        longitudeDdEditor.setProperty("longitudeDd");
        longitudeDdEditor.setUseFloat(true);
    }

    protected void createLongitudeDmd() {
        $objectMap.put("longitudeDmd", longitudeDmd = new DmdCoordinate());
    }

    protected void createLongitudeDmdEditor() {
        $objectMap.put("longitudeDmdEditor", longitudeDmdEditor = new DmdCoordinateEditor(this));
        
        longitudeDmdEditor.setName("longitudeDmdEditor");
        longitudeDmdEditor.setPropertyDegree("degree");
        longitudeDmdEditor.setPropertyMinute("minute");
        longitudeDmdEditor.setPropertySign("sign");
        longitudeDmdEditor.setPropertyDecimal("decimal");
    }

    protected void createLongitudeDms() {
        $objectMap.put("longitudeDms", longitudeDms = new DmsCoordinate());
    }

    protected void createLongitudeDmsEditor() {
        $objectMap.put("longitudeDmsEditor", longitudeDmsEditor = new DmsCoordinateEditor(this));
        
        longitudeDmsEditor.setName("longitudeDmsEditor");
        longitudeDmsEditor.setPropertySecond("second");
        longitudeDmsEditor.setPropertyDegree("degree");
        longitudeDmsEditor.setPropertyMinute("minute");
        longitudeDmsEditor.setPropertySign("sign");
    }

    protected void createLongitudeEditor() {
        $objectMap.put("longitudeEditor", longitudeEditor = new JAXXButtonGroup());
    }

    protected void createLongitudePane() {
        $objectMap.put("longitudePane", longitudePane = new JPanel());
        
        longitudePane.setName("longitudePane");
        longitudePane.setLayout(new GridLayout(0,1));
    }

    protected void createLongitudeShowReset() {
        $objectMap.put("longitudeShowReset", longitudeShowReset = new JCheckBox());
        
        longitudeShowReset.setName("longitudeShowReset");
        longitudeShowReset.setText(t("jaxxdemo.numbereditor.showReset"));
        longitudeShowReset.setSelected(true);
    }

    protected void createLongitudeUseDd() {
        $objectMap.put("longitudeUseDd", longitudeUseDd = new JRadioButton());
        
        longitudeUseDd.setName("longitudeUseDd");
        longitudeUseDd.setText(t("jaxxdemo.coordinate.longitudeDd"));
        { longitudeUseDd.putClientProperty("$value", "DD");  Object $buttonGroup = longitudeUseDd.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        longitudeUseDd.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__longitudeUseDd"));
    }

    protected void createLongitudeUseDmd() {
        $objectMap.put("longitudeUseDmd", longitudeUseDmd = new JRadioButton());
        
        longitudeUseDmd.setName("longitudeUseDmd");
        longitudeUseDmd.setText(t("jaxxdemo.coordinate.longitudeDmd"));
        { longitudeUseDmd.putClientProperty("$value", "DMD");  Object $buttonGroup = longitudeUseDmd.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        longitudeUseDmd.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__longitudeUseDmd"));
    }

    protected void createLongitudeUseDms() {
        $objectMap.put("longitudeUseDms", longitudeUseDms = new JRadioButton());
        
        longitudeUseDms.setName("longitudeUseDms");
        longitudeUseDms.setText(t("jaxxdemo.coordinate.longitudeDms"));
        longitudeUseDms.setSelected(true);
        { longitudeUseDms.putClientProperty("$value", "DMS");  Object $buttonGroup = longitudeUseDms.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        longitudeUseDms.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__longitudeUseDms"));
    }

    protected void createModel() {
        $objectMap.put("model", model = new CoordinateDemoModel());
    }

    protected void createResult() {
        $objectMap.put("result", result = new JPanel());
        
        result.setName("result");
        result.setLayout(new GridLayout(0,1));
    }

    protected void createResultLatitude() {
        $objectMap.put("resultLatitude", resultLatitude = new JLabel());
        
        resultLatitude.setName("resultLatitude");
    }

    protected void createResultLongitude() {
        $objectMap.put("resultLongitude", resultLongitude = new JLabel());
        
        resultLongitude.setName("resultLongitude");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.NORTH);
        // inline complete setup of $Table0
        $Table0.add(config, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(result, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToConfig();
        addChildrenToConfigLatitude();
        addChildrenToLatitudeUseDms();
        addChildrenToLatitudeUseDmd();
        addChildrenToLatitudeUseDd();
        addChildrenToConfigLongitude();
        addChildrenToLongitudeUseDms();
        addChildrenToLongitudeUseDmd();
        addChildrenToLongitudeUseDd();
        // inline complete setup of $JPanel0
        $JPanel0.add(latitudePane);
        $JPanel0.add(longitudePane);
        addChildrenToLatitudePane();
        addChildrenToLongitudePane();
        addChildrenToResult();
        
        // apply 8 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 18 property setters
        config.setBorder(new TitledBorder(t("jaxxdemo.numbereditor.configuration")));
        latitudePane.setBorder(new TitledBorder(t("jaxxdemo.coordinate.latitude")));
        latitudeDmsEditor.setBean(latitudeDms);
        latitudeDmdEditor.setBean(latitudeDmd);
        latitudeDdEditor.setBean(this);
        longitudePane.setBorder(new TitledBorder(t("jaxxdemo.coordinate.longitude")));
        longitudeDmsEditor.setBean(longitudeDms);
        longitudeDmdEditor.setBean(longitudeDmd);
        longitudeDdEditor.setBean(this);
        result.setBorder(new TitledBorder(t("jaxxdemo.coordinate.result")));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createModel();
        createLatitudeDms();
        createLatitudeDmd();
        createLatitudeDd();
        createLongitudeDms();
        createLongitudeDmd();
        createLongitudeDd();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createConfig();
        createConfigLatitude();
        createLatitudeShowReset();
        createLatitudeUseDms();
        createLatitudeUseDmd();
        createLatitudeUseDd();
        createConfigLongitude();
        createLongitudeShowReset();
        createLongitudeUseDms();
        createLongitudeUseDmd();
        createLongitudeUseDd();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createLatitudePane();
        createLatitudeDmsEditor();
        createLatitudeDmdEditor();
        createLatitudeDdEditor();
        createLongitudePane();
        createLongitudeDmsEditor();
        createLongitudeDmdEditor();
        createLongitudeDdEditor();
        createResult();
        createResultLatitude();
        createResultLongitude();
        createLatitudeEditor();
        createLongitudeEditor();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        // registers 8 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 8 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DMS_EDITOR_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (latitudeShowReset != null) {
                    $bindingSources.put("latitudeShowReset.getModel()", latitudeShowReset.getModel());
                    latitudeShowReset.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    latitudeShowReset.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.gis.CoordinateDemo.this, BINDING_LATITUDE_DMS_EDITOR_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (latitudeShowReset != null) {
                    latitudeDmsEditor.setShowReset(latitudeShowReset.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (latitudeShowReset != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("latitudeShowReset.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    latitudeShowReset.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.gis.CoordinateDemo.this, BINDING_LATITUDE_DMS_EDITOR_SHOW_RESET));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DMD_EDITOR_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (latitudeShowReset != null) {
                    $bindingSources.put("latitudeShowReset.getModel()", latitudeShowReset.getModel());
                    latitudeShowReset.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    latitudeShowReset.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.gis.CoordinateDemo.this, BINDING_LATITUDE_DMD_EDITOR_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (latitudeShowReset != null) {
                    latitudeDmdEditor.setShowReset(latitudeShowReset.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (latitudeShowReset != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("latitudeShowReset.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    latitudeShowReset.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.gis.CoordinateDemo.this, BINDING_LATITUDE_DMD_EDITOR_SHOW_RESET));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DD_EDITOR_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (latitudeShowReset != null) {
                    $bindingSources.put("latitudeShowReset.getModel()", latitudeShowReset.getModel());
                    latitudeShowReset.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    latitudeShowReset.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.gis.CoordinateDemo.this, BINDING_LATITUDE_DD_EDITOR_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (latitudeShowReset != null) {
                    latitudeDdEditor.setShowReset(latitudeShowReset.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (latitudeShowReset != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("latitudeShowReset.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    latitudeShowReset.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.gis.CoordinateDemo.this, BINDING_LATITUDE_DD_EDITOR_SHOW_RESET));
                }
            }
        
            public void $pr$u2(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DMS_EDITOR_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (longitudeShowReset != null) {
                    $bindingSources.put("longitudeShowReset.getModel()", longitudeShowReset.getModel());
                    longitudeShowReset.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    longitudeShowReset.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.gis.CoordinateDemo.this, BINDING_LONGITUDE_DMS_EDITOR_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (longitudeShowReset != null) {
                    longitudeDmsEditor.setShowReset(longitudeShowReset.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (longitudeShowReset != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("longitudeShowReset.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    }
                    longitudeShowReset.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.gis.CoordinateDemo.this, BINDING_LONGITUDE_DMS_EDITOR_SHOW_RESET));
                }
            }
        
            public void $pr$u3(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DMD_EDITOR_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (longitudeShowReset != null) {
                    $bindingSources.put("longitudeShowReset.getModel()", longitudeShowReset.getModel());
                    longitudeShowReset.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    longitudeShowReset.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.gis.CoordinateDemo.this, BINDING_LONGITUDE_DMD_EDITOR_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (longitudeShowReset != null) {
                    longitudeDmdEditor.setShowReset(longitudeShowReset.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (longitudeShowReset != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("longitudeShowReset.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    }
                    longitudeShowReset.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.gis.CoordinateDemo.this, BINDING_LONGITUDE_DMD_EDITOR_SHOW_RESET));
                }
            }
        
            public void $pr$u4(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DD_EDITOR_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (longitudeShowReset != null) {
                    $bindingSources.put("longitudeShowReset.getModel()", longitudeShowReset.getModel());
                    longitudeShowReset.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u5"));
                    longitudeShowReset.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.gis.CoordinateDemo.this, BINDING_LONGITUDE_DD_EDITOR_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (longitudeShowReset != null) {
                    longitudeDdEditor.setShowReset(longitudeShowReset.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (longitudeShowReset != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("longitudeShowReset.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u5"));
                    }
                    longitudeShowReset.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.gis.CoordinateDemo.this, BINDING_LONGITUDE_DD_EDITOR_SHOW_RESET));
                }
            }
        
            public void $pr$u5(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_LATITUDE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("latitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    resultLatitude.setText(t(handler.getLatitudeText(model.getLatitude())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("latitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_LONGITUDE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("longitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    resultLongitude.setText(t(handler.getLongitudeText(model.getLongitude())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("longitude", this);
                }
            }
        });
    }

}