package jaxx.demo;

import jaxx.demo.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import jaxx.runtime.Util;
import jaxx.runtime.SwingUtil;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import org.apache.commons.io.IOUtils;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import jaxx.runtime.DataBindingListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DemoPanel extends javax.swing.JTabbedPane implements jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(jaxx.demo.DemoPanel.class);
    private static String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1SPW/UQBCdc7gLvgRIOAgBghQ+ajvUhyAo0YlEB0QcRYQb1t4l58j2LrtrYhrET+AnQE+DREeFKKgpaBB/ASEKWsSs784+EyNwsZZm5s2+fe+9/gZNJeHiPskyR6aJDmPmbN/c3b3r77NAbzIVyFBoLmH0NSywPJijRV1puOz1Ddwdw90NHguesGQK3e1DW+mnEVNDxrSGC1VEoJQ7KNrdTKRysrUgVbf15Y/v1gv6/JUFkAlkZ56y+i9U+ZIjfbBCquEk3vSEuBFJ9pCGDJM95HvM1DYiotQdErPH8Axm+9ASROIyDZf+/8n5jhyfCQ0zmuPZyUlSFnNnE48dkrBIiHyqpcGmkxpyMzQyRx0gK2c7L5opuxhuK57KgN0nPlpxpjKNNZ9Rg6lC7CvY2Uoe8TUN5ypyjYDjrjgMuGoKp7Ah4XwFiA46pYOlxA0PmjLFsoZl77Dp97A1snv5D7vNwrz7a6nz+d3Xt72Jxw28+3Tt6FREUXshuWBSh+bqEyODUx1G7m0iuh7YikWY7zy/KzXEBuM2ksP7Fg3cMXDnFlFDXNGc/fL+w9LDTzNg9aAdcUJ7xMxvga2HElXgEc3EjfWc0fzBUTwXDDcN85r4OxEJWJwH6fg1SjRZ9cOEovTXM5RipUaKgo9vf/zZGbxZn5bj7F/HS0maD6AVJlGYsDz04zzXhnxOKJZSXua2LskN818QQvwGBo94uEIEAAA=";
    private static final long serialVersionUID = 1L;
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected java.util.Map<?,?> $previousValues = new java.util.HashMap<Object,Object>();
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();
    protected javax.swing.JPanel demoPanel;
    protected javax.swing.JTabbedPane sourceTabs;
    protected DemoPanel top = this;
    private jaxx.runtime.swing.TabInfo $TabInfo0;
    private jaxx.runtime.swing.TabInfo $TabInfo1;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    private PropertyChangeListener $DataSource2 = new DataBindingListener(this, "$TabInfo0.title");

    /* begin raw body code */    
    
    protected String[] getSources() {
        if (getClass() == DemoPanel.class) {
            return new String[0];
        }
        return new String[]{ getDefaultSource() };
    }
    
    protected String getDefaultSource() {
        return getClass().getSimpleName() + ".jaxx";
    }
    
    public String getLabel() {
        String name = getClass().getSimpleName();
        if (name.endsWith("Demo")) {
            name = name.substring(0, name.length() - "Demo".length());
        }
        return name;
    }
    
    public String getDemoTabTitle() {
        return getLabel() + " Demo";
    }
    
    public String loadSource(String filename) {
        try {
            if (log.isDebugEnabled()) {
                log.debug(filename + " from " + getClass());
            }
            String result = IOUtils.toString(getClass().getResourceAsStream(filename));
    
            return result;
        } catch (Exception e) {
            log.error("could not load file " + filename, e);
            return "could not load file " + filename;
        }
    }
    
    private void $afterCompleteSetup() {
        SwingUtilities.invokeLater(new Runnable() {
    
            @Override
            public void run() {
                if (getSources().length == 0) {
                   top.remove(sourceTabs);
                   return;
                }
                for (String extra : getSources()) {
                    JScrollPane pane = new JScrollPane(
                        JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
                        JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
                    pane.setBorder(null);
                    //pane.setMinimumSize(jaxx.runtime.SwingUtil.newMinDimension());
                    // creation du contenu du fichier
                    RSyntaxTextArea content = new RSyntaxTextArea();
                    if (extra.matches(".*\\.jaxx") || extra.matches(".*\\.xml")){
                        content.setSyntaxEditingStyle(RSyntaxTextArea.SYNTAX_STYLE_XML);
                    } else if (extra.matches(".*\\.java")){
                        content.setSyntaxEditingStyle(RSyntaxTextArea.SYNTAX_STYLE_JAVA);
                    } else if (extra.matches(".*\\.css")){
                        content.setSyntaxEditingStyle(RSyntaxTextArea.SYNTAX_STYLE_CSS);
                    }
                    content.setFont(content.getFont().deriveFont((float) 11));
                    content.setMinimumSize(jaxx.runtime.SwingUtil.newMinDimension());
                    content.setEditable(false);
                    content.setWrapStyleWord(false);
                    content.setText(loadSource(extra));
                    content.setColumns(80);
                    content.setLineWrap(true);
                    pane.getViewport().add(content);
                    content.setCaretPosition(0);
                    // ajout de l'onglet
                    sourceTabs.addTab(extra, pane);
                    int index = sourceTabs.indexOfComponent(pane);
                    JLabel l = new JLabel(extra);
                    l.setFont(l.getFont().deriveFont((float) 10));
                    sourceTabs.setTabComponentAt(index,l);
                }
            }
        });
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public DemoPanel() {
        $initialize();
    }

    public DemoPanel(jaxx.runtime.JAXXContext parentContext) {
        jaxx.runtime.Util.initContext(this, parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ("$TabInfo0.title".equals($binding)) {    
            addPropertyChangeListener("demoTabTitle", $DataSource2);
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("$TabInfo0.title".equals($dest)) {
                $TabInfo0.setTitle(getDemoTabTitle());
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ("$TabInfo0.title".equals($binding)) {    
            removePropertyChangeListener("demoTabTitle", $DataSource2);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return Util.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return Util.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public javax.swing.JPanel getDemoPanel() {
        return demoPanel;
    }

    public javax.swing.JTabbedPane getSourceTabs() {
        return sourceTabs;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected jaxx.runtime.swing.TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToTop();
        // init data bindings
        applyDataBinding("$TabInfo0.title");
        sourceTabs.setTabPlacement(JTabbedPane.BOTTOM);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("top", this);
        createDemoPanel();
        createSourceTabs();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new jaxx.runtime.swing.TabInfo());
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new jaxx.runtime.swing.TabInfo());
        $TabInfo1.setTitle(_("Sources"));
        // inline creation of top
        setName("top");
        
        $completeSetup();
    }

    protected void addChildrenToTop() {
        if (!allComponentsCreated) {
            return;
        }
        add(demoPanel);
        add(sourceTabs);
        $TabInfo0.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(top, 0));
        $TabInfo1.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(top, 1));
        top.setTitleAt(1, _("Sources"));
    }

    protected void createDemoPanel() {
        $objectMap.put("demoPanel", demoPanel = new javax.swing.JPanel());
        demoPanel.setName("demoPanel");
    }

    protected void createSourceTabs() {
        $objectMap.put("sourceTabs", sourceTabs = new javax.swing.JTabbedPane());
        sourceTabs.setName("sourceTabs");
    }

}