/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.tags.swing;

import java.io.IOException;
import java.util.List;
import javax.swing.event.ListSelectionListener;
import org.nuiton.jaxx.compiler.CompiledObject;
import org.nuiton.jaxx.compiler.CompilerException;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptor;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptorHelper;
import org.nuiton.jaxx.compiler.tags.DefaultComponentHandler;
import org.nuiton.jaxx.compiler.tags.swing.CompiledItemContainer;
import org.nuiton.jaxx.compiler.types.TypeManager;
import org.nuiton.jaxx.runtime.swing.Item;
import org.nuiton.jaxx.runtime.swing.JAXXList;
import org.w3c.dom.Element;

public class JAXXListHandler
extends DefaultComponentHandler {
    public JAXXListHandler(ClassDescriptor beanClass) {
        super(beanClass);
        ClassDescriptorHelper.checkSupportClass(this.getClass(), beanClass, JAXXList.class);
    }

    @Override
    protected void configureProxyEventInfo() {
        super.configureProxyEventInfo();
        this.addProxyEventInfo("getSelectedIndex", ListSelectionListener.class, "selectionModel");
        this.addProxyEventInfo("getSelectedIndices", ListSelectionListener.class, "selectionModel");
        this.addProxyEventInfo("getSelectedValue", ListSelectionListener.class, "selectionModel");
        this.addProxyEventInfo("getSelectedValues", ListSelectionListener.class, "selectionModel");
    }

    @Override
    public CompiledObject createCompiledObject(String id, JAXXCompiler compiler) throws CompilerException {
        return new CompiledItemContainer(id, this.getBeanClass(), compiler);
    }

    @Override
    public void compileChildrenSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        super.compileChildrenSecondPass(tag, compiler);
        CompiledItemContainer list = (CompiledItemContainer)compiler.getOpenComponent();
        List<Item> items = list.getItems();
        if (items != null && !items.isEmpty()) {
            String listName = list.getId() + "$items";
            list.appendAdditionCode("java.util.List<org.nuiton.jaxx.runtime.swing.Item> " + listName + " = new java.util.ArrayList<org.nuiton.jaxx.runtime.swing.Item>();");
            for (Item item : items) {
                String id = item.getId();
                CompiledObject compiledItem = new CompiledObject(id, ClassDescriptorHelper.getClassDescriptor(Item.class), compiler);
                compiledItem.setConstructorParams(TypeManager.getJavaCode(id) + ", " + TypeManager.getJavaCode(item.getLabel()) + ", " + TypeManager.getJavaCode(item.getValue()) + ", " + item.isSelected());
                compiler.registerCompiledObject(compiledItem);
                list.appendAdditionCode(listName + ".add(" + id + ");");
            }
            list.appendAdditionCode(list.getId() + ".setItems(" + listName + ");");
        }
    }
}

