/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser.impl;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import org.nuiton.i18n.plugin.parser.I18nSourceEntry;
import org.nuiton.i18n.plugin.parser.SourceEntry;
import org.nuiton.i18n.plugin.parser.impl.AbstractParserXmlMojo;
import org.nuiton.i18n.plugin.parser.impl.ProcessorHelper;
import org.nuiton.io.FileUpdater;
import org.nuiton.io.MirroredFileUpdater;
import org.nuiton.processor.Processor;
import org.nuiton.processor.ProcessorUtil;
import org.nuiton.processor.filters.DefaultFilter;
import org.nuiton.processor.filters.Filter;

public class ParserJspMojo
extends AbstractParserXmlMojo {
    protected File defaultBasedir;
    protected String defaultIncludes;
    protected String coreRuleFile;
    protected String outputGetter;
    protected File workdir;
    MirroredFileUpdater entryUpdater;

    @Override
    public String[] getDefaultIncludes() {
        return new String[]{this.defaultIncludes};
    }

    @Override
    public String[] getDefaultExcludes() {
        return I18nSourceEntry.EMPTY_STRING_ARRAY;
    }

    @Override
    public File getDefaultBasedir() {
        return this.defaultBasedir;
    }

    @Override
    protected boolean onEnterEntry(I18nSourceEntry entry) {
        boolean b = super.onEnterEntry(entry);
        if (!b) {
            this.entryUpdater = (MirroredFileUpdater)entry.getUpdater();
        }
        return b;
    }

    @Override
    public FileUpdater newFileUpdater(SourceEntry entry) {
        return new MirroredFileUpdater("", "", entry.getBasedir(), this.workdir){

            public File getMirrorFile(File f) {
                String file = f.getAbsolutePath().substring(this.prefixSourceDirecotory);
                return new File(this.destinationDirectory + File.separator + file + "~");
            }
        };
    }

    @Override
    protected String getOutGetter() {
        return this.outputGetter;
    }

    @Override
    protected String getCoreRuleFile() {
        return this.coreRuleFile;
    }

    @Override
    protected AbstractParserXmlMojo.XmlFileParser newXmlFileParser(XPath xpath, DocumentBuilder builder) {
        return new AbstractParserXmlMojo.XmlFileParser(this.getLog(), this.getEncoding(), this.oldParser, this.showTouchedFiles, this.rules, xpath, builder, this.namespaces, this.isVerbose()){

            @Override
            public File prepareFile(File file) throws IOException {
                File result = ParserJspMojo.this.entryUpdater.getMirrorFile(file);
                ParserJspMojo.this.createDirectoryIfNecessary(result.getParentFile());
                JspFileProcessor processor = new JspFileProcessor();
                processor.process(file, result, this.getEncoding());
                return result;
            }

            @Override
            public String extract(String i18nString) {
                String s = null;
                if (!i18nString.trim().isEmpty()) {
                    s = i18nString.trim();
                }
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)(i18nString + " = " + s));
                }
                return s;
            }
        };
    }

    @Override
    @Deprecated
    protected String getKeyModifierStart() {
        return "=\\s*[\"']";
    }

    @Override
    @Deprecated
    protected String getKeyModifierEnd() {
        return "[\"']";
    }

    public static class JspFileProcessor
    extends ProcessorHelper.AbstractParserProcessor {
        protected ProcessorUtil.FragmentRemover remover1 = new ProcessorUtil.FragmentRemover("<%--", "--%>");
        protected ProcessorUtil.FragmentRemover remover2 = new ProcessorUtil.FragmentRemover("<%", "%>");

        public JspFileProcessor() {
            this.setInputFilter(new Filter[]{this.remover1, this.remover2, new JspAttributeWithTagFilter()});
        }

        @Override
        public void process(File filein, File fileout, String encoding) throws IOException {
            ProcessorUtil.doProcess((Processor)this, (File)filein, (File)fileout, (String)encoding);
        }

        public static class JspAttributeWithTagFilter
        extends DefaultFilter {
            private String header = "=\"<";
            private String footer = "\"/>\"";

            protected String performInFilter(String ch) {
                return "=\"\"";
            }

            protected String performOutFilter(String ch) {
                return ch;
            }

            protected String getHeader() {
                return this.header;
            }

            protected String getFooter() {
                return this.footer;
            }
        }
    }
}

