/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.processor.Processor;
import org.nuiton.processor.ProcessorUtil;
import org.nuiton.processor.filters.Filter;

public class ProcessorHelper
extends ProcessorUtil {
    private static final Log log = LogFactory.getLog(ProcessorHelper.class);

    public static abstract class AbstractParserProcessor
    extends Processor {
        protected boolean verbose;

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        public abstract void process(File var1, File var2, String var3) throws IOException;

        protected void removefragments(ProcessorUtil.FragmentRemover filter, File filein, File fileout, String encoding, boolean verbose) throws IOException {
            filter.setVerbose(verbose || log.isDebugEnabled());
            this.setInputFilter((Filter)filter);
            ProcessorUtil.doProcess((Processor)this, (File)filein, (File)fileout, (String)encoding);
        }

        public void extractKeys(ProcessorUtil.FragmentExtractor filter, File filein, String encoding, boolean verbose, Set<String> result) throws IOException {
            filter.setVerbose(verbose);
            this.setInputFilter((Filter)filter);
            try (FileInputStream in = new FileInputStream(filein);
                 ByteArrayOutputStream out = new ByteArrayOutputStream();){
                ProcessorUtil.doProcess((Processor)this, (InputStream)in, (OutputStream)out, (String)encoding);
                String lines = ((Object)out).toString();
                for (String line : lines.split("\n")) {
                    String key = line.trim();
                    if (!StringUtils.isNotBlank((CharSequence)key)) continue;
                    result.add(key);
                }
            }
        }

        public void saveKeysToFile(File fileout, Set<String> keys) throws IOException {
            StringBuilder buffer = new StringBuilder();
            ArrayList<String> sortedKeys = new ArrayList<String>(keys);
            Collections.sort(sortedKeys);
            for (String key : sortedKeys) {
                buffer.append(key).append("\n");
            }
            FileUtils.writeStringToFile((File)fileout, (String)buffer.toString(), (Charset)Charset.defaultCharset());
        }
    }
}

