/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.model;

import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.chorem.pollen.votecounting.model.ChoiceScore;
import org.chorem.pollen.votecounting.model.SimpleVoter;
import org.chorem.pollen.votecounting.model.VoteCountingResult;
import org.chorem.pollen.votecounting.model.VoteForChoice;
import org.chorem.pollen.votecounting.model.Voter;

public class GroupOfVoter
implements Voter,
Iterable<Voter> {
    private static final long serialVersionUID = 1L;
    private final SimpleVoter rootVoter = SimpleVoter.newVoter(null, 1.0, null);
    private Set<Voter> voters;
    private VoteCountingResult result;

    public static GroupOfVoter newVoter(String voterId, double weight, Set<Voter> voters) {
        GroupOfVoter result = new GroupOfVoter();
        result.setVoterId(voterId);
        result.setWeight(weight);
        result.setVoters(voters);
        return result;
    }

    @Override
    public String getVoterId() {
        return this.rootVoter.getVoterId();
    }

    @Override
    public double getWeight() {
        return this.rootVoter.getWeight();
    }

    @Override
    public Set<VoteForChoice> getVoteForChoices() {
        return this.rootVoter.getVoteForChoices();
    }

    @Override
    public void setVoterId(String voterId) {
        this.rootVoter.setVoterId(voterId);
    }

    @Override
    public void setWeight(double weight) {
        this.rootVoter.setWeight(weight);
    }

    @Override
    public void addVoteForChoice(VoteForChoice voteForChoice) {
        this.getVoteForChoices().add(voteForChoice);
    }

    public Set<Voter> getVoters() {
        if (this.voters == null) {
            this.voters = Sets.newHashSet();
        }
        return this.voters;
    }

    public void addVoter(Voter voter) {
        this.getVoters().add(voter);
    }

    public VoteCountingResult getResult() {
        return this.result;
    }

    public void setVoters(Set<Voter> voters) {
        this.voters = voters;
    }

    public void setResult(VoteCountingResult result) {
        this.result = result;
        List<ChoiceScore> winners = result.getTopRanking();
        for (ChoiceScore choiceScore : result.getScores()) {
            double score = winners.contains(choiceScore) ? 1.0 : 0.0;
            VoteForChoice voteForChoice = VoteForChoice.newVote(choiceScore.getChoiceId(), score);
            this.addVoteForChoice(voteForChoice);
        }
    }

    @Override
    public Iterator<Voter> iterator() {
        return this.getVoters().iterator();
    }
}

