/* *##%
 * Copyright (C) 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package org.chorem.pollen.war;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Map;

import winstone.Launcher;

/**
 * War main class launcher.
 * 
 * Based on winstone micro container.
 * 
 * To use it :
 *  java -jar pollen-xxx.war
 * 
 * @author chatellier
 * @version $Revision: 2778 $
 * 
 * Last update : $Date: 2009-10-12 14:25:49 +0200 (lun., 12 oct. 2009) $
 * By : $Author$
 */
public class PollenWarLauncher {

    /**
     * Main method (used by war in manifest).
     * 
     * @param args args
     * @throws IOException
     */
    public static void main(String[] args) throws IOException {

        System.out.println("Starting pollen embedded mode...");

        String fqnLauncherFile = PollenWarLauncher.class.getName().replaceAll("\\.", "/") + ".class";
        System.out.println("Search for launcher class : " + fqnLauncherFile);

        URL classFile = PollenWarLauncher.class.getClassLoader().getResource(fqnLauncherFile);
        System.out.println(" - using classFile : " + classFile);

        // strange following line seams also work for jpnl launch
        File me = new File(((JarURLConnection) classFile.openConnection()).getJarFile().getName());
        System.out.println(" - using warfile file : " + me);

        // hashArgs map, initialized with command line args
        Map<String, String> hashArgs = Launcher.getArgsFromCommandLine(args);

        hashArgs.put("warfile", me.getAbsolutePath()); // or any other command line args, eg port

        // add jndi info to swap configuration file
        hashArgs.put("useJNDI", "true");
        hashArgs.put("jndi.resource.configurationfilename", String.class.getName());
        hashArgs.put("jndi.param.configurationfilename.value","pollenembedded.properties");

        System.out.println(" - using args : " + hashArgs);

        Launcher.initLogger(hashArgs);
        Launcher winstone = new Launcher(hashArgs); // spawns threads, so your application doesn't block
    }
}
