/*
 * #%L
 * Pollen :: Services
 * $Id: PollenApplicationContext.java 3423 2012-06-05 16:50:22Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4/pollen-services/src/main/java/org/chorem/pollen/PollenApplicationContext.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen;

import com.opensymphony.xwork2.ActionContext;
import org.chorem.pollen.services.PollenNotifierWorker;
import org.nuiton.topia.TopiaContext;

import javax.servlet.ServletContext;
import java.util.Map;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class PollenApplicationContext {

    /** Key to store the single instance of the application context */
    public static final String APPLICATION_CONTEXT_PARAMETER =
            "pollenApplicationContext";

    protected PollenConfiguration configuration;

    protected TopiaContext rootContext;

    protected PollenNotifierWorker pollenNotifierWorker;

    public static PollenApplicationContext get(ActionContext actionContext) {
        Map<String, Object> application = actionContext.getApplication();
        PollenApplicationContext applicationContext =
                (PollenApplicationContext) application.get(APPLICATION_CONTEXT_PARAMETER);
        return applicationContext;
    }

    public static PollenApplicationContext get(ServletContext servletContext) {
        PollenApplicationContext applicationContext =
                (PollenApplicationContext) servletContext.getAttribute(APPLICATION_CONTEXT_PARAMETER);
        return applicationContext;
    }

    public static void set(ServletContext servletContext,
                           PollenApplicationContext context) {
        servletContext.setAttribute(APPLICATION_CONTEXT_PARAMETER, context);
    }

    public static void set(ActionContext actionContext,
                           PollenApplicationContext context) {
        Map<String, Object> application = actionContext.getApplication();
        if (context == null) {

            application.remove(APPLICATION_CONTEXT_PARAMETER);
        } else {

            application.put(APPLICATION_CONTEXT_PARAMETER, context);
        }
    }

    public PollenConfiguration getConfiguration() {
        return configuration;
    }

    public void setConfiguration(PollenConfiguration configuration) {
        this.configuration = configuration;
    }

    public TopiaContext getRootContext() {
        return rootContext;
    }

    public void setRootContext(TopiaContext rootContext) {
        this.rootContext = rootContext;
    }

    public PollenNotifierWorker getPollenNotifierWorker() {
        return pollenNotifierWorker;
    }

    public void setPollenNotifierWorker(PollenNotifierWorker pollenNotifierWorker) {
        this.pollenNotifierWorker = pollenNotifierWorker;
    }
}
