/*
 * #%L
 * Pollen :: Persistence
 * $Id: PollActions.java 3492 2012-06-16 12:38:50Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5/pollen-persistence/src/main/java/org/chorem/pollen/business/persistence/PollActions.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.business.persistence;

/**
 * Enumeration to get all possible actions on poll.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4
 */
public enum PollActions {

    ATTACH("user/attachPoll"),
    VOTE("poll/votefor"),
    RESULT("poll/results"),
    SUMMARY("poll/summary"),
    MODERATE("poll/moderate"),
    EDIT("poll/edit"),
    CLOSE("poll/close"),
    CLONE("poll/clone"),
    EXPORT("poll/export"),
    DELETE("poll/delete");

    /**
     * Prefix to render url.
     *
     * @since 1.4
     */
    private final String actionPrefix;

    private PollActions(String actionPrefix) {
        this.actionPrefix = actionPrefix;
    }

    public String getActionPrefix() {
        return actionPrefix;
    }
}
