/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.persistence;

import com.google.common.base.Preconditions;
import java.util.List;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.PersonToList;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollAccountDAOAbstract;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.Vote;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaQuery;
import org.nuiton.topia.persistence.TopiaFilterPagerUtil;

public class PollAccountDAOImpl<E extends PollAccount>
extends PollAccountDAOAbstract<E> {
    public E getRestrictedPollAccount(String pollId, String accountId) throws TopiaException {
        TopiaQuery query = new TopiaQuery(PersonToList.class, "p").setSelect(new String[]{"p.pollAccount"}).addWhere("p.pollAccount.accountId", TopiaQuery.Op.EQ, (Object)accountId).addWhere("p.votingList.poll.pollId", TopiaQuery.Op.EQ, (Object)pollId);
        PollAccount result = (PollAccount)this.findByQuery(query);
        return (E)result;
    }

    public List<E> getFavoriteListUsers(PersonList favoriteList, TopiaFilterPagerUtil.FilterPagerBean pager) throws TopiaException {
        Preconditions.checkNotNull((Object)favoriteList);
        Preconditions.checkNotNull((Object)pager);
        int records = favoriteList.sizePollAccount();
        pager.setRecords(records);
        TopiaQuery query = this.createQuery("e");
        TopiaFilterPagerUtil.addPagerToQuery((TopiaQuery)query, (TopiaFilterPagerUtil.FilterPagerBean)pager);
        query.addWhere("e.personList", TopiaQuery.Op.EQ, (Object)favoriteList);
        List result = this.findAllByQuery(query);
        return result;
    }

    public boolean isPollAccountExists(PersonList personListToUpdate, PollAccount pollAccount) throws TopiaException {
        Preconditions.checkNotNull((Object)personListToUpdate);
        Preconditions.checkNotNull((Object)pollAccount);
        TopiaQuery query = this.createQuery("e");
        query.addWhere("e.personList", TopiaQuery.Op.EQ, (Object)personListToUpdate);
        query.addWhere("e.email", TopiaQuery.Op.EQ, (Object)pollAccount.getEmail());
        String pollAccountId = pollAccount.getTopiaId();
        if (pollAccountId != null) {
            query.addWhere("e.topiaId", TopiaQuery.Op.NEQ, (Object)pollAccountId);
        }
        boolean result = this.existByQuery(query);
        return result;
    }

    public PollAccount findByPollVoteUser(Poll poll, UserAccount user) throws TopiaException {
        Preconditions.checkNotNull((Object)poll);
        Preconditions.checkNotNull((Object)user);
        TopiaQuery query = this.createQuery("e").addFrom(Poll.class, "p").addFrom(Vote.class, "v").addEquals("p", new Object[]{poll}).addInElements("v", "p.vote").addWhere("e = v.pollAccount").addEquals("e.userAccount", new Object[]{user});
        PollAccount result = (PollAccount)this.findByQuery(query);
        return result;
    }

    public boolean existsByPollVoteAccountId(String pollId, String accountId) throws TopiaException {
        Preconditions.checkNotNull((Object)pollId);
        Preconditions.checkNotNull((Object)accountId);
        TopiaQuery query = this.createQuery("e").addFrom(Poll.class, "p").addFrom(Vote.class, "v").addEquals("p.pollId", new Object[]{pollId}).addInElements("v", "p.vote").addWhere("e = v.pollAccount").addEquals("e.accountId", new Object[]{accountId});
        boolean result = this.existByQuery(query);
        return result;
    }
}

