package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class VoteAbstract extends TopiaEntityAbstract implements Vote {

    /**
     * Nom de l'attribut en BD : weight
     */
    protected double weight;

    /**
     * Nom de l'attribut en BD : comment
     */
    protected String comment;

    /**
     * Nom de l'attribut en BD : anonymous
     */
    protected boolean anonymous;

    /**
     * Nom de l'attribut en BD : choice
     */
    protected List<VoteToChoice> choiceVoteToChoice;

    /**
     * Nom de l'attribut en BD : poll
     */
    protected Poll poll;

    /**
     * Nom de l'attribut en BD : pollAccount
     */
    protected PollAccount pollAccount;

    /**
     * Nom de l'attribut en BD : votingList
     */
    protected VotingList votingList;

    private static final long serialVersionUID = 7089057665631479394L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_WEIGHT, double.class, weight);
        visitor.visit(this, PROPERTY_COMMENT, String.class, comment);
        visitor.visit(this, PROPERTY_ANONYMOUS, boolean.class, anonymous);
        visitor.visit(this, PROPERTY_CHOICE_VOTE_TO_CHOICE, List.class, VoteToChoice.class, choiceVoteToChoice);
        visitor.visit(this, PROPERTY_POLL, Poll.class, poll);
        visitor.visit(this, PROPERTY_POLL_ACCOUNT, PollAccount.class, pollAccount);
        visitor.visit(this, PROPERTY_VOTING_LIST, VotingList.class, votingList);
        visitor.end(this);
    }

    @Override
    public void setWeight(double weight) {
        double oldValue = this.weight;
        fireOnPreWrite(PROPERTY_WEIGHT, oldValue, weight);
        this.weight = weight;
        fireOnPostWrite(PROPERTY_WEIGHT, oldValue, weight);
    }

    @Override
    public double getWeight() {
        fireOnPreRead(PROPERTY_WEIGHT, weight);
        double result = this.weight;
        fireOnPostRead(PROPERTY_WEIGHT, weight);
        return result;
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.comment;
        fireOnPreWrite(PROPERTY_COMMENT, oldValue, comment);
        this.comment = comment;
        fireOnPostWrite(PROPERTY_COMMENT, oldValue, comment);
    }

    @Override
    public String getComment() {
        fireOnPreRead(PROPERTY_COMMENT, comment);
        String result = this.comment;
        fireOnPostRead(PROPERTY_COMMENT, comment);
        return result;
    }

    @Override
    public void setAnonymous(boolean anonymous) {
        boolean oldValue = this.anonymous;
        fireOnPreWrite(PROPERTY_ANONYMOUS, oldValue, anonymous);
        this.anonymous = anonymous;
        fireOnPostWrite(PROPERTY_ANONYMOUS, oldValue, anonymous);
    }

    @Override
    public boolean isAnonymous() {
        fireOnPreRead(PROPERTY_ANONYMOUS, anonymous);
        boolean result = this.anonymous;
        fireOnPostRead(PROPERTY_ANONYMOUS, anonymous);
        return result;
    }

    @Override
    public void addChoiceVoteToChoice(VoteToChoice choiceVoteToChoice) {
        fireOnPreWrite(PROPERTY_CHOICE_VOTE_TO_CHOICE, null, choiceVoteToChoice);
        if (this.choiceVoteToChoice == null) {
            this.choiceVoteToChoice = new ArrayList<VoteToChoice>();
        }

        this.choiceVoteToChoice.add(choiceVoteToChoice);
        fireOnPostWrite(PROPERTY_CHOICE_VOTE_TO_CHOICE, this.choiceVoteToChoice.size(), null, choiceVoteToChoice);
    }

    @Override
    public void addAllChoiceVoteToChoice(List<VoteToChoice> choiceVoteToChoice) {
        if (choiceVoteToChoice == null) {
            return;
        }
        for (VoteToChoice item : choiceVoteToChoice) {
            addChoiceVoteToChoice(item);
        }
    }

    @Override
    public void setChoiceVoteToChoice(List<VoteToChoice> choiceVoteToChoice) {
        // Copy elements to keep data for fire with new reference
        List<VoteToChoice> oldValue = this.choiceVoteToChoice != null ? new ArrayList<VoteToChoice>(this.choiceVoteToChoice) : null;
        fireOnPreWrite(PROPERTY_CHOICE_VOTE_TO_CHOICE, oldValue, choiceVoteToChoice);
        this.choiceVoteToChoice = choiceVoteToChoice;
        fireOnPostWrite(PROPERTY_CHOICE_VOTE_TO_CHOICE, oldValue, choiceVoteToChoice);
    }

    @Override
    public void removeChoiceVoteToChoice(VoteToChoice choiceVoteToChoice) {
        fireOnPreWrite(PROPERTY_CHOICE_VOTE_TO_CHOICE, choiceVoteToChoice, null);
        if (this.choiceVoteToChoice == null || !this.choiceVoteToChoice.remove(choiceVoteToChoice)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_CHOICE_VOTE_TO_CHOICE, this.choiceVoteToChoice.size() + 1, choiceVoteToChoice, null);
    }

    @Override
    public void clearChoiceVoteToChoice() {
        if (this.choiceVoteToChoice == null) {
            return;
        }
        for (VoteToChoice item : this.choiceVoteToChoice) {
        }
        List<VoteToChoice> oldValue = new ArrayList<VoteToChoice>(this.choiceVoteToChoice);
        fireOnPreWrite(PROPERTY_CHOICE_VOTE_TO_CHOICE, oldValue, this.choiceVoteToChoice);
        this.choiceVoteToChoice.clear();
        fireOnPostWrite(PROPERTY_CHOICE_VOTE_TO_CHOICE, oldValue, this.choiceVoteToChoice);
    }

    @Override
    public List<VoteToChoice> getChoiceVoteToChoice() {
        return choiceVoteToChoice;
    }

    @Override
    public VoteToChoice getChoiceVoteToChoiceByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(choiceVoteToChoice, topiaId);
    }

    @Override
    public VoteToChoice getChoiceVoteToChoice(Choice choice) {
        if (choice == null || this.choiceVoteToChoice == null) {
            return null;
        }
        for (VoteToChoice item : this.choiceVoteToChoice) {
            if (choice.equals(item.getChoice())) {
                return item;
            }
        }
        return null;
    }

    @Override
    public int sizeChoiceVoteToChoice() {
        if (choiceVoteToChoice == null) {
            return 0;
        }
        return choiceVoteToChoice.size();
    }

    @Override
    public boolean isChoiceVoteToChoiceEmpty() {
        int size = sizeChoiceVoteToChoice();
        return size == 0;
    }

    @Override
    public void setPoll(Poll poll) {
        Poll oldValue = this.poll;
        fireOnPreWrite(PROPERTY_POLL, oldValue, poll);
        this.poll = poll;
        fireOnPostWrite(PROPERTY_POLL, oldValue, poll);
    }

    @Override
    public Poll getPoll() {
        fireOnPreRead(PROPERTY_POLL, poll);
        Poll result = this.poll;
        fireOnPostRead(PROPERTY_POLL, poll);
        return result;
    }

    @Override
    public void setPollAccount(PollAccount pollAccount) {
        PollAccount oldValue = this.pollAccount;
        fireOnPreWrite(PROPERTY_POLL_ACCOUNT, oldValue, pollAccount);
        this.pollAccount = pollAccount;
        fireOnPostWrite(PROPERTY_POLL_ACCOUNT, oldValue, pollAccount);
    }

    @Override
    public PollAccount getPollAccount() {
        fireOnPreRead(PROPERTY_POLL_ACCOUNT, pollAccount);
        PollAccount result = this.pollAccount;
        fireOnPostRead(PROPERTY_POLL_ACCOUNT, pollAccount);
        return result;
    }

    @Override
    public void setVotingList(VotingList votingList) {
        VotingList oldValue = this.votingList;
        fireOnPreWrite(PROPERTY_VOTING_LIST, oldValue, votingList);
        this.votingList = votingList;
        fireOnPostWrite(PROPERTY_VOTING_LIST, oldValue, votingList);
    }

    @Override
    public VotingList getVotingList() {
        fireOnPreRead(PROPERTY_VOTING_LIST, votingList);
        VotingList result = this.votingList;
        fireOnPostRead(PROPERTY_VOTING_LIST, votingList);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        {
            org.nuiton.topia.persistence.TopiaDAO<VoteToChoice> dao = ((TopiaContextImplementor) getTopiaContext()).getDAO(VoteToChoice.class);
            List<VoteToChoice> findAllByProperties = dao.findAllByProperties("vote", this);
            if (findAllByProperties != null) {
                tmp.addAll(findAllByProperties);
            }
        }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

} //VoteAbstract
