/*
 * #%L
 * Pollen :: Persistence
 * 
 * $Id: PollenApplicationConfigProvider.java 3341 2012-05-02 08:24:42Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3/pollen-persistence/src/main/java/org/chorem/pollen/PollenApplicationConfigProvider.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen;

import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.ApplicationConfigProvider;

import java.util.Locale;

import static org.nuiton.i18n.I18n.l_;

/**
 * Application config provider (for site generation).
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3.1
 */
public class PollenApplicationConfigProvider implements ApplicationConfigProvider {

    @Override
    public String getName() {
        return "pollen";
    }

    @Override
    public String getDescription(Locale locale) {
        return l_(locale, "pollen.application.config");
    }

    @Override
    public ApplicationConfig.OptionDef[] getOptions() {
        return PollenConfigurationOption.values();
    }

    @Override
    public ApplicationConfig.ActionDef[] getActions() {
        return new ApplicationConfig.ActionDef[0];
    }
}
