/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.persistence;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.PersonListDAOAbstract;
import org.chorem.pollen.business.persistence.UserAccount;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaQuery;
import org.nuiton.topia.persistence.TopiaFilterPagerUtil;

public class PersonListDAOImpl<E extends PersonList>
extends PersonListDAOAbstract<E> {
    public List<E> getFavoriteLists(UserAccount user, TopiaFilterPagerUtil.FilterPagerBean pager) throws TopiaException {
        Preconditions.checkNotNull((Object)user);
        TopiaQuery countQuery = this.createQuery("e");
        countQuery.addWhere("e.owner", TopiaQuery.Op.EQ, (Object)user);
        long records = this.countByQuery(countQuery);
        pager.setRecords((int)records);
        TopiaQuery query = TopiaFilterPagerUtil.addPagerToQuery((TopiaQuery)countQuery, (TopiaFilterPagerUtil.FilterPagerBean)pager);
        List result = this.findAllByQuery(query);
        return result;
    }

    public List<E> getFavoriteLists(UserAccount user) throws TopiaException {
        Preconditions.checkNotNull((Object)user);
        TopiaQuery query = this.createQuery("e");
        query.addWhere("e.owner", TopiaQuery.Op.EQ, (Object)user);
        List result = this.findAllByQuery(query);
        return result;
    }

    public boolean isPersonListExist(UserAccount user, String name) throws TopiaException {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)name));
        TopiaQuery query = this.createQuery("e");
        query.addWhere("e.owner", TopiaQuery.Op.EQ, (Object)user);
        query.addWhere("e.name", TopiaQuery.Op.EQ, (Object)name);
        boolean exist = this.existByQuery(query);
        return exist;
    }
}

