package org.chorem.lima.ui.vatchart;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class VatChartView extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_SELECTED_ROW = "selectedRow";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_REMOVE_BUTTON_ENABLED = "removeButton.enabled";
    public static final String BINDING_UPDATE_BUTTON_ENABLED = "updateButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Uz28TRxR+MXV+BwgJJFVpRCFIcGCM2kOFUrU0aVISOaFiLYTwoR17h3jQeGY7+zZZhKj6J/An0HsvlXrrqeqh5x56qfovVFUPvSLe7DreXXtDjIQPY3vee9/73nvzvh//gWpo4YPHPI6ZjTTKrmA7nz94cLf1WLTxCxG2rQzQWEg/YxWoNGHG79+HCFeadRde64XXNkw3MFroXPRaHaZDfKJE2BECEd4vRrTDsOb1zWtxENkj1D6pMtQX//1bee5//0MFIA6I3SyVcumkqKySd+pQkT7COcp0wGuK632iYaXeJ75z7m5D8TDc413xLXwHE3UYD7glMITLo5ecYCTxcYAwubrzFddC3US4Zuw+a3eMFV2mZJezSLIDju0Ot8juc9xwP+5LcRgESfw4wkSHa18Ji1AbNfhOGpFhzIRC0WiFf88cIsy7Mpkrna0bowTXuWxINy3CgUXnFbPwkHrDdhp0vc6t85rqOy9x36e8HnIUXerErjlIvhEWCsHrEaLRLuhcP3Y2CnwKy0xLA3aqkuCOt0tqv8Vj7XOrO17bGqVc66nzSwVGmalY0Tz1s2GFaPCWErvGFwrhw1HaXgzK+jmFRwaEG28E5ABW+jiLq3UZopeMURqdZKGqVvJVDXsQDwvvFbaD9o5le5ctxlgTqjaia4Tl5vCq3iNTuqTLA0vqABPrywsLf/7y989bR5s5SbnPl7rmhIU2JrAmoOctXeoz6VpGKFVtlwdrTZhKn26iOhdLiHk9M5GjfOnTduHsDg87BFGd+OvX3y5888cpqGzBtDLc3+LOf5tG07HUBaP8OPjsdsJo9nCSzrOOG43uEXljOrrqI65CEVP5F0vK73NoTf3+/4L30+2jFowRpXePdc/aUH0I41IrqUUiTz3lKZWjmSAUkW8yhSnTHMgWOei9xVpyfjRUaAVhmicvZrttNMLZg9xC39CC9GLGQTVk0BAxrfZK8nTzXqzb23tGehBHLs/HSfHu1y04XidO4naKyhDaTYAUe/6pDL1Mxq5dfzbAfL7AXPgSB6kvpluXCA+jyVtsR1hGuCBOb5flQoFlKnLlPFPb63nmRfJNJ11kksrpIJPlhElq24zd2ftTyiYvySexoQWbC/NihXD16bCCMW9778v65tfeZn1zo7F9d+9ZWeZMZUdIO674E0Mc4fQnNGR+qSW1T/L56RDwmDunR0A8jQX1d366HO0qob0CgwbinIAJAAA=";
    public static final String PROPERTY$LIST_SELECTION_MODEL0 = "$ListSelectionModel0";
    private static final Log log = LogFactory.getLog(VatChartView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addVatStatementMovement;
    protected VatChartViewHandler handler;
    protected JButton importButton;
    protected JButton removeButton;
    protected Boolean selectedRow;
    protected JToolBar toolbar;
    protected VatChartTreeTable treeTable;
    protected JButton updateButton;
    protected VatChartTreeTableModel vatTreeTableModel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private VatChartView $JPanel0 = this;
    private JScrollPane $JScrollPane0;
    private ListSelectionModel $ListSelectionModel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public VatChartView(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VatChartView(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartView() {
        $initialize();
    }

    public VatChartView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartView(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public VatChartView(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartView(boolean param0) {
        super(param0);
        $initialize();
    }

    public VatChartView(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addVatStatementMovement(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addVatStatementMovement();
    }

    public void doActionPerformed__on__importButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.importVatStatementChart();
    }

    public void doActionPerformed__on__removeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeVatStatement();
    }

    public void doActionPerformed__on__updateButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.updateVatStatement();
    }

    public void doValueChanged__on__$ListSelectionModel0(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setSelectedRow(treeTable.getSelectedRow() != -1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddVatStatementMovement() {
        return addVatStatementMovement;
    }

    public VatChartViewHandler getHandler() {
        return handler;
    }

    public JButton getImportButton() {
        return importButton;
    }

    public JButton getRemoveButton() {
        return removeButton;
    }

    public Boolean getSelectedRow() {
        return selectedRow;
    }

    public JToolBar getToolbar() {
        return toolbar;
    }

    public VatChartTreeTable getTreeTable() {
        return treeTable;
    }

    public JButton getUpdateButton() {
        return updateButton;
    }

    public VatChartTreeTableModel getVatTreeTableModel() {
        return vatTreeTableModel;
    }

    public Boolean isSelectedRow() {
        return selectedRow !=null && selectedRow;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$ListSelectionModel0(ListSelectionModel $ListSelectionModel0) {
        ListSelectionModel oldValue = this.$ListSelectionModel0;
        this.$ListSelectionModel0 = $ListSelectionModel0;
        firePropertyChange(PROPERTY$LIST_SELECTION_MODEL0, oldValue, $ListSelectionModel0);
    }

    public void setHandler(VatChartViewHandler handler) {
        VatChartViewHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    public void setSelectedRow(Boolean selectedRow) {
        Boolean oldValue = this.selectedRow;
        this.selectedRow = selectedRow;
        firePropertyChange(PROPERTY_SELECTED_ROW, oldValue, selectedRow);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(addVatStatementMovement);
        toolbar.add(updateButton);
        toolbar.add(removeButton);
        toolbar.add(importButton);
    }

    protected void createAddVatStatementMovement() {
        $objectMap.put("addVatStatementMovement", addVatStatementMovement = new JButton());
        
        addVatStatementMovement.setName("addVatStatementMovement");
        addVatStatementMovement.setToolTipText(t("lima.vatStatement.movement.add"));
        addVatStatementMovement.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addVatStatementMovement"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new VatChartViewHandler(this));
    }

    protected void createImportButton() {
        $objectMap.put("importButton", importButton = new JButton());
        
        importButton.setName("importButton");
        importButton.setToolTipText(t("lima.importExport.import"));
        importButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__importButton"));
    }

    protected void createRemoveButton() {
        $objectMap.put("removeButton", removeButton = new JButton());
        
        removeButton.setName("removeButton");
        removeButton.setToolTipText(t("lima.remove.shortcut"));
        removeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeButton"));
    }

    protected void createSelectedRow() {
        $objectMap.put("selectedRow", selectedRow = false);
    }

    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new JToolBar());
        
        toolbar.setName("toolbar");
        toolbar.setFloatable(false);
    }

    protected void createTreeTable() {
        $objectMap.put("treeTable", treeTable = new VatChartTreeTable(getHandler()));
        
        treeTable.setName("treeTable");
    }

    protected void createUpdateButton() {
        $objectMap.put("updateButton", updateButton = new JButton());
        
        updateButton.setName("updateButton");
        updateButton.setToolTipText(t("lima.update.shortcut"));
        updateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__updateButton"));
    }

    protected void createVatTreeTableModel() {
        $objectMap.put("vatTreeTableModel", vatTreeTableModel = new VatChartTreeTableModel());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(toolbar, BorderLayout.PAGE_START);
        add($JScrollPane0);
        addChildrenToToolbar();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(treeTable);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 7 property setters
        treeTable.setTreeTableModel(getVatTreeTableModel());
        addVatStatementMovement.setIcon(SwingUtil.createActionIcon("vatStatement-new"));
        updateButton.setIcon(SwingUtil.createActionIcon("vatStatement-edit"));
        removeButton.setIcon(SwingUtil.createActionIcon("vatStatement-remove"));
        importButton.setIcon(SwingUtil.createActionIcon("vatStatement-import"));
        treeTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createHandler();
        createSelectedRow();
        createToolbar();
        createAddVatStatementMovement();
        createUpdateButton();
        createRemoveButton();
        createImportButton();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createVatTreeTableModel();
        createTreeTable();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = getTreeTable().getSelectionModel());
        
        $ListSelectionModel0.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__$ListSelectionModel0"));
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_UPDATE_BUTTON_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                updateButton.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_BUTTON_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                removeButton.setEnabled(isSelectedRow());
            }
        });
    }

}