package org.chorem.lima.ui.vatchart;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.VatStatement;
import org.chorem.lima.entity.VatStatementImpl;
import static org.nuiton.i18n.I18n.t;

public class VatChartMovementForm extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ADD_STATE = "addState";
    public static final String PROPERTY_VAT_STATEMENT = "vatStatement";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ACCOUNTS_TEXT_FIELD_TEXT = "accountsTextField.text";
    public static final String BINDING_BOX_NAME_TEXT_FIELD_TEXT = "boxNameTextField.text";
    public static final String BINDING_LABEL_TEXT_FIELD_TEXT = "labelTextField.text";
    public static final String BINDING_MASTER_TEXT_FIELD_TEXT = "masterTextField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1WTW8TMRB1A2lpS4FSKC1fKh8HuGwKB4TUCkqLIkApSLRCiFxwdk2zrXe92LPtVgjET+AnwJ0LEjdOiANnDlwQfwEhDlwRY2ezySYObA5W5Jl5b2bsed63P0hZSXJmkyaJI+MQ/IA5d248fHivsclcuMmUK/0IhCSt31CJlOpk3Mv2FZBz9ZoOr6ThlRURRCJkYVf0Qo2MKdjlTDUZAyCn8hGuUpW1zLyQRLFso2ZJ2VBf//pZeuW9fFMiJIkwu0ksZe5/UZ1K9tZIyfeAHEambVrhNNzANKQfbmC+E3pvhVOl7tKAPSUvyEiNDEdUIhiQs8VLNhgmPomAHHlAYaVJJayKbRZgRFXIAMi8kBuO2xSSBQ73A+rEvrNNwdWeji0kigzmMJD96LcGFIwJT6MXCXd92NUgmVcneB/1PLMNZFIX7OgmOMtCcEbDjtvI+XXa4GweyEyuvWoHm+UYm/YczQLGOG0wXtML9lcjJ6nzHbOp3Q5n3geM9zpLoOozjicynYvIDPmosfM3hRvrejCv2e4IwACnbezqVEMk+jCzDI7lAQ+l9hzf8UGkl/TOqQ76BHVdgX1Rg+An2w7F8C/34I8HVAGTg9APtsz/wh52aejqA5nKtXc5BhBh3rUktvS/+XRXkhO5c8eBdToD25mooTopyxi38aLU+2f8Pppa0z3TM90a0Fj/TE99/fD9fbU90hPIfdTq2qVIOGqRFBGT4Gvqg615jsHnlVUaLdTJqGIc5czI1UlLYmupGZNDvtYk6HDnFlVNhCiPfPv4afrxlz2kVMW7LahXpdr/NhmFpsQuCO4l0fUlk9H+nX24HtK5ASnj8HFs0XEzi92j6gTpOCfYj5OWfmRJNUY//55ae7fU7skQ5jg70L3Tl/IjMuyH3A+ZEbpUw6zCNh4pFnuio1U29SID5CtKL+lVsy7a2rBXjySQY/1dMKOfxDpyydSm/y2TnIQUJzj9bINBt9RduOjgjkG5cPG5jadHfIpzzfYXkwqIjSYnPsVJ5uwFLbfABpTUJ2TF+Sz3tC1bNqa86BWnOWMv60aKNqCufgUtzjhjGUCjmDaibq39H0Upo7hiL2rVYA2+lPgKM88H/YiiXjyhXFkvUK/AFy993JTeEn8bcvouFAccMYBiywaGL0cBoKMee0JjDitcKHYPlZuCL0IcxkWPAp1r+KGHb9O1PoIhvY4VICgHwqP622OxpYBzFPDLrhED+wfoX8DIeZMOCwAA";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    public static final String PROPERTY$DOCUMENT1 = "$Document1";
    public static final String PROPERTY$DOCUMENT2 = "$Document2";
    private static final Log log = LogFactory.getLog(VatChartMovementForm.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected VatChartMovementForm VatChartMovementForm = this;
    protected JLabel accountsLabel;
    protected JTextField accountsTextField;
    protected Boolean addState;
    protected JLabel boxNameLabel;
    protected JTextField boxNameTextField;
    protected JButton cancel;
    protected JLabel labelLabel;
    protected JTextField labelTextField;
    protected JLabel masterLabel;
    protected JTextField masterTextField;
    protected JButton ok;
    protected VatStatement vatStatement;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private Document $Document0;
    private Document $Document1;
    private Document $Document2;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
        
        protected void performCancel() {
            setVatStatement(null);
            dispose();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public VatChartMovementForm(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartMovementForm(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartMovementForm(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartMovementForm(Dialog param0) {
        super(param0);
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartMovementForm() {
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartMovementForm(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartMovementForm(Frame param0) {
        super(param0);
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartMovementForm(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartMovementForm(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartMovementForm(Window param0) {
        super(param0);
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartMovementForm(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartMovementForm(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartMovementForm(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartMovementForm(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartMovementForm(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartMovementForm(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doInsertUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getVatStatement().setLabel(getLabelTextField().getText());
    }

    public void doInsertUpdate__on__$Document1(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getVatStatement().setBoxName(getBoxNameTextField().getText());
    }

    public void doInsertUpdate__on__$Document2(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getVatStatement().setAccounts(getAccountsTextField().getText());
    }

    public void doRemoveUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getVatStatement().setLabel(getLabelTextField().getText());
    }

    public void doRemoveUpdate__on__$Document1(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getVatStatement().setBoxName(getBoxNameTextField().getText());
    }

    public void doRemoveUpdate__on__$Document2(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getVatStatement().setAccounts(getAccountsTextField().getText());
    }

    public void doWindowClosing__on__VatChartMovementForm(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JLabel getAccountsLabel() {
        return accountsLabel;
    }

    public JTextField getAccountsTextField() {
        return accountsTextField;
    }

    public Boolean getAddState() {
        return addState;
    }

    public JLabel getBoxNameLabel() {
        return boxNameLabel;
    }

    public JTextField getBoxNameTextField() {
        return boxNameTextField;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JLabel getLabelLabel() {
        return labelLabel;
    }

    public JTextField getLabelTextField() {
        return labelTextField;
    }

    public JLabel getMasterLabel() {
        return masterLabel;
    }

    public JTextField getMasterTextField() {
        return masterTextField;
    }

    public JButton getOk() {
        return ok;
    }

    public VatStatement getVatStatement() {
        return vatStatement;
    }

    public Boolean isAddState() {
        return addState !=null && addState;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$Document0(Document $Document0) {
        Document oldValue = this.$Document0;
        this.$Document0 = $Document0;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, $Document0);
    }

    public void set$Document1(Document $Document1) {
        Document oldValue = this.$Document1;
        this.$Document1 = $Document1;
        firePropertyChange(PROPERTY$DOCUMENT1, oldValue, $Document1);
    }

    public void set$Document2(Document $Document2) {
        Document oldValue = this.$Document2;
        this.$Document2 = $Document2;
        firePropertyChange(PROPERTY$DOCUMENT2, oldValue, $Document2);
    }

    public void setAddState(Boolean addState) {
        Boolean oldValue = this.addState;
        this.addState = addState;
        firePropertyChange(PROPERTY_ADD_STATE, oldValue, addState);
    }

    public void setVatStatement(VatStatement vatStatement) {
        VatStatement oldValue = this.vatStatement;
        this.vatStatement = vatStatement;
        firePropertyChange(PROPERTY_VAT_STATEMENT, oldValue, vatStatement);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Document get$Document0() {
        return $Document0;
    }

    protected Document get$Document1() {
        return $Document1;
    }

    protected Document get$Document2() {
        return $Document2;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToVatChartMovementForm() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0);
    }

    protected void createAccountsLabel() {
        $objectMap.put("accountsLabel", accountsLabel = new JLabel());
        
        accountsLabel.setName("accountsLabel");
        accountsLabel.setText(t("lima.vatStatement.accounts"));
    }

    protected void createAccountsTextField() {
        $objectMap.put("accountsTextField", accountsTextField = new JTextField());
        
        accountsTextField.setName("accountsTextField");
        accountsTextField.setColumns(15);
    }

    protected void createAddState() {
        $objectMap.put("addState", addState = true);
    }

    protected void createBoxNameLabel() {
        $objectMap.put("boxNameLabel", boxNameLabel = new JLabel());
        
        boxNameLabel.setName("boxNameLabel");
        boxNameLabel.setText(t("lima.vatStatement.boxName"));
    }

    protected void createBoxNameTextField() {
        $objectMap.put("boxNameTextField", boxNameTextField = new JTextField());
        
        boxNameTextField.setName("boxNameTextField");
        boxNameTextField.setColumns(15);
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("lima.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createLabelLabel() {
        $objectMap.put("labelLabel", labelLabel = new JLabel());
        
        labelLabel.setName("labelLabel");
        labelLabel.setText(t("lima.vatStatement.label"));
    }

    protected void createLabelTextField() {
        $objectMap.put("labelTextField", labelTextField = new JTextField());
        
        labelTextField.setName("labelTextField");
        labelTextField.setColumns(15);
    }

    protected void createMasterLabel() {
        $objectMap.put("masterLabel", masterLabel = new JLabel());
        
        masterLabel.setName("masterLabel");
        masterLabel.setText(t("lima.vatStatement.master"));
    }

    protected void createMasterTextField() {
        $objectMap.put("masterTextField", masterTextField = new JTextField());
        
        masterTextField.setName("masterTextField");
        masterTextField.setColumns(15);
        masterTextField.setEditable(false);
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(t("lima.ok"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    protected void createVatStatement() {
        $objectMap.put("vatStatement", vatStatement = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToVatChartMovementForm();
        // inline complete setup of $Table0
        $Table0.add(labelLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(labelTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(boxNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(boxNameTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(accountsLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(accountsTextField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(masterLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(masterTextField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cancel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(ok, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        // late initializer
        VatChartMovementForm.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("VatChartMovementForm", VatChartMovementForm);
        createVatStatement();
        createAddState();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createLabelLabel();
        createLabelTextField();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = getLabelTextField().getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        createBoxNameLabel();
        createBoxNameTextField();
        // inline creation of $Document1
        $objectMap.put("$Document1", $Document1 = getBoxNameTextField().getDocument());
        
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document1"));
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document1"));
        createAccountsLabel();
        createAccountsTextField();
        // inline creation of $Document2
        $objectMap.put("$Document2", $Document2 = getAccountsTextField().getDocument());
        
        $Document2.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document2"));
        $Document2.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document2"));
        createMasterLabel();
        createMasterTextField();
        createCancel();
        createOk();
        // inline creation of VatChartMovementForm
        setName("VatChartMovementForm");
        setModal(true);
        setTitle(t("lima.vatStatement.movement"));
        VatChartMovementForm.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__VatChartMovementForm"));
        
        getRootPane().setDefaultButton(ok);// registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LABEL_TEXT_FIELD_TEXT, true ,"vatStatement") {
        
            @Override
            public void processDataBinding() {
                if (getVatStatement() != null) {
                    SwingUtil.setText(labelTextField, getVatStatement().getLabel());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BOX_NAME_TEXT_FIELD_TEXT, true ,"vatStatement") {
        
            @Override
            public void processDataBinding() {
                if (getVatStatement() != null) {
                    SwingUtil.setText(boxNameTextField, getVatStatement().getBoxName());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ACCOUNTS_TEXT_FIELD_TEXT, true ,"vatStatement") {
        
            @Override
            public void processDataBinding() {
                if (getVatStatement() != null) {
                    SwingUtil.setText(accountsTextField, getVatStatement().getAccounts());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MASTER_TEXT_FIELD_TEXT, true ,"vatStatement") {
        
            @Override
            public void processDataBinding() {
                if (getVatStatement() != null && getVatStatement().getMasterVatStatement() != null) {
                    SwingUtil.setText(masterTextField, getVatStatement().getMasterVatStatement().getLabel());
                }
            }
        });
    }

}