package org.chorem.lima.ui.opening;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class CreateIdentityPanel extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1XS2/TQBDeBtqSPmihpWlFkQoU1ArJQZU4FfEKVG0VHqIIVeTCJl6aRY5t1mswIBA/gZ8Ady5I3DghDpw5cEH8BYQ4cEXMbhzHm+wag5qDlXhnvm9mdvebyZvvaDBg6Oh9HEUWC11OW8TavLi9fb1+nzT4ZRI0GPW5x1D7M1BAhRoatZP3AUfHa1XhXo7dyxWv5XsucVPeq1U0EvDHDgmahHCOjqgejSAobyXLq5Efsg5qEpQO9dXPH4WX9ovXBYQiH6Kbg1QW/ubVzWRvFRWozdFBYHqIyw52dyAMRt0diHdcvKs4OAiu4RZ5gJ6j4Soa8jEDMI6O5U9ZYkj/yOdo3+LmDewS5zRHlsd2rEbTY6RlObSFrZBank9c4LcqjGBONmyApPyx9PB9iTLE0XATu7ZDGEdn/g1ive2XQlq8hesOgWBmlbIFjwSCXBOWxcSh6EIxqrhOHCibqFAU227Kl8JqIjEeF8a3SMTXKHGgzjOKQ7KgOk12zhb13ARzWrWZTtkoMCXVbgzbNiNBYMKZjNezMMZjmxUTyIGOQWYkT6hf8WxijCRez8KAoyPdT2v8xxuwx1nOU/UwoC6EeS1s1QkzxVFSzbIQ9z/EPBvsYGKRhVNqiAtC79EGFvuZVaXD/aZZyJN+Ey5ldozTKZssrBHSwtQxoeyXq1p/hg4rVwu0zupqXVeMBmpokIXwGu5irV8eb8JSWxhne4RRAMrV3zNTX95/e7fWUcMScB/SmqbEHFTKZyAZjFNBPdGWwpBTp3wV+6s1VAyIA51AKv28JrCteBmCA74Dwt0S7tY6DpoAMTj89cPHmbuf96DCGhpxPGyvYWG/gYq8Cfem6Tl25J+/ICMae7QPnpMiNo72cqgnnCIpbDTWMUtoSgRlmNeUIYmlXvz0a2rr7YVOKQYgtDmjebccg3fQEHUduAGyNcSqr20Fo35AQtvrqrtO71FaMf1Yd6/I50ZGykefxgpv7RDeUfClZfFLRLC0/CwKBcZVmZr4dh31ym1+tjm1wClt1bH06XN+oiVzWpe7oIbstJqfn/uQmmSs2ToipWnkJ1g0J3exDWhIrK8J5eec0Sa1oj0cShvLT3Hir2mtGPLq74v/vVtxc9TuVrqx7spu3WkDmnart1Hn5+wRMtGxdQxFsbB7glGR3/SCoQwN+dnm1UTUkUFHpBs+8tOdMid3ScE1pGmaafJHUFITTsYaHVvPWJSf5KQ5zdsdSEOGmkErP+9Cz7HsG7G0NTUMbflpyxlHtg/bkHfWPPjf/S81EGoFoHeo3JX+d6MLaup/ukE1P/eUmqScV3U0qTk3P/gxc2JXBJwhpZ6p+R+U9Gx7SFvAHP6u10NOzvXhD4jnMmD+AQfhjKrjEAAA";
    private static final Log log = LogFactory.getLog(CreateIdentityPanel.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel address2Label;
    protected JTextField address2TextField;
    protected JLabel addressLabel;
    protected JTextField addressTextField;
    protected JLabel businessNumberLabel;
    protected JTextField businessNumberTextField;
    protected JTextField cityTextField;
    protected JLabel classificationCodeLabel;
    protected JTextField classificationCodeTextField;
    protected JLabel descriptionLabel;
    protected JTextField descriptionTextField;
    protected JLabel emailLabel;
    protected JTextField emailTextField;
    protected CreateIdentityPanelHandler handler;
    protected JLabel nameLabel;
    protected JTextField nameTextField;
    protected JLabel phoneNumberLabel;
    protected JTextField phoneNumberTextField;
    protected JLabel vatNumberLabel;
    protected JTextField vatNumberTextField;
    protected JLabel zipCodeLabel;
    protected JTextField zipCodeTextField;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private CreateIdentityPanel $JPanel0 = this;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CreateIdentityPanel(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CreateIdentityPanel(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateIdentityPanel() {
        $initialize();
    }

    public CreateIdentityPanel(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateIdentityPanel(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CreateIdentityPanel(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateIdentityPanel(boolean param0) {
        super(param0);
        $initialize();
    }

    public CreateIdentityPanel(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JLabel getAddress2Label() {
        return address2Label;
    }

    public JTextField getAddress2TextField() {
        return address2TextField;
    }

    public JLabel getAddressLabel() {
        return addressLabel;
    }

    public JTextField getAddressTextField() {
        return addressTextField;
    }

    public JLabel getBusinessNumberLabel() {
        return businessNumberLabel;
    }

    public JTextField getBusinessNumberTextField() {
        return businessNumberTextField;
    }

    public JTextField getCityTextField() {
        return cityTextField;
    }

    public JLabel getClassificationCodeLabel() {
        return classificationCodeLabel;
    }

    public JTextField getClassificationCodeTextField() {
        return classificationCodeTextField;
    }

    public JLabel getDescriptionLabel() {
        return descriptionLabel;
    }

    public JTextField getDescriptionTextField() {
        return descriptionTextField;
    }

    public JLabel getEmailLabel() {
        return emailLabel;
    }

    public JTextField getEmailTextField() {
        return emailTextField;
    }

    public CreateIdentityPanelHandler getHandler() {
        return handler;
    }

    public JLabel getNameLabel() {
        return nameLabel;
    }

    public JTextField getNameTextField() {
        return nameTextField;
    }

    public JLabel getPhoneNumberLabel() {
        return phoneNumberLabel;
    }

    public JTextField getPhoneNumberTextField() {
        return phoneNumberTextField;
    }

    public JLabel getVatNumberLabel() {
        return vatNumberLabel;
    }

    public JTextField getVatNumberTextField() {
        return vatNumberTextField;
    }

    public JLabel getZipCodeLabel() {
        return zipCodeLabel;
    }

    public JTextField getZipCodeTextField() {
        return zipCodeTextField;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setHandler(CreateIdentityPanelHandler handler) {
        CreateIdentityPanelHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAddress2Label() {
        $objectMap.put("address2Label", address2Label = new JLabel());
        
        address2Label.setName("address2Label");
        address2Label.setText(t("lima.identity.address2"));
    }

    protected void createAddress2TextField() {
        $objectMap.put("address2TextField", address2TextField = new JTextField());
        
        address2TextField.setName("address2TextField");
        address2TextField.setColumns(15);
    }

    protected void createAddressLabel() {
        $objectMap.put("addressLabel", addressLabel = new JLabel());
        
        addressLabel.setName("addressLabel");
        addressLabel.setText(t("lima.identity.address"));
    }

    protected void createAddressTextField() {
        $objectMap.put("addressTextField", addressTextField = new JTextField());
        
        addressTextField.setName("addressTextField");
        addressTextField.setColumns(15);
    }

    protected void createBusinessNumberLabel() {
        $objectMap.put("businessNumberLabel", businessNumberLabel = new JLabel());
        
        businessNumberLabel.setName("businessNumberLabel");
        businessNumberLabel.setText(t("lima.identity.businessNumber"));
    }

    protected void createBusinessNumberTextField() {
        $objectMap.put("businessNumberTextField", businessNumberTextField = new JTextField());
        
        businessNumberTextField.setName("businessNumberTextField");
        businessNumberTextField.setColumns(15);
    }

    protected void createCityTextField() {
        $objectMap.put("cityTextField", cityTextField = new JTextField());
        
        cityTextField.setName("cityTextField");
        cityTextField.setColumns(15);
    }

    protected void createClassificationCodeLabel() {
        $objectMap.put("classificationCodeLabel", classificationCodeLabel = new JLabel());
        
        classificationCodeLabel.setName("classificationCodeLabel");
        classificationCodeLabel.setText(t("lima.identity.classificationCode"));
    }

    protected void createClassificationCodeTextField() {
        $objectMap.put("classificationCodeTextField", classificationCodeTextField = new JTextField());
        
        classificationCodeTextField.setName("classificationCodeTextField");
        classificationCodeTextField.setColumns(15);
    }

    protected void createDescriptionLabel() {
        $objectMap.put("descriptionLabel", descriptionLabel = new JLabel());
        
        descriptionLabel.setName("descriptionLabel");
        descriptionLabel.setText(t("lima.identity.description"));
    }

    protected void createDescriptionTextField() {
        $objectMap.put("descriptionTextField", descriptionTextField = new JTextField());
        
        descriptionTextField.setName("descriptionTextField");
        descriptionTextField.setColumns(15);
    }

    protected void createEmailLabel() {
        $objectMap.put("emailLabel", emailLabel = new JLabel());
        
        emailLabel.setName("emailLabel");
        emailLabel.setText(t("lima.identity.email"));
    }

    protected void createEmailTextField() {
        $objectMap.put("emailTextField", emailTextField = new JTextField());
        
        emailTextField.setName("emailTextField");
        emailTextField.setColumns(15);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new CreateIdentityPanelHandler(this));
    }

    protected void createNameLabel() {
        $objectMap.put("nameLabel", nameLabel = new JLabel());
        
        nameLabel.setName("nameLabel");
        nameLabel.setText(t("lima.identity.name"));
    }

    protected void createNameTextField() {
        $objectMap.put("nameTextField", nameTextField = new JTextField());
        
        nameTextField.setName("nameTextField");
        nameTextField.setColumns(15);
    }

    protected void createPhoneNumberLabel() {
        $objectMap.put("phoneNumberLabel", phoneNumberLabel = new JLabel());
        
        phoneNumberLabel.setName("phoneNumberLabel");
        phoneNumberLabel.setText(t("lima.identity.phoneNumber"));
    }

    protected void createPhoneNumberTextField() {
        $objectMap.put("phoneNumberTextField", phoneNumberTextField = new JTextField());
        
        phoneNumberTextField.setName("phoneNumberTextField");
        phoneNumberTextField.setColumns(15);
    }

    protected void createVatNumberLabel() {
        $objectMap.put("vatNumberLabel", vatNumberLabel = new JLabel());
        
        vatNumberLabel.setName("vatNumberLabel");
        vatNumberLabel.setText(t("lima.identity.vatNumber"));
    }

    protected void createVatNumberTextField() {
        $objectMap.put("vatNumberTextField", vatNumberTextField = new JTextField());
        
        vatNumberTextField.setName("vatNumberTextField");
        vatNumberTextField.setColumns(15);
    }

    protected void createZipCodeLabel() {
        $objectMap.put("zipCodeLabel", zipCodeLabel = new JLabel());
        
        zipCodeLabel.setName("zipCodeLabel");
        zipCodeLabel.setText(t("lima.identity.zipCode"));
    }

    protected void createZipCodeTextField() {
        $objectMap.put("zipCodeTextField", zipCodeTextField = new JTextField());
        
        zipCodeTextField.setName("zipCodeTextField");
        zipCodeTextField.setColumns(15);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add(nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(nameTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(descriptionLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(descriptionTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(addressLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(addressTextField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(address2Label, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(address2TextField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(zipCodeLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(zipCodeTextField, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel0, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cityTextField, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(businessNumberLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(businessNumberTextField, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(vatNumberLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(vatNumberTextField, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(classificationCodeLabel, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(classificationCodeTextField, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(phoneNumberLabel, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(phoneNumberTextField, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(emailLabel, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(emailTextField, new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 11 property setters
        SwingUtil.setText(nameTextField, handler.getIdentity().getName());
        
        SwingUtil.setText(descriptionTextField, handler.getIdentity().getDescription());
        
        SwingUtil.setText(addressTextField, handler.getIdentity().getAddress());
        
        SwingUtil.setText(address2TextField, handler.getIdentity().getAddress2());
        
        SwingUtil.setText(zipCodeTextField, handler.getIdentity().getZipCode());
        
        SwingUtil.setText(cityTextField, handler.getIdentity().getCity());
        
        SwingUtil.setText(businessNumberTextField, handler.getIdentity().getBusinessNumber());
        
        SwingUtil.setText(vatNumberTextField, handler.getIdentity().getVatNumber());
        
        SwingUtil.setText(classificationCodeTextField, handler.getIdentity().getClassificationCode());
        
        SwingUtil.setText(phoneNumberTextField, handler.getIdentity().getPhoneNumber());
        
        SwingUtil.setText(emailTextField, handler.getIdentity().getEmail());
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createHandler();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createNameLabel();
        createNameTextField();
        createDescriptionLabel();
        createDescriptionTextField();
        createAddressLabel();
        createAddressTextField();
        createAddress2Label();
        createAddress2TextField();
        createZipCodeLabel();
        createZipCodeTextField();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("lima.identity.city"));
        createCityTextField();
        createBusinessNumberLabel();
        createBusinessNumberTextField();
        createVatNumberLabel();
        createVatNumberTextField();
        createClassificationCodeLabel();
        createClassificationCodeTextField();
        createPhoneNumberLabel();
        createPhoneNumberTextField();
        createEmailLabel();
        createEmailTextField();
        // inline creation of $JPanel0
        setName("$JPanel0");
        
        $completeSetup();
    }

}