package org.chorem.lima.ui.financialtransactionsearch;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JToolBar.Separator;
import javax.swing.ListSelectionModel;
import javax.swing.ScrollPaneConstants;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.ui.Filter.financialTransactionCondition.FinancialTransactionConditionView;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionDefaultTable;
import static org.nuiton.i18n.I18n.t;

public class FinancialTransactionSearchView extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_FIELD_SIZE = "fieldSize";
    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_SELECTED_ROW = "selectedRow";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK2Xz28bRRTHJy5J6qSF5nfShDZtgwRC2UC4EaBtnIQkctMqa5WChWC8O7anjHeW2dnYoQLxJ/AnwJ0LEjdOiANnDlwq/gVUceCKeLO73vWux05WSg5W5Pm+9z5vdnbe1z/+jUY9gW49xZ2OIXxH0hYxDu8/efKw9pRYcod4lqCu5AKFfyMFVKiiSTv+3pPoTrWswjei8I0Sb7ncIU5P9FYZTXjylBGvSYiU6NV0hOV5G2a8vNVxfdHNGkPpsn7/z4vCd/a3PxQQ6rhAtwKtrJ4VlXTyUhkVqC3RNFQ6wRsMOw3AENRpAO9V9V2JYc87wi3yJfoGjZfRmIsFJJPo9vlbDnIE8R1Xostrh4+wQ9hbEpW5aBhWkwvSMhhtYcOnRp062LEoZlJgx8OWpNzxCBZW09jrLlWSJTNYekxJ23WDGmMSjTexYzMiJDIvssB+mDWpM+kRBkeE2Me8LdGU2i5DbaGxzTkj2EmUxTolzDbpVwT2OtDhtjR2YOMcD2r0oEsIrWFAn1WyjuG14WEYhxX4ehsLpSrG4mvYtnewJCXu2FSxSjSTitr2peSOUs/FQYtR0IEjiTjBLA5W69fT2mXQxnvyiAjK7WHyxUDuWefRzq51e1ozCZwpDAcGTsQNXdeJIp1jDurtOlKcwn5/kbfY22rtTlo3Awkfc99qEjEsnZLdtywOR3+YbEHtdPQ2gGKYVHVShmuBqFcvbyebmk6mgto1OhRwGkQlQezhKl3JdzQlxwWpC7i/NCmurB2aLqNSvffwkOdTDzleSR/uqxBjCc5YFLSQDoqXlPzdOOpWXfMKx92pt1iijzWXwh5lsPnG0Gjt9ZDKrSDe13cQHLe7adg1XbnwvqngGiMPuE2YRMcXdYklSZML5+YZDBLtn7O8tvAOqWOfySCVqljqOVZl6kkzuEFBGGBlL4B+BYALtJwacDA6jWR0JrNtpIpGhQ9fw8VU7Z+2x7AUztnFzJxVCYPV/+Zn/vzlr5/3usP1GtSe00p7vAEMPVdwF6YPVaVfCSerLynbeIDdrSoqhlMjMA4rGjAzWgY4qBdOFRVu7GOvCSlGx5//+tv8539cQoU9NME4tvew0h+gomyqF5Azu+PevRcQXWlfVuCKTU0hUMvwqY7WMfNIB9pf0bQfM9SKv/87Y/50r7sFI4C0NFCebMPoJ2iMOow6JHAYkXnQOopJ1yO+zROToLMNKBmNbnR4zeDzo75GCxJNhIfvwFIjcaEevNvrPUd13YYBCPNbZaxQt0I6YGhmg8Mdig0lMMDPdHxVpBp0rv77FGnGbl6i1QFE6zSayVm0pT60rlLHN3DC5+W8reGsp+1AlnS5lzSj1bEOcxh5cW9qcRM7kmVdTLMmwkGbqvU2eSlXNJSka2KyiHO9iLFKx6f3QnnhrmvgTkJDlEWb6UWLNDownae6CCwcGrChWJFmEFbWw+XFuqF7jxPDl0VbSL3FiU6HN8g75kVc0iCywGhm6aZ76ULJoHPW71TzYi1qdw7sapZqKr1noNBB9bvdi9gnK7DGQ/cplOiQNN46L1PXUOsvhWjRgHkvpOVrIboZzqp8CfxAKzSbbz5rEHkeC/n6G1+DxfV63ZlErz3rt2yGeXD0YXn3M3O3vFuqHDw8grii4O19QhtNaKewualjP8uYntUT+J0xhk85/ARGL78HQxOv1ig8CafxQV+5EfU5cY6Mk1xQuIZx96fSc32qLUj1P4R5JvNYEgAA";
    public static final String PROPERTY$LIST_SELECTION_MODEL0 = "$ListSelectionModel0";
    private static final Log log = LogFactory.getLog(FinancialTransactionSearchView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addAccountCondition;
    protected JButton addCreditCondition;
    protected JButton addDateCondition;
    protected JButton addDateIntervalCondition;
    protected JButton addDebitCondition;
    protected JButton addDescriptionCondition;
    protected JButton addEntryBookCondition;
    protected JButton addFinancialPeriodCondition;
    protected JButton addFiscalPeriodCondition;
    protected JButton addLetteringCondition;
    protected JButton addVoucherCondition;
    protected Dimension fieldSize;
    protected FinancialTransactionConditionView financialTransactionConditionView;
    protected FinancialTransactionDefaultTable financialTransactionSearchTable;
    protected FinancialTransactionSearchTableModel financialTransactionSearchTableModel;
    protected FinancialTransactionSearchViewHandler handler;
    protected JButton refresh;
    protected Boolean selectedRow;
    protected JToolBar toolbar;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private FinancialTransactionSearchView $JPanel0 = this;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private JSplitPane $JSplitPane0;
    private Separator $JToolBar$Separator0;
    private Separator $JToolBar$Separator1;
    private Separator $JToolBar$Separator2;
    private Separator $JToolBar$Separator3;
    private ListSelectionModel $ListSelectionModel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FinancialTransactionSearchView(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialTransactionSearchView(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialTransactionSearchView() {
        $initialize();
    }

    public FinancialTransactionSearchView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialTransactionSearchView(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public FinancialTransactionSearchView(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialTransactionSearchView(boolean param0) {
        super(param0);
        $initialize();
    }

    public FinancialTransactionSearchView(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addAccountCondition(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addAccountCondition();
    }

    public void doActionPerformed__on__addCreditCondition(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addCreditCondition();
    }

    public void doActionPerformed__on__addDateCondition(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addDateCondition();
    }

    public void doActionPerformed__on__addDateIntervalCondition(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addDateIntervalCondition();
    }

    public void doActionPerformed__on__addDebitCondition(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addDebitCondition();
    }

    public void doActionPerformed__on__addDescriptionCondition(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addDescriptionCondition();
    }

    public void doActionPerformed__on__addEntryBookCondition(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addEntryBookCondition();
    }

    public void doActionPerformed__on__addFinancialPeriodCondition(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addFinancialPeriodCondition();
    }

    public void doActionPerformed__on__addFiscalPeriodCondition(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addFiscalPeriodCondition();
    }

    public void doActionPerformed__on__addLetteringCondition(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addLetteringCondition();
    }

    public void doActionPerformed__on__addVoucherCondition(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addVoucherCondition();
    }

    public void doActionPerformed__on__refresh(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().refresh();
    }

    public void doValueChanged__on__$ListSelectionModel0(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setSelectedRow(financialTransactionSearchTable.getSelectedRow() != -1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddAccountCondition() {
        return addAccountCondition;
    }

    public JButton getAddCreditCondition() {
        return addCreditCondition;
    }

    public JButton getAddDateCondition() {
        return addDateCondition;
    }

    public JButton getAddDateIntervalCondition() {
        return addDateIntervalCondition;
    }

    public JButton getAddDebitCondition() {
        return addDebitCondition;
    }

    public JButton getAddDescriptionCondition() {
        return addDescriptionCondition;
    }

    public JButton getAddEntryBookCondition() {
        return addEntryBookCondition;
    }

    public JButton getAddFinancialPeriodCondition() {
        return addFinancialPeriodCondition;
    }

    public JButton getAddFiscalPeriodCondition() {
        return addFiscalPeriodCondition;
    }

    public JButton getAddLetteringCondition() {
        return addLetteringCondition;
    }

    public JButton getAddVoucherCondition() {
        return addVoucherCondition;
    }

    public Dimension getFieldSize() {
        return fieldSize;
    }

    public FinancialTransactionConditionView getFinancialTransactionConditionView() {
        return financialTransactionConditionView;
    }

    public FinancialTransactionDefaultTable getFinancialTransactionSearchTable() {
        return financialTransactionSearchTable;
    }

    public FinancialTransactionSearchTableModel getFinancialTransactionSearchTableModel() {
        return financialTransactionSearchTableModel;
    }

    public FinancialTransactionSearchViewHandler getHandler() {
        return handler;
    }

    public JButton getRefresh() {
        return refresh;
    }

    public Boolean getSelectedRow() {
        return selectedRow;
    }

    public JToolBar getToolbar() {
        return toolbar;
    }

    public Boolean isSelectedRow() {
        return selectedRow !=null && selectedRow;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$ListSelectionModel0(ListSelectionModel $ListSelectionModel0) {
        ListSelectionModel oldValue = this.$ListSelectionModel0;
        this.$ListSelectionModel0 = $ListSelectionModel0;
        firePropertyChange(PROPERTY$LIST_SELECTION_MODEL0, oldValue, $ListSelectionModel0);
    }

    public void setFieldSize(Dimension fieldSize) {
        Dimension oldValue = this.fieldSize;
        this.fieldSize = fieldSize;
        firePropertyChange(PROPERTY_FIELD_SIZE, oldValue, fieldSize);
    }

    public void setHandler(FinancialTransactionSearchViewHandler handler) {
        FinancialTransactionSearchViewHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    public void setSelectedRow(Boolean selectedRow) {
        Boolean oldValue = this.selectedRow;
        this.selectedRow = selectedRow;
        firePropertyChange(PROPERTY_SELECTED_ROW, oldValue, selectedRow);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    protected Separator get$JToolBar$Separator0() {
        return $JToolBar$Separator0;
    }

    protected Separator get$JToolBar$Separator1() {
        return $JToolBar$Separator1;
    }

    protected Separator get$JToolBar$Separator2() {
        return $JToolBar$Separator2;
    }

    protected Separator get$JToolBar$Separator3() {
        return $JToolBar$Separator3;
    }

    protected ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(addDateCondition);
        toolbar.add(addDateIntervalCondition);
        toolbar.add(addFinancialPeriodCondition);
        toolbar.add(addFiscalPeriodCondition);
        toolbar.add($JToolBar$Separator0);
        toolbar.add(addEntryBookCondition);
        toolbar.add($JToolBar$Separator1);
        toolbar.add(addVoucherCondition);
        toolbar.add(addAccountCondition);
        toolbar.add(addDescriptionCondition);
        toolbar.add(addLetteringCondition);
        toolbar.add($JToolBar$Separator2);
        toolbar.add(addDebitCondition);
        toolbar.add(addCreditCondition);
        toolbar.add($JToolBar$Separator3);
        toolbar.add(refresh);
    }

    protected void createAddAccountCondition() {
        $objectMap.put("addAccountCondition", addAccountCondition = new JButton());
        
        addAccountCondition.setName("addAccountCondition");
        addAccountCondition.setToolTipText(t("lima.filter.account"));
        addAccountCondition.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addAccountCondition"));
    }

    protected void createAddCreditCondition() {
        $objectMap.put("addCreditCondition", addCreditCondition = new JButton());
        
        addCreditCondition.setName("addCreditCondition");
        addCreditCondition.setToolTipText(t("lima.filter.credit"));
        addCreditCondition.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addCreditCondition"));
    }

    protected void createAddDateCondition() {
        $objectMap.put("addDateCondition", addDateCondition = new JButton());
        
        addDateCondition.setName("addDateCondition");
        addDateCondition.setToolTipText(t("lima.filter.date.one"));
        addDateCondition.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addDateCondition"));
    }

    protected void createAddDateIntervalCondition() {
        $objectMap.put("addDateIntervalCondition", addDateIntervalCondition = new JButton());
        
        addDateIntervalCondition.setName("addDateIntervalCondition");
        addDateIntervalCondition.setToolTipText(t("lima.filter.date.interval"));
        addDateIntervalCondition.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addDateIntervalCondition"));
    }

    protected void createAddDebitCondition() {
        $objectMap.put("addDebitCondition", addDebitCondition = new JButton());
        
        addDebitCondition.setName("addDebitCondition");
        addDebitCondition.setToolTipText(t("lima.filter.debit"));
        addDebitCondition.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addDebitCondition"));
    }

    protected void createAddDescriptionCondition() {
        $objectMap.put("addDescriptionCondition", addDescriptionCondition = new JButton());
        
        addDescriptionCondition.setName("addDescriptionCondition");
        addDescriptionCondition.setToolTipText(t("lima.filter.description"));
        addDescriptionCondition.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addDescriptionCondition"));
    }

    protected void createAddEntryBookCondition() {
        $objectMap.put("addEntryBookCondition", addEntryBookCondition = new JButton());
        
        addEntryBookCondition.setName("addEntryBookCondition");
        addEntryBookCondition.setToolTipText(t("lima.filter.entryBook"));
        addEntryBookCondition.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addEntryBookCondition"));
    }

    protected void createAddFinancialPeriodCondition() {
        $objectMap.put("addFinancialPeriodCondition", addFinancialPeriodCondition = new JButton());
        
        addFinancialPeriodCondition.setName("addFinancialPeriodCondition");
        addFinancialPeriodCondition.setToolTipText(t("lima.filter.financialPeriod"));
        addFinancialPeriodCondition.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addFinancialPeriodCondition"));
    }

    protected void createAddFiscalPeriodCondition() {
        $objectMap.put("addFiscalPeriodCondition", addFiscalPeriodCondition = new JButton());
        
        addFiscalPeriodCondition.setName("addFiscalPeriodCondition");
        addFiscalPeriodCondition.setToolTipText(t("lima.filter.fiscalPeriod"));
        addFiscalPeriodCondition.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addFiscalPeriodCondition"));
    }

    protected void createAddLetteringCondition() {
        $objectMap.put("addLetteringCondition", addLetteringCondition = new JButton());
        
        addLetteringCondition.setName("addLetteringCondition");
        addLetteringCondition.setToolTipText(t("lima.filter.letter"));
        addLetteringCondition.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addLetteringCondition"));
    }

    protected void createAddVoucherCondition() {
        $objectMap.put("addVoucherCondition", addVoucherCondition = new JButton());
        
        addVoucherCondition.setName("addVoucherCondition");
        addVoucherCondition.setToolTipText(t("lima.filter.voucher"));
        addVoucherCondition.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addVoucherCondition"));
    }

    protected void createFieldSize() {
        $objectMap.put("fieldSize", fieldSize = new java.awt.Dimension());
    }

    protected void createFinancialTransactionConditionView() {
        $objectMap.put("financialTransactionConditionView", financialTransactionConditionView = new FinancialTransactionConditionView());
        
        financialTransactionConditionView.setName("financialTransactionConditionView");
    }

    protected void createFinancialTransactionSearchTable() {
        $objectMap.put("financialTransactionSearchTable", financialTransactionSearchTable = new FinancialTransactionDefaultTable(handler));
        
        financialTransactionSearchTable.setName("financialTransactionSearchTable");
        financialTransactionSearchTable.setRowHeight(22);
    }

    protected void createFinancialTransactionSearchTableModel() {
        $objectMap.put("financialTransactionSearchTableModel", financialTransactionSearchTableModel = new FinancialTransactionSearchTableModel());
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new FinancialTransactionSearchViewHandler(this));
    }

    protected void createRefresh() {
        $objectMap.put("refresh", refresh = new JButton());
        
        refresh.setName("refresh");
        refresh.setToolTipText(t("lima.refresh.shortcut"));
        refresh.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__refresh"));
    }

    protected void createSelectedRow() {
        $objectMap.put("selectedRow", selectedRow = false);
    }

    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new JToolBar());
        
        toolbar.setName("toolbar");
        toolbar.setFloatable(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(toolbar, BorderLayout.PAGE_START);
        add($JSplitPane0, BorderLayout.CENTER);
        addChildrenToToolbar();
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add($JScrollPane0, JSplitPane.LEFT);
        $JSplitPane0.add($JScrollPane1, JSplitPane.RIGHT);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(financialTransactionConditionView);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(financialTransactionSearchTable);
        
        // apply 16 property setters
        $JSplitPane0.setOrientation(JSplitPane.VERTICAL_SPLIT);
        addDateCondition.setIcon(SwingUtil.createActionIcon("filter-transaction-date"));
        addDateIntervalCondition.setIcon(SwingUtil.createActionIcon("filter-transaction-date-interval"));
        addFinancialPeriodCondition.setIcon(SwingUtil.createActionIcon("filter-transaction-financialPeriod"));
        addFiscalPeriodCondition.setIcon(SwingUtil.createActionIcon("filter-transaction-fiscalPeriod"));
        addEntryBookCondition.setIcon(SwingUtil.createActionIcon("filter-transaction-entryBook"));
        addVoucherCondition.setIcon(SwingUtil.createActionIcon("filter-transaction-voucher"));
        addAccountCondition.setIcon(SwingUtil.createActionIcon("filter-transaction-account"));
        addDescriptionCondition.setIcon(SwingUtil.createActionIcon("filter-transaction-description"));
        addLetteringCondition.setIcon(SwingUtil.createActionIcon("filter-transaction-letter"));
        addDebitCondition.setIcon(SwingUtil.createActionIcon("filter-transaction-debit"));
        addCreditCondition.setIcon(SwingUtil.createActionIcon("filter-transaction-credit"));
        refresh.setIcon(SwingUtil.createActionIcon("refresh"));
        financialTransactionSearchTable.setModel(getFinancialTransactionSearchTableModel());
        financialTransactionSearchTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createHandler();
        createSelectedRow();
        createFieldSize();
        createToolbar();
        createAddDateCondition();
        createAddDateIntervalCondition();
        createAddFinancialPeriodCondition();
        createAddFiscalPeriodCondition();
        // inline creation of $JToolBar$Separator0
        $objectMap.put("$JToolBar$Separator0", $JToolBar$Separator0 = new Separator());
        
        $JToolBar$Separator0.setName("$JToolBar$Separator0");
        createAddEntryBookCondition();
        // inline creation of $JToolBar$Separator1
        $objectMap.put("$JToolBar$Separator1", $JToolBar$Separator1 = new Separator());
        
        $JToolBar$Separator1.setName("$JToolBar$Separator1");
        createAddVoucherCondition();
        createAddAccountCondition();
        createAddDescriptionCondition();
        createAddLetteringCondition();
        // inline creation of $JToolBar$Separator2
        $objectMap.put("$JToolBar$Separator2", $JToolBar$Separator2 = new Separator());
        
        $JToolBar$Separator2.setName("$JToolBar$Separator2");
        createAddDebitCondition();
        createAddCreditCondition();
        // inline creation of $JToolBar$Separator3
        $objectMap.put("$JToolBar$Separator3", $JToolBar$Separator3 = new Separator());
        
        $JToolBar$Separator3.setName("$JToolBar$Separator3");
        createRefresh();
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new JSplitPane());
        
        $JSplitPane0.setName("$JSplitPane0");
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFinancialTransactionConditionView();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createFinancialTransactionSearchTableModel();
        createFinancialTransactionSearchTable();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = getFinancialTransactionSearchTable().getSelectionModel());
        
        $ListSelectionModel0.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__$ListSelectionModel0"));
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        $completeSetup();
    }

}