package org.chorem.lima.ui.Filter.financialTransactionCondition;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListSelectionModel;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class FinancialTransactionConditionView extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVUz08TQRR+LbSlgCCiBAImgJrowa13jICYiqT+CBiD1oPT7tAOmc6sM7OyhGj8E/wT9O7FxJsn48GzBy/Gf8EYD16Nb3bbXfpDakxs0slm3nvfe+9735vX3yCjFSzskiBwlC8Ma1BnY3V7+3Zll1bNNaqrinlGKoh+qTSkyzDixvfawJlyyYYXmuGFNdnwpKDiUPRSCYa12edU1yk1Bk63R1S1LmzF5qXA81ULNS6qF+rLH9/TL9znr9IAgYfV5bCV+X5RSSeDJUgz18AJzPSEFDgRNSxDMVHDeo/ZuzVOtL5FGvQxPINcCbIeUQhmYPHvWw4xwvjAQ7J2mCCiygi/q4jQpGqYFGtSuMx+6DtEUG7gvlQ1p1qXijYczhrE8ZlTZNxQ5RwZj05HWO8xuud5YS1ZA7k6ES6nysDD/5JtPYJPEg6d3Qjbu4SMW3IDR+8h1050a53yse8Y4XyTuExe9Y2RwsB0W8Qhkw0YT+JwCh3Gkx0e1VaBcdqJ9tyjKgFAeS+2CapZAG5I5HBdSd/DHhXMtvmhpJ1E0onmUmXIKB+vsaVy9xZsoinS/3SH/i1gaP01Nfn53de3xZboBzH3qZ6uh3YWxegp6eG0mU09HineN4wXbhJvqQx5TTkufLjQcz0K22qasTjMN2HDHRvurBNdR4hM7sv7D1OPPg1AugjDXBK3SKz/DcibukIWJHcDb3klrGh0bwjP4/gfQFlEmSku4tzBQlOUDtOrnCd7cf7CUwODhga4ezOhRncigcbTdHDyBkYqyVQ6JhkgqXM9SI07q+Q//pzcerPSIjaFjc780T0hN/MAskxwJmj4njSfip7vx4inqe/K5Eno9UhAl/y95hIthOe5PizOHvw7iZi3D4m2goshO/arAF0716/YlIEsJ/sSnWHssksMma8wzC9qV7rQU/Yc7otor5ftsdIbYRoRfgP8cvXY6gYAAA==";
    private static final Log log = LogFactory.getLog(FinancialTransactionConditionView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JRadioButton allRadioButton;
    protected JPanel conditionPanel;
    protected FinancialTransactionConditionView financialTransactionConditionsPanel = this;
    protected FinancialTransactionConditionHandler handler;
    protected JRadioButton oneRadioButton;
    protected JAXXButtonGroup radioButtons;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FinancialTransactionConditionView(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialTransactionConditionView(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialTransactionConditionView() {
        $initialize();
    }

    public FinancialTransactionConditionView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialTransactionConditionView(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public FinancialTransactionConditionView(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialTransactionConditionView(boolean param0) {
        super(param0);
        $initialize();
    }

    public FinancialTransactionConditionView(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__allRadioButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setAllConditions(false);
    }

    public void doActionPerformed__on__oneRadioButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setAllConditions(true);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JRadioButton getAllRadioButton() {
        return allRadioButton;
    }

    public JPanel getConditionPanel() {
        return conditionPanel;
    }

    public FinancialTransactionConditionHandler getHandler() {
        return handler;
    }

    public JRadioButton getOneRadioButton() {
        return oneRadioButton;
    }

    public JAXXButtonGroup getRadioButtons() {
        return radioButtons;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setHandler(FinancialTransactionConditionHandler handler) {
        FinancialTransactionConditionHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAllRadioButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = radioButtons; allRadioButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(allRadioButton); }
    }

    protected void addChildrenToFinancialTransactionConditionsPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add($JPanel0, BorderLayout.NORTH);
        add(conditionPanel, BorderLayout.CENTER);
    }

    protected void addChildrenToOneRadioButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = radioButtons; oneRadioButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(oneRadioButton); }
    }

    protected void createAllRadioButton() {
        $objectMap.put("allRadioButton", allRadioButton = new JRadioButton());
        
        allRadioButton.setName("allRadioButton");
        allRadioButton.setText(t("lima.filter.condition.one"));
        allRadioButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__allRadioButton"));
    }

    protected void createConditionPanel() {
        $objectMap.put("conditionPanel", conditionPanel = new JPanel());
        
        conditionPanel.setName("conditionPanel");
        conditionPanel.setLayout(new FlowLayout(FlowLayout.LEADING, 0, 0));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new FinancialTransactionConditionHandler(this));
    }

    protected void createOneRadioButton() {
        $objectMap.put("oneRadioButton", oneRadioButton = new JRadioButton());
        
        oneRadioButton.setName("oneRadioButton");
        oneRadioButton.setText(t("lima.filter.condition.all"));
        oneRadioButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__oneRadioButton"));
    }

    protected void createRadioButtons() {
        $objectMap.put("radioButtons", radioButtons = new JAXXButtonGroup());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToFinancialTransactionConditionsPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(allRadioButton);
        $JPanel0.add(oneRadioButton);
        addChildrenToAllRadioButton();
        addChildrenToOneRadioButton();
        
        // apply 4 property setters
        allRadioButton.setSelected(!handler.isAllConditions());
        oneRadioButton.setSelected(handler.isAllConditions());
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("financialTransactionConditionsPanel", financialTransactionConditionsPanel);
        createHandler();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        createAllRadioButton();
        createOneRadioButton();
        createConditionPanel();
        createRadioButtons();
        // inline creation of financialTransactionConditionsPanel
        setName("financialTransactionConditionsPanel");
        setLayout(new BorderLayout());
        
        $completeSetup();
    }

}