package org.chorem.lima.ui.Filter.AccountCondition;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.beans.AccountCondition;
import org.chorem.lima.entity.Account;
import org.chorem.lima.ui.Filter.ConditionHandler;
import org.chorem.lima.ui.Filter.financialTransactionCondition.FinancialTransactionConditionHandler;

import java.awt.event.ItemEvent;

/**
 * @author Sylvain Bavencoff <bavencoff@codelutin.com>
 */
public class AccountConditionHandler implements ConditionHandler {

    private static final Log log = LogFactory.getLog(AccountConditionHandler.class);

    protected AccountCondition condition;

    protected AccountConditionView view;

    protected FinancialTransactionConditionHandler filterHandler;

    public AccountConditionHandler (AccountConditionView view) {
        this.view = view;
        this.condition = new AccountCondition();
    }

    public Account getAccount() {
        return condition.getAccount();
    }

    public void setAccount(Account account) {
        condition.setAccount(account);
    }

    public void accountSelected(ItemEvent event) {
        condition.setAccount((Account) event.getItem());
    }

    public void delete() {
        filterHandler.removeCondition(this);
    }

    @Override
    public AccountCondition getCondition() {
        return condition;
    }

    @Override
    public AccountConditionView getView() {
        return view;
    }

    @Override
    public void setFilterHandler(FinancialTransactionConditionHandler filterHandler) {
        this.filterHandler = filterHandler;
    }
}
