/*
 * #%L
 * Lima Swing
 * 
 * $Id: OpeningViewHandler.java 3777 2014-04-14 07:29:08Z sbavencoff $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.3/lima-swing/src/main/java/org/chorem/lima/ui/opening/OpeningViewHandler.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.opening;

import static org.nuiton.i18n.I18n.t;

import java.awt.Color;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.api.FiscalPeriodService;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.entity.FiscalPeriodImpl;
import org.chorem.lima.enums.AccountsChartEnum;
import org.chorem.lima.enums.EntryBooksChartEnum;
import org.chorem.lima.enums.FinancialStatementsChartEnum;
import org.chorem.lima.enums.ImportExportEnum;
import org.chorem.lima.enums.VatStatementsChartEnum;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.identity.IdentityHandler;
import org.chorem.lima.ui.importexport.ImportExport;

public class OpeningViewHandler {

    private static final Log log = LogFactory.getLog(OpeningViewHandler.class);

    private static Border noBorder = new EmptyBorder(0, 0, 0, 0);

    private static Color green = new Color(0x66, 0xcc, 0x00);

    protected int step;

    protected OpeningView view;

    //Panels
    private CreateAccountsPanel caPanel;

    private CreateIdentityPanel idPanel;

    private CreateEntryBookPanel ebPanel;

    private CreateFiscalPeriodPanel fsPanel;

    public OpeningViewHandler(OpeningView view) {
        this.view = view;
        caPanel = new CreateAccountsPanel();
        idPanel = new CreateIdentityPanel();
        ebPanel = new CreateEntryBookPanel();
        fsPanel = new CreateFiscalPeriodPanel();
        step = 0;
    }


    public void importSave() {
        ImportExport importExport = new ImportExport(view);
        importExport.importExport(ImportExportEnum.CSV_ALL_IMPORT, "", true);
        view.dispose();
    }

    public void next() {
        ImportExport importExport = new ImportExport(view);
        JPanel panel = view.getPanel();
        panel.removeAll();
        switch (step) {
            case 0:
                //refresh UI
                view.getIdentityIcon().setBorder(BorderFactory.createLineBorder(green, 2));
                panel.add(idPanel);
                panel.validate();
                view.repaint();
                step++;
                break;
            case 1:
                IdentityHandler identityHandler = new IdentityHandler();
                identityHandler.updateIdentity(idPanel.getIdentity());
                //refresh UI
                view.getIdentityIcon().setBorder(noBorder);
                view.getAccountsIcon().setBorder(BorderFactory.createLineBorder(green, 2));
                panel.add(caPanel);
                panel.validate();
                view.repaint();
                step++;
                break;

            case 2:
                Object value = caPanel.getButtonGroup().getSelectedValue();
                // if action confirmed
                if (value != null) {
                    AccountsChartEnum defaultAccountsChartEnum =
                            (AccountsChartEnum) value;
                    //Import accounts chart
                    switch (defaultAccountsChartEnum) {
                        case IMPORTEBP:
                            importExport.importExport(ImportExportEnum.EBP_ACCOUNTCHARTS_IMPORT,
                                                      defaultAccountsChartEnum.getFilePath(), false);
                            break;

                        default:
                            importExport.importExport(ImportExportEnum.CSV_ACCOUNTCHARTS_IMPORT,
                                                      defaultAccountsChartEnum.getFilePath(), false);
                            break;
                    }
                    //Import financialstatement
                    switch (defaultAccountsChartEnum) {
                        case SHORTENED:
                            importExport.importExport(ImportExportEnum.CSV_FINANCIALSTATEMENTS_IMPORT,
                                                      FinancialStatementsChartEnum.SHORTENED.getFilePath(), false);
                            break;
                        case DEVELOPED:
                            importExport.importExport(ImportExportEnum.CSV_FINANCIALSTATEMENTS_IMPORT,
                                                      FinancialStatementsChartEnum.DEVELOPED.getFilePath(), false);
                            break;
                        default:
                            importExport.importExport(ImportExportEnum.CSV_FINANCIALSTATEMENTS_IMPORT,
                                                      FinancialStatementsChartEnum.BASE.getFilePath(), false);
                            break;
                    }
                    //Import vatstatement
                    switch (defaultAccountsChartEnum) {
                        case SHORTENED:
                            importExport.importExport(ImportExportEnum.CSV_VAT_IMPORT,
                                                      VatStatementsChartEnum.SHORTENED.getFilePath(), false);
                            break;
                        case BASE:
                            importExport.importExport(ImportExportEnum.CSV_VAT_IMPORT,
                                                      VatStatementsChartEnum.BASE.getFilePath(), false);
                            break;
                        case DEVELOPED:
                            importExport.importExport(ImportExportEnum.CSV_VAT_IMPORT,
                                                      VatStatementsChartEnum.DEVELOPED.getFilePath(), false);
                            break;
                        default:
                            importExport.importExport(ImportExportEnum.CSV_VAT_IMPORT,
                                                      VatStatementsChartEnum.DEFAULT.getFilePath(), false);
                            break;
                    }

                }
                view.getAccountsIcon().setBorder(noBorder);
                view.getEntrybooksIcon().setBorder(BorderFactory.createLineBorder(green, 2));
                panel.add(ebPanel);
                panel.validate();
                view.repaint();
                step++;
                break;

            case 3:
                if (ebPanel.getImportEntryBook().isSelected()) {
                    importExport.importExport(ImportExportEnum.CSV_ENTRYBOOKS_IMPORT,
                                              EntryBooksChartEnum.DEFAULT.getFilePath(), false);
                }
                view.getEntrybooksIcon().setBorder(noBorder);
                view.getFiscalperiodsIcon().setBorder(BorderFactory.createLineBorder(green, 2));
                panel.add(fsPanel);
                panel.validate();
                view.getOk().setText(t("lima.ui.opening.end"));
                view.repaint();
                step++;
                break;
            case 4:
                try {
                    FiscalPeriod fiscalPeriod = new FiscalPeriodImpl();
                    fiscalPeriod.setBeginDate(fsPanel.getBeginDatePicker().getDate());
                    fiscalPeriod.setEndDate(fsPanel.getEndDatePicker().getDate());

                    LimaServiceFactory.getService(
                            FiscalPeriodService.class).
                            createFiscalPeriod(fiscalPeriod);

                } catch (LimaException ex) {
                    if (log.isErrorEnabled()) {
                        log.error("Can't create fiscal period", ex);
                    }
                }
                view.dispose();
        }
    }
}
