package org.chorem.lima.ui.financialtransactionsearch;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JToolBar.Separator;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.FinancialStatementWayEnum;
import org.chorem.lima.enums.ComboBoxAccountsEnum;
import org.chorem.lima.enums.ComboBoxEntryBooksEnum;
import org.chorem.lima.enums.ComboBoxLetterEnum;
import org.chorem.lima.enums.ComboBoxOperatorsEnum;
import org.chorem.lima.enums.ComboBoxPeriodEnum;
import org.chorem.lima.ui.Filter.financialTransactionCondition.FinancialTransactionConditionView;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionDefaultTable;
import static org.nuiton.i18n.I18n.t;

public class FinancialTransactionSearchView extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_FIELD_SIZE = "fieldSize";
    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_SELECTED_ROW = "selectedRow";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK2Wz28bRRTHJ6ZOcEKgNG1oSyhpaw4IsS4NBaoUKElkhcgtKGuqgEFivDuxpxrPLDOz2HBA/An8CXDngsSNE+LAmQMXxL+AEAeuiDe7sTduJpNRtz6sV/Pe+77PvPnx9vu/UFVJdPk+Ho0CmXJNByTYeWdv773ufRLpLaIiSRMtJMp/MxVU6aCFeDKuNLraaZnwxkF4Y1MMEsEJPxS93kLzSn/BiOoTojV6bjoiUqoRTszroySVY9UJlE3123/+rnwTf/1dBaFRAnQXYSqrJ0UVMznVQhUaa3QGMn2OGwzzHmBIynvAu2jGNhlW6i4ekM/QV2iuhWYTLEFMoyv+U840svhRotFcvY27jFzTqCVkL4j6QpJBwOgABykN9inHPKKYaYm5wpGmgiuCZdQPmmNTuzCFmekeJcMkyVLMQoI+5jEjUqPwUSbYzlWLPAuKMNghJN4VQ42eNtUKTAWDDSEYwbzwrO1TwuKQfkmg1JkfHupgC+rGFeQoHOfrO20I3sASynPWeI4CNYTlCMbjxrFWCNd3NlKtBQf3pSn3fNi4nTvq/YoZuHiM8brLuGYxnp1A10MC2wPD2gPPJRt+4XFMglc9E2RTuHqMyA3XFF5zGV93Gd/wZLvuYrtpEZmfLMw1zxRrlhSFim19L+9bdvem4DE1L2aDa/Sh5bw0KdNEBs5o68mZ0p7etov1nTCSgrH3MTcXwTNTW6UwTUfVbQz5+cxulDsiJkyj3Ud16AvR4oA+fwKDRtue6a2Jt8g+TpnOpEzGNw9tghZVOsxuHHDMsB48ZEc9AFyiZ6f6AXSaoOg0RSuY6aCqTGFYo/Odo81pF0x5Wzr/QFsygpn1v+Wl33/688fmuBetQO5zVtdDrRR6RCJFArc1NamfyhtRqilr3MHJegfV8ls267MrFrDwwAxwkC+/hU14sI1VHySqc3/8/Mvyp789hipNNM8EjpvY+L+LarovoQqCxaPk7dsZ0RPDx+F52rCZWxu8db6qZ25Rzignq1hDe+ymmrw1glqsWGoxAerWfv13Kfzh9rgeM8B34Vj3oibVj9Bsni3rzgeN19qNFxJF0lgUDdbWcmfM/3JysInvZs9d24RP0UhwjZ68FcO0V7sUzi/vwTxNwL1sAuZtL9O74KG3oOHaatOkTUbaOH3wsFJm+GPz+MSusOKl0HUw+Cm4GC6VZvBTcDGslmbwU3AxvFCawU/BxfBiaQY/BRfDS6UZ/BRcDC+XZvBTcDE0SjP4KbgY1koz+Cm4GG6UZvBTcDHc9Gd4aAWNqgPz6eEQ2fIQqUkx3Ca013d1Dh+hRXX4i+gEqv8BN8rfBA0QAAA=";
    public static final String PROPERTY$LIST_SELECTION_MODEL0 = "$ListSelectionModel0";
    private static final Log log = LogFactory.getLog(FinancialTransactionSearchView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Dimension fieldSize;
    protected FinancialTransactionConditionView financialTransactionConditionView;
    protected FinancialTransactionDefaultTable financialTransactionSearchTable;
    protected FinancialTransactionSearchTableModel financialTransactionSearchTableModel;
    protected FinancialTransactionSearchViewHandler handler;
    protected Boolean selectedRow;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JButton $JButton0;
    private JButton $JButton1;
    private JButton $JButton10;
    private JButton $JButton11;
    private JButton $JButton2;
    private JButton $JButton3;
    private JButton $JButton4;
    private JButton $JButton5;
    private JButton $JButton6;
    private JButton $JButton7;
    private JButton $JButton8;
    private JButton $JButton9;
    private JScrollPane $JScrollPane0;
    private Separator $JToolBar$Separator0;
    private Separator $JToolBar$Separator1;
    private Separator $JToolBar$Separator2;
    private Separator $JToolBar$Separator3;
    private JToolBar $JToolBar0;
    private ListSelectionModel $ListSelectionModel0;
    private FinancialTransactionSearchView $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FinancialTransactionSearchView() {
        $initialize();
    }

    public FinancialTransactionSearchView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addDateCondition();
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addDateIntervalCondition();
    }

    public void doActionPerformed__on__$JButton10(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addCreditCondition();
    }

    public void doActionPerformed__on__$JButton11(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().refresh();
    }

    public void doActionPerformed__on__$JButton2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addFinancialPeriodCondition();
    }

    public void doActionPerformed__on__$JButton3(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addFiscalPeriodCondition();
    }

    public void doActionPerformed__on__$JButton4(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addEntryBookCondition();
    }

    public void doActionPerformed__on__$JButton5(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addVoucherCondition();
    }

    public void doActionPerformed__on__$JButton6(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addAccountCondition();
    }

    public void doActionPerformed__on__$JButton7(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addDescriptionCondition();
    }

    public void doActionPerformed__on__$JButton8(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addLetteringCondition();
    }

    public void doActionPerformed__on__$JButton9(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addDebitCondition();
    }

    public void doValueChanged__on__$ListSelectionModel0(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setSelectedRow(financialTransactionSearchTable.getSelectedRow() != -1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Dimension getFieldSize() {
        return fieldSize;
    }

    public FinancialTransactionConditionView getFinancialTransactionConditionView() {
        return financialTransactionConditionView;
    }

    public FinancialTransactionDefaultTable getFinancialTransactionSearchTable() {
        return financialTransactionSearchTable;
    }

    public FinancialTransactionSearchTableModel getFinancialTransactionSearchTableModel() {
        return financialTransactionSearchTableModel;
    }

    public FinancialTransactionSearchViewHandler getHandler() {
        return handler;
    }

    public Boolean getSelectedRow() {
        return selectedRow;
    }

    public Boolean isSelectedRow() {
        return selectedRow !=null && selectedRow;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$ListSelectionModel0(ListSelectionModel $ListSelectionModel0) {
        ListSelectionModel oldValue = this.$ListSelectionModel0;
        this.$ListSelectionModel0 = $ListSelectionModel0;
        firePropertyChange(PROPERTY$LIST_SELECTION_MODEL0, oldValue, $ListSelectionModel0);
    }

    public void setFieldSize(Dimension fieldSize) {
        Dimension oldValue = this.fieldSize;
        this.fieldSize = fieldSize;
        firePropertyChange(PROPERTY_FIELD_SIZE, oldValue, fieldSize);
    }

    public void setHandler(FinancialTransactionSearchViewHandler handler) {
        FinancialTransactionSearchViewHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    public void setSelectedRow(Boolean selectedRow) {
        Boolean oldValue = this.selectedRow;
        this.selectedRow = selectedRow;
        firePropertyChange(PROPERTY_SELECTED_ROW, oldValue, selectedRow);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JButton get$JButton10() {
        return $JButton10;
    }

    protected JButton get$JButton11() {
        return $JButton11;
    }

    protected JButton get$JButton2() {
        return $JButton2;
    }

    protected JButton get$JButton3() {
        return $JButton3;
    }

    protected JButton get$JButton4() {
        return $JButton4;
    }

    protected JButton get$JButton5() {
        return $JButton5;
    }

    protected JButton get$JButton6() {
        return $JButton6;
    }

    protected JButton get$JButton7() {
        return $JButton7;
    }

    protected JButton get$JButton8() {
        return $JButton8;
    }

    protected JButton get$JButton9() {
        return $JButton9;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Separator get$JToolBar$Separator0() {
        return $JToolBar$Separator0;
    }

    protected Separator get$JToolBar$Separator1() {
        return $JToolBar$Separator1;
    }

    protected Separator get$JToolBar$Separator2() {
        return $JToolBar$Separator2;
    }

    protected Separator get$JToolBar$Separator3() {
        return $JToolBar$Separator3;
    }

    protected JToolBar get$JToolBar0() {
        return $JToolBar0;
    }

    protected ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createFieldSize() {
        $objectMap.put("fieldSize", fieldSize = new java.awt.Dimension());
    }

    protected void createFinancialTransactionConditionView() {
        $objectMap.put("financialTransactionConditionView", financialTransactionConditionView = new FinancialTransactionConditionView());
        
        financialTransactionConditionView.setName("financialTransactionConditionView");
    }

    protected void createFinancialTransactionSearchTable() {
        $objectMap.put("financialTransactionSearchTable", financialTransactionSearchTable = new FinancialTransactionDefaultTable(handler));
        
        financialTransactionSearchTable.setName("financialTransactionSearchTable");
        financialTransactionSearchTable.setRowHeight(22);
    }

    protected void createFinancialTransactionSearchTableModel() {
        $objectMap.put("financialTransactionSearchTableModel", financialTransactionSearchTableModel = new FinancialTransactionSearchTableModel());
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new FinancialTransactionSearchViewHandler(this));
    }

    protected void createSelectedRow() {
        $objectMap.put("selectedRow", selectedRow = false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($JToolBar0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(financialTransactionConditionView, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JToolBar0
        $JToolBar0.add($JButton0);
        $JToolBar0.add($JButton1);
        $JToolBar0.add($JButton2);
        $JToolBar0.add($JButton3);
        $JToolBar0.add($JToolBar$Separator0);
        $JToolBar0.add($JButton4);
        $JToolBar0.add($JToolBar$Separator1);
        $JToolBar0.add($JButton5);
        $JToolBar0.add($JButton6);
        $JToolBar0.add($JButton7);
        $JToolBar0.add($JButton8);
        $JToolBar0.add($JToolBar$Separator2);
        $JToolBar0.add($JButton9);
        $JToolBar0.add($JButton10);
        $JToolBar0.add($JToolBar$Separator3);
        $JToolBar0.add($JButton11);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(financialTransactionSearchTable);
        
        // apply 15 property setters
        $JButton0.setIcon(SwingUtil.createActionIcon("filter-transaction-date"));
        $JButton1.setIcon(SwingUtil.createActionIcon("filter-transaction-interval"));
        $JButton2.setIcon(SwingUtil.createActionIcon("filter-transaction-financial-period"));
        $JButton3.setIcon(SwingUtil.createActionIcon("filter-transaction-fiscal-period"));
        $JButton4.setIcon(SwingUtil.createActionIcon("filter-transaction-entrybook"));
        $JButton5.setIcon(SwingUtil.createActionIcon("filter-transaction-voucher"));
        $JButton6.setIcon(SwingUtil.createActionIcon("filter-transaction-account"));
        $JButton7.setIcon(SwingUtil.createActionIcon("filter-transaction-description"));
        $JButton8.setIcon(SwingUtil.createActionIcon("filter-transaction-letter"));
        $JButton9.setIcon(SwingUtil.createActionIcon("filter-transaction-debit"));
        $JButton10.setIcon(SwingUtil.createActionIcon("filter-transaction-credit"));
        $JButton11.setIcon(SwingUtil.createActionIcon("refresh"));
        $JButton11.setToolTipText( t("lima.ui.common.refresh") + " (F5)");
        financialTransactionSearchTable.setModel(getFinancialTransactionSearchTableModel());
        financialTransactionSearchTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createSelectedRow();
        createFieldSize();
        // inline creation of $JToolBar0
        $objectMap.put("$JToolBar0", $JToolBar0 = new JToolBar());
        
        $JToolBar0.setName("$JToolBar0");
        $JToolBar0.setFloatable(false);
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setToolTipText(t("lima.filter.date.one"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setToolTipText(t("lima.filter.date.interval"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setToolTipText(t("lima.filter.date.financial.period"));
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of $JButton3
        $objectMap.put("$JButton3", $JButton3 = new JButton());
        
        $JButton3.setName("$JButton3");
        $JButton3.setToolTipText(t("lima.filter.date.fiscal.period"));
        $JButton3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton3"));
        // inline creation of $JToolBar$Separator0
        $objectMap.put("$JToolBar$Separator0", $JToolBar$Separator0 = new Separator());
        
        $JToolBar$Separator0.setName("$JToolBar$Separator0");
        // inline creation of $JButton4
        $objectMap.put("$JButton4", $JButton4 = new JButton());
        
        $JButton4.setName("$JButton4");
        $JButton4.setToolTipText(t("lima.filter.entrybook"));
        $JButton4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton4"));
        // inline creation of $JToolBar$Separator1
        $objectMap.put("$JToolBar$Separator1", $JToolBar$Separator1 = new Separator());
        
        $JToolBar$Separator1.setName("$JToolBar$Separator1");
        // inline creation of $JButton5
        $objectMap.put("$JButton5", $JButton5 = new JButton());
        
        $JButton5.setName("$JButton5");
        $JButton5.setToolTipText(t("lima.filter.voucher"));
        $JButton5.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton5"));
        // inline creation of $JButton6
        $objectMap.put("$JButton6", $JButton6 = new JButton());
        
        $JButton6.setName("$JButton6");
        $JButton6.setToolTipText(t("lima.filter.account"));
        $JButton6.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton6"));
        // inline creation of $JButton7
        $objectMap.put("$JButton7", $JButton7 = new JButton());
        
        $JButton7.setName("$JButton7");
        $JButton7.setToolTipText(t("lima.filter.description"));
        $JButton7.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton7"));
        // inline creation of $JButton8
        $objectMap.put("$JButton8", $JButton8 = new JButton());
        
        $JButton8.setName("$JButton8");
        $JButton8.setToolTipText(t("lima.filter.letter"));
        $JButton8.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton8"));
        // inline creation of $JToolBar$Separator2
        $objectMap.put("$JToolBar$Separator2", $JToolBar$Separator2 = new Separator());
        
        $JToolBar$Separator2.setName("$JToolBar$Separator2");
        // inline creation of $JButton9
        $objectMap.put("$JButton9", $JButton9 = new JButton());
        
        $JButton9.setName("$JButton9");
        $JButton9.setToolTipText(t("lima.filter.debit"));
        $JButton9.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton9"));
        // inline creation of $JButton10
        $objectMap.put("$JButton10", $JButton10 = new JButton());
        
        $JButton10.setName("$JButton10");
        $JButton10.setToolTipText(t("lima.filter.credit"));
        $JButton10.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton10"));
        // inline creation of $JToolBar$Separator3
        $objectMap.put("$JToolBar$Separator3", $JToolBar$Separator3 = new Separator());
        
        $JToolBar$Separator3.setName("$JToolBar$Separator3");
        // inline creation of $JButton11
        $objectMap.put("$JButton11", $JButton11 = new JButton());
        
        $JButton11.setName("$JButton11");
        $JButton11.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton11"));
        createFinancialTransactionConditionView();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFinancialTransactionSearchTableModel();
        createFinancialTransactionSearchTable();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = getFinancialTransactionSearchTable().getSelectionModel());
        
        $ListSelectionModel0.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__$ListSelectionModel0"));
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

}