package org.chorem.lima.ui.Filter.StringCondition;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.beans.AbstractStringCondition;
import org.chorem.lima.ui.common.LabelListCellRenderer;
import static org.nuiton.i18n.I18n.t;

public class StringConditionView extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUPW8TQRBdm9iOk0ACVqxEBCmQSEggzoiGIgFCjKwkMiCRCEW4Yc83sjesb5fdveRoED+BnwA9DRIdFaKgpqBB/AWEKGgRs3f+yIVLsIiLsz0z782b8Ru/+U5yWpHzOzQMHRX4hnXA2bi9vX3f3YGmuQO6qZg0QpH4lcmSbIOMe/24NmShUbfwShdeqYqOFD74+9BLdTKmzTMOug1gDDmXRDS1rmz200uhDFSPtS8qjfXVzx/Zl96L11lCQonqCjjK/L9Qg0lG6iTLPEPOYKddWuHUb6EMxfwW6j1pY1VOtb5HO/CUPCeFOslLqpDMkAvDjxxxRPhQGlJY3KIuh6uG3BCq5TTbQkHH4axDnYA5NcYNKCcWURW+xwwT/sHvDxnsSRlx5pGxTX2PgzJk5b8Z12KKAWlxcWM1MEb4KLRkNxE6eg8RTjdsy4r96hynLnBcZKKyboPJwkkhQWEv3JcrVkVoyHQC0osnUUUDoakx4PhblRP1W71EEjCtwdc42C5UqYZqG5pP0pp1412sImcT1kFTOgNTDlyTaZCcCjBsyEzjbx8/wFTs4JkDDraEUfZ3ufTl/bd3tZ5ti9h7OrV039WhnaSy6zPMtp6MPRsYxit3qVxqIAtwPNnoJOdShG120ygO+522cMfCnTWq20iRK3z98LH8+PMJkq2RMS6oV6O2fh3331a4BcG9UN5aiRRN7I3ic8pqM2SENYVvyKlljxo67zI0ld+6GeIK5lJW0NfhFj/9Km2+XemtIYOyZg8tH6wi94jkmc+ZD9H9dk8z9V7HpYbAE4MTTDvKjH2fkl3zL0TPi2lzjhsh+BaT1nVo9uVYxDw1eExuYABHttjL0Sz205WhqUesxW32WjpHaQiOXEd48cFdSicpD0Eyiv9vHihQx+SZiN0I3rqBzrG4bPj6EQyzw0zVU3MEz9zwSg75kSzDH7wJLP9RBwAA";
    private static final Log log = LogFactory.getLog(StringConditionView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected StringConditionHandler handler;
    protected JLabel label;
    protected JComboBox operandComboBox;
    protected JCheckBox sensitiveCaseCheckBox;
    protected JTextField textField;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JButton $JButton0;
    private StringConditionView $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public StringConditionView() {
        $initialize();
    }

    public StringConditionView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.delete();
    }

    public void doActionPerformed__on__sensitiveCaseCheckBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setSensitiveCase(event);
    }

    public void doItemStateChanged__on__operandComboBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.operandSelected(event);
    }

    public void doKeyReleased__on__textField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public StringConditionHandler getHandler() {
        return handler;
    }

    public JLabel getLabel() {
        return label;
    }

    public JComboBox getOperandComboBox() {
        return operandComboBox;
    }

    public JCheckBox getSensitiveCaseCheckBox() {
        return sensitiveCaseCheckBox;
    }

    public JTextField getTextField() {
        return textField;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setHandler(StringConditionHandler handler) {
        StringConditionHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createHandler() {
        $objectMap.put("handler", handler = new StringConditionHandler(this));
    }

    protected void createLabel() {
        $objectMap.put("label", label = new JLabel());
        
        label.setName("label");
        label.setText(t(""));
    }

    protected void createOperandComboBox() {
        $objectMap.put("operandComboBox", operandComboBox = new JComboBox());
        
        operandComboBox.setName("operandComboBox");
        operandComboBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__operandComboBox"));
    }

    protected void createSensitiveCaseCheckBox() {
        $objectMap.put("sensitiveCaseCheckBox", sensitiveCaseCheckBox = new JCheckBox());
        
        sensitiveCaseCheckBox.setName("sensitiveCaseCheckBox");
        sensitiveCaseCheckBox.setText(t("lima.filer.condition.sensitive.case"));
        sensitiveCaseCheckBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__sensitiveCaseCheckBox"));
    }

    protected void createTextField() {
        $objectMap.put("textField", textField = new JTextField());
        
        textField.setName("textField");
        textField.setColumns(15);
        textField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__textField"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($JButton0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(label, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(operandComboBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(textField, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(sensitiveCaseCheckBox, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 6 property setters
        $JButton0.setIcon(SwingUtil.createActionIcon("remove-condition"));
        operandComboBox.setModel(new DefaultComboBoxModel(AbstractStringCondition.Operand.values()));
        operandComboBox.setRenderer(new LabelListCellRenderer());
        operandComboBox.setSelectedItem(handler.getOperand());
        SwingUtil.setText(textField, handler.getText());
        
        sensitiveCaseCheckBox.setSelected(handler.isSensitiveCase());
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setToolTipText(t("lima.filter.condition.delete"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createLabel();
        createOperandComboBox();
        createTextField();
        createSensitiveCaseCheckBox();
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

}