package org.chorem.lima.ui.Filter.EntryBookCondition;

/*
 * #%L
 * Lima :: Swing
 * $Id: EntryBookConditionHandler.java 3701 2013-08-02 17:00:32Z tchemit $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.3/lima-swing/src/main/java/org/chorem/lima/ui/Filter/EntryBookCondition/EntryBookConditionHandler.java $
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.beans.Condition;
import org.chorem.lima.beans.EntryBookCondition;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.api.EntryBookService;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.Filter.ConditionHandler;
import org.chorem.lima.ui.Filter.financialTransactionCondition.FinancialTransactionConditionHandler;

import javax.swing.*;
import javax.swing.event.ListSelectionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author Sylvain Bavencoff <bavencoff@codelutin.com>
 */
public class EntryBookConditionHandler implements ConditionHandler {

    private static final Log log = LogFactory.getLog(EntryBookConditionHandler.class);

    protected EntryBookConditionView view;

    protected EntryBookCondition condition;

    protected FinancialTransactionConditionHandler filterHandler;

    public EntryBookConditionHandler(EntryBookConditionView view) {
        this.view = view;
        this.condition = new EntryBookCondition();
    }

    @Override
    public Condition getCondition() {
        return condition;
    }

    @Override
    public JComponent getView() {
        return view;
    }

    @Override
    public void setFilterHandler(FinancialTransactionConditionHandler filterHandler) {
        this.filterHandler = filterHandler;
    }

    public Object[] getEntryBookList() {
        EntryBookService entryBookService = LimaServiceFactory.getService(EntryBookService.class);
        Object[] result = {};
        List<EntryBook> periods = null;
        try {
            periods = entryBookService.getAllEntryBooks();
            result = periods.toArray();
        } catch (LimaException ex) {
            if (log.isDebugEnabled()) {
                log.debug("Can't get Financial Period list", ex);
            }
        }
        return result;
    }

    public void setEntryBook(ListSelectionEvent event) {
        JList entryBookList = view.getEntryBookList();
        List selectedValuesList = new ArrayList(Arrays.asList(entryBookList.getSelectedValues()));
        condition.setEntryBooks(selectedValuesList);
    }

    public void delete() {
        filterHandler.removeCondition(this);
    }
}
