/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.application.web.request;

import fr.ird.observe.application.web.ObserveWebApplicationContext;
import fr.ird.observe.services.ObserveService;
import fr.ird.observe.services.ObserveServiceInitializer;
import fr.ird.observe.services.configuration.ObserveDataSourceConfiguration;
import fr.ird.observe.services.configuration.ObserveDataSourceConfigurationAndConnection;
import fr.ird.observe.services.dto.ObserveSpeciesListConfiguration;
import fr.ird.observe.services.dto.constants.ReferentialLocale;
import fr.ird.observe.services.security.AdminApiKeyNotFoundException;
import fr.ird.observe.services.security.AuthenticationTokenNotFoundException;
import fr.ird.observe.services.security.InvalidAdminKeyApiException;
import java.io.File;
import java.util.Locale;
import org.debux.webmotion.server.call.HttpContext;

public class ObserveWebRequestContext {
    private static final String REQUEST_OBSERVE_WEB_REQUEST_CONTEXT = ObserveWebRequestContext.class.getName();
    private final ObserveWebApplicationContext applicationContext;
    private final Locale applicationLocale;
    private final ReferentialLocale referentialLocale;
    private final ObserveSpeciesListConfiguration speciesListConfiguration;
    private final String optionalAdminApiKey;
    private final String optionalAuthenticationToken;

    public static ObserveWebRequestContext getRequestContext(HttpContext httpContext) {
        return (ObserveWebRequestContext)httpContext.getRequest().getAttribute(REQUEST_OBSERVE_WEB_REQUEST_CONTEXT);
    }

    public static void setRequestContext(HttpContext httpContext, ObserveWebRequestContext serviceContext) {
        httpContext.getRequest().setAttribute(REQUEST_OBSERVE_WEB_REQUEST_CONTEXT, (Object)serviceContext);
    }

    public ObserveWebRequestContext(ObserveWebApplicationContext applicationContext, Locale applicationLocale, ReferentialLocale referentialLocale, ObserveSpeciesListConfiguration speciesListConfiguration, String adminApiKey, String authenticationToken) {
        this.applicationContext = applicationContext;
        this.applicationLocale = applicationLocale;
        this.referentialLocale = referentialLocale;
        this.speciesListConfiguration = speciesListConfiguration;
        this.optionalAdminApiKey = adminApiKey;
        this.optionalAuthenticationToken = authenticationToken;
    }

    public ObserveWebApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public <S extends ObserveService> S newService(Class<S> serviceType, ObserveDataSourceConfiguration dataSourceConfiguration) {
        ObserveServiceInitializer observeServiceInitializer = ObserveServiceInitializer.create((Locale)this.applicationLocale, (ReferentialLocale)this.referentialLocale, (File)this.applicationContext.getApplicationConfiguration().getTemporaryDirectory(), (ObserveSpeciesListConfiguration)this.speciesListConfiguration, (ObserveDataSourceConfiguration)dataSourceConfiguration);
        return (S)this.applicationContext.newService(observeServiceInitializer, serviceType);
    }

    public <S extends ObserveService> S newService(Class<S> serviceType, ObserveDataSourceConfigurationAndConnection configurationAndConnection) {
        ObserveServiceInitializer observeServiceInitializer = ObserveServiceInitializer.create((Locale)this.applicationLocale, (ReferentialLocale)this.referentialLocale, (File)this.applicationContext.getApplicationConfiguration().getTemporaryDirectory(), (ObserveSpeciesListConfiguration)this.speciesListConfiguration, (ObserveDataSourceConfigurationAndConnection)configurationAndConnection);
        return (S)this.applicationContext.newService(observeServiceInitializer, serviceType);
    }

    public void checkAdminApiKeyIsValid() {
        this.checkAdminApiKeyIsPresent();
        String configurationAdminKey = this.applicationContext.getApplicationConfiguration().getAdminApiKey();
        if (!configurationAdminKey.equals(this.optionalAdminApiKey)) {
            throw new InvalidAdminKeyApiException(this.optionalAdminApiKey);
        }
    }

    public String getAuthenticationToken() {
        this.checkAuthenticationTokenIsPresent();
        return this.optionalAuthenticationToken;
    }

    private void checkAdminApiKeyIsPresent() {
        if (this.optionalAdminApiKey == null) {
            throw new AdminApiKeyNotFoundException();
        }
    }

    private void checkAuthenticationTokenIsPresent() {
        if (this.optionalAuthenticationToken == null) {
            throw new AuthenticationTokenNotFoundException();
        }
    }
}

