/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.PopulationGroupAbstract;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.util.EvaluatorHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.LazyInitializationException;

public class PopulationGroupImpl
extends PopulationGroupAbstract {
    private static final Log log = LogFactory.getLog(PopulationGroupImpl.class);
    private static final long serialVersionUID = 1L;
    private String toStringCache;

    @Override
    public double getAge() {
        double result = 0.0;
        if (this.getPopulation() != null && this.getPopulation().getSpecies() != null) {
            result = this.getPopulation().getSpecies().isAgeGroupType() ? super.getAge() : this.getPopulation().getAge(this.getLength(), this) / (double)Month.NUMBER_OF_MONTH;
        }
        return result;
    }

    @Override
    public double getLength() {
        double result = 0.0;
        if (this.getPopulation() != null && this.getPopulation().getSpecies() != null) {
            result = !this.getPopulation().getSpecies().isAgeGroupType() ? (this.getMinLength() + this.getMaxLength()) / 2.0 : this.getPopulation().getLength(this.getAge() * (double)Month.NUMBER_OF_MONTH, this);
        }
        return result;
    }

    @Override
    public boolean isInLength(double length) {
        boolean result = this.getMinLength() <= length && length <= this.getMaxLength();
        return result;
    }

    @Override
    public double getMeanWeight() {
        double result = 0.0;
        Equation eq = this.getPopulation().getMeanWeight();
        if (eq != null) {
            try {
                result = eq.evaluate("group", this);
            }
            catch (Exception ex) {
                EvaluatorHelper.catchEvaluateException(ex, log);
            }
        }
        return result;
    }

    @Override
    public double getNaturalDeathRate(Zone zone) {
        double result = 0.0;
        Equation eq = this.getPopulation().getNaturalDeathRate();
        if (eq != null) {
            try {
                result = eq.evaluate("pop", this.getPopulation(), "group", this, "zone", zone);
            }
            catch (Exception ex) {
                EvaluatorHelper.catchEvaluateException(ex, log);
            }
        }
        return result;
    }

    @Override
    public double getFishingMortalityOtherFleets(Zone zone) {
        double result = 0.0;
        Equation eq = this.getPopulation().getFishingMortalityOtherFleets();
        if (eq != null) {
            try {
                result = eq.evaluate("pop", this.getPopulation(), "group", this, "zone", zone);
            }
            catch (Exception ex) {
                EvaluatorHelper.catchEvaluateException(ex, log);
            }
        }
        return result;
    }

    @Override
    public double getPrice() {
        double result = 0.0;
        Equation eq = this.getPopulation().getPrice();
        if (eq != null) {
            try {
                result = eq.evaluate("group", this);
            }
            catch (Exception ex) {
                EvaluatorHelper.catchEvaluateException(ex, log);
            }
        }
        return result;
    }

    @Override
    public double getMaturityOgive() {
        double result = 0.0;
        Equation eq = this.getPopulation().getMaturityOgiveEquation();
        if (eq != null) {
            try {
                result = eq.evaluate("group", this);
            }
            catch (Exception ex) {
                EvaluatorHelper.catchEvaluateException(ex, log);
            }
        }
        return result;
    }

    @Override
    public double getReproductionRate() {
        double result = 0.0;
        Equation eq = this.getPopulation().getReproductionRateEquation();
        if (eq != null) {
            try {
                result = eq.evaluate("group", this);
            }
            catch (Exception ex) {
                EvaluatorHelper.catchEvaluateException(ex, log);
            }
        }
        return result;
    }

    @Override
    public String toString() {
        if (this.toStringCache == null) {
            try {
                this.toStringCache = String.valueOf(this.getPopulation()) + " Group " + this.getId();
            }
            catch (LazyInitializationException e) {
                this.toStringCache = "Unknow Population Group " + this.getId();
            }
        }
        return this.toStringCache;
    }
}

