/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui.control;

import fr.ifremer.coser.CoserConstants;
import fr.ifremer.coser.bean.Project;
import fr.ifremer.coser.control.ControlError;
import fr.ifremer.coser.control.ControlErrorGroup;
import fr.ifremer.coser.control.DiffCatchLengthControlError;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableNode;
import org.nuiton.i18n.I18n;

public class GlobalControlErrorModel
extends DefaultTreeTableModel {
    protected List<ControlError> controlErrors;
    protected Set<Object> checkedControlErrors;

    public GlobalControlErrorModel() {
        super(null);
    }

    public void setControlErrors(Project project, List<ControlError> controlErrors) {
        this.controlErrors = controlErrors;
        this.buildGlobalControlErrorTreeModel(project, controlErrors);
        this.checkedControlErrors = new HashSet<Object>();
    }

    public List<ControlError> getControlErrors() {
        return this.controlErrors;
    }

    protected void buildGlobalControlErrorTreeModel(Project project, List<ControlError> validationErrors) {
        HashMap<Object, DefaultMutableTreeTableNode> nodeCache = new HashMap<Object, DefaultMutableTreeTableNode>();
        DefaultMutableTreeTableNode root = new DefaultMutableTreeTableNode(null);
        for (ControlError validationError : validationErrors) {
            DefaultMutableTreeTableNode parentNode;
            Object category = validationError.getCategory() == null ? I18n.n((String)"coser.ui.control.error.allCategories", (Object[])new Object[0]) : validationError.getCategory();
            DefaultMutableTreeTableNode categoryNode = (DefaultMutableTreeTableNode)nodeCache.get(category);
            if (categoryNode == null) {
                categoryNode = new DefaultMutableTreeTableNode(category);
                root.add((MutableTreeTableNode)categoryNode);
                nodeCache.put(category, categoryNode);
            }
            if ((parentNode = (DefaultMutableTreeTableNode)nodeCache.get(category + validationError.getMessage())) == null) {
                ControlErrorGroup group = new ControlErrorGroup(validationError.getCategory(), validationError.getLevel(), validationError.getMessage());
                parentNode = new DefaultMutableTreeTableNode((Object)group);
                categoryNode.add((MutableTreeTableNode)parentNode);
                nodeCache.put(category + validationError.getMessage(), parentNode);
            }
            if (validationError instanceof DiffCatchLengthControlError) {
                DiffCatchLengthControlError diffCatchError = (DiffCatchLengthControlError)validationError;
                String species = diffCatchError.getSpecies();
                String speciesCategory = I18n.t((String)"coser.ui.control.error.diffcatchlenghtspecies", (Object[])new Object[]{project.getDisplaySpeciesText(species)});
                ControlErrorGroup group = new ControlErrorGroup(validationError.getCategory(), validationError.getLevel(), speciesCategory);
                DefaultMutableTreeTableNode newParent = (DefaultMutableTreeTableNode)nodeCache.get(speciesCategory);
                if (newParent == null) {
                    newParent = new DefaultMutableTreeTableNode((Object)group);
                    parentNode.add((MutableTreeTableNode)newParent);
                    nodeCache.put(speciesCategory, newParent);
                }
                parentNode = newParent;
            }
            DefaultMutableTreeTableNode node = new DefaultMutableTreeTableNode((Object)validationError);
            parentNode.add((MutableTreeTableNode)node);
        }
        this.setRoot((TreeTableNode)root);
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int columnIndex) {
        String result = null;
        switch (columnIndex) {
            case 0: {
                result = I18n.t((String)"coser.ui.control.global.message", (Object[])new Object[0]);
            }
        }
        return result;
    }

    public Class<?> getColumnClass(int columnIndex) {
        Class result = null;
        switch (columnIndex) {
            case 0: {
                result = CoserConstants.ValidationLevel.class;
                break;
            }
            case 1: {
                result = Boolean.class;
            }
        }
        return result;
    }

    public Object getValueAt(Object node, int column) {
        Object result = null;
        switch (column) {
            case 0: {
                result = node;
                break;
            }
            default: {
                result = this.checkedControlErrors.contains(node);
            }
        }
        return result;
    }

    public boolean isCellEditable(Object node, int column) {
        boolean result = false;
        if (column == 1) {
            result = true;
        }
        return result;
    }

    public void setValueAt(Object value, Object node, int column) {
        Boolean booleanValue = (Boolean)value;
        if (booleanValue.booleanValue()) {
            this.checkedControlErrors.add(node);
        } else {
            this.checkedControlErrors.remove(node);
        }
        int childCount = this.getChildCount(node);
        for (int i = 0; i < childCount; ++i) {
            Object child = this.getChild(node, i);
            this.setValueAt(value, child, column);
        }
    }
}

